/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.LoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityFactory;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SecurityMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SecurityView view;
    private DDDataObject dObj;
    private ToolBarDesignEditor editor;
    private SecurityFactory factory;
    private RequestProcessor.Task repaintingTask;
    private WebApp webApp;
    private AddConstraintAction addConstraintAction;
    private RemoveConstraintAction removeConstraintAction;
    private int index;
    private boolean needInit = true;
    private static final String SECURITY_MV_ID = "dd_multiviewSecurity";
    private static final String HELP_ID_PREFIX = "dd_multiview_security_";
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement;

    public SecurityMultiViewElement(DDDataObject dObj, int index) {
        super((XmlMultiViewDataObject)dObj);
        this.dObj = dObj;
        this.index = index;
        this.editor = new ToolBarDesignEditor();
        this.factory = new SecurityFactory(this.editor, dObj);
        this.addConstraintAction = new AddConstraintAction(dObj);
        this.removeConstraintAction = new RemoveConstraintAction();
        this.setVisualEditor(this.editor);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SecurityMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!(this.dObj.isChangedFromUI() || (name = evt.getPropertyName()).indexOf("LoginConfig") <= 0 && name.indexOf("Security") <= 0)) {
            MultiViewPerspective perspective = this.dObj.getSelectedPerspective();
            if (perspective != null && SECURITY_MV_ID.equals(perspective.preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new SecurityView(this.webApp);
        this.editor.setContentView((PanelView)this.view);
        Object lastActive = this.editor.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            SecurityView securityView = this.view;
            SecurityRolesNode initialNode = this.view.getRolesNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            this.view.selectNode((Node)initialNode);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    private class RemoveConstraintAction
    extends AbstractAction {
        RemoveConstraintAction() {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"LBL_remove"));
            char mnem = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"TXT_RemoveSecurityConstraintConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
                SecurityConstraint constraint = (SecurityConstraint)sectionPanel.getKey();
                SecurityMultiViewElement.this.dObj.modelUpdatedFromUI();
                SecurityMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    SecurityMultiViewElement.this.webApp.removeSecurityConstraint(constraint);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                finally {
                    SecurityMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddConstraintAction
    extends AbstractAction {
        AddConstraintAction(DDDataObject dObj) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"LBL_AddSecurityConstraint"));
            char mnem = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"LBL_AddSecurityConstraint_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent evt) {
            SecurityMultiViewElement.this.dObj.modelUpdatedFromUI();
            SecurityMultiViewElement.this.dObj.setChangedFromUI(true);
            try {
                SecurityConstraint constraint = (SecurityConstraint)SecurityMultiViewElement.this.webApp.createBean("SecurityConstraint");
                constraint.setDisplayName(this.getUniqueDefaultName());
                SecurityMultiViewElement.this.webApp.addSecurityConstraint(constraint);
                SecurityView view = (SecurityView)SecurityMultiViewElement.this.editor.getContentView();
                SecurityConstraintNode node = new SecurityConstraintNode(constraint);
                view.getConstraintsNode().getChildren().add(new Node[]{node});
                SectionPanel pan = new SectionPanel((SectionView)view, (Node)node, (Object)constraint);
                pan.setHeaderActions(new Action[]{SecurityMultiViewElement.this.removeConstraintAction});
                view.getConstraintsContainer().addSection((NodeSectionPanel)pan, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private String getUniqueDefaultName() {
            String defaultNameEx;
            boolean found;
            int counter = 0;
            String defaultName = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"TXT_DefaultConstraintName");
            SecurityConstraint[] constraints = SecurityMultiViewElement.this.webApp.getSecurityConstraint();
            do {
                defaultNameEx = defaultName + ++counter;
                found = false;
                for (int i = 0; i < constraints.length; ++i) {
                    if (!defaultNameEx.equals(constraints[i].getDefaultDisplayName())) continue;
                    found = true;
                }
            } while (found);
            return defaultNameEx;
        }
    }

    private class LoginConfigNode
    extends AbstractNode {
        public LoginConfigNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"TTL_LoginConfig"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_loginconfigNode");
        }
    }

    private class SecurityConstraintNode
    extends AbstractNode {
        public SecurityConstraintNode(SecurityConstraint constraint) {
            super(Children.LEAF);
            this.setDisplayName(constraint.getDefaultDisplayName());
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_securityconstraintsNode");
        }
    }

    private class SecurityRolesNode
    extends AbstractNode {
        public SecurityRolesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$SecurityMultiViewElement), (String)"TTL_SecurityRoles"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_securityrolesNode");
        }
    }

    private class SecurityView
    extends SectionView {
        private WebApp webApp;
        private SecurityRolesNode rolesNode;
        private SectionContainerNode constraintsNode;
        private SectionContainer constraintsContainer;
        private LoginConfigNode configNode;

        public SecurityView(WebApp webApp) {
            super((InnerPanelFactory)SecurityMultiViewElement.this.factory);
            this.webApp = webApp;
            LoginConfig loginConfig = webApp.getSingleLoginConfig();
            this.configNode = new LoginConfigNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)this.configNode, (Object)"login_config"));
            SecurityRole[] roles = webApp.getSecurityRole();
            this.rolesNode = new SecurityRolesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)this.rolesNode, (Object)"security_roles"));
            SecurityConstraint[] constraints = webApp.getSecurityConstraint();
            Node[] nodes = new Node[constraints.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = new SecurityConstraintNode(constraints[i]);
            }
            ch.add(nodes);
            this.constraintsNode = new SectionContainerNode((Children)ch);
            this.constraintsContainer = new SectionContainer((SectionView)this, (Node)this.constraintsNode, NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_SecurityConstraints"), false);
            this.constraintsContainer.setHeaderActions(new Action[]{SecurityMultiViewElement.this.addConstraintAction});
            SectionPanel[] pan = new SectionPanel[constraints.length];
            for (int i = 0; i < nodes.length; ++i) {
                pan[i] = new SectionPanel((SectionView)this, nodes[i], (Object)constraints[i]);
                pan[i].setHeaderActions(new Action[]{SecurityMultiViewElement.this.removeConstraintAction});
                this.constraintsContainer.addSection((NodeSectionPanel)pan[i]);
            }
            this.addSection((NodeSectionPanel)this.constraintsContainer);
            this.constraintsNode.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = SecurityMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_SecurityConstraints"));
            ch = new Children.Array();
            ch.add(new Node[]{this.configNode, this.rolesNode, this.constraintsNode});
            AbstractNode root = new AbstractNode((Children)ch);
            this.setRoot((Node)root);
        }

        public SecurityRolesNode getRolesNode() {
            return this.rolesNode;
        }

        public SectionContainerNode getConstraintsNode() {
            return this.constraintsNode;
        }

        public SectionContainer getConstraintsContainer() {
            return this.constraintsContainer;
        }
    }
}

