/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Image;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JspUtils {
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static String getContentLanguage() {
        return "text/html";
    }

    public static String getScriptingLanguage() {
        return "text/x-java";
    }

    public static JSPColoringData getJSPColoringData(Document doc, FileObject fo) {
        return JspContextInfo.getContextInfo().getJSPColoringData(doc, fo);
    }

    public static JspParserAPI.ParseResult getCachedParseResult(Document doc, FileObject fo, boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        return JspContextInfo.getContextInfo().getCachedParseResult(doc, fo, successfulOnly, preferCurrent);
    }

    public static JspParserAPI.ParseResult getCachedParseResult(Document doc, FileObject fo, boolean successfulOnly, boolean preferCurrent) {
        return JspUtils.getCachedParseResult(doc, fo, successfulOnly, preferCurrent, false);
    }

    public static URLClassLoader getModuleClassLoader(Document doc, FileObject fo) {
        return JspContextInfo.getContextInfo().getModuleClassLoader(doc, fo);
    }

    public static FileObject guessWebModuleRoot(Document doc, FileObject fo) {
        return JspContextInfo.getContextInfo().guessWebModuleRoot(doc, fo);
    }

    public static Map getTaglibMap(Document doc, FileObject fo) {
        return JspContextInfo.getContextInfo().getTaglibMap(doc, fo);
    }

    public static Image getIcon(Document doc, FileObject fo) {
        return JspContextInfo.getContextInfo().getIcon(doc, fo);
    }

    public static String resolveRelativeURL(String relativeTo, String url) {
        String result;
        if (url.startsWith("/")) {
            result = "/";
            url = url.substring(1);
        } else {
            if (relativeTo == null || !relativeTo.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int lastSlash = (relativeTo = JspUtils.resolveRelativeURL(null, relativeTo)).lastIndexOf(47);
            if (lastSlash == -1) {
                throw new IllegalArgumentException();
            }
            result = relativeTo.substring(0, lastSlash + 1);
        }
        StringTokenizer st = new StringTokenizer(url, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (result.endsWith("/")) continue;
                result = result + "/";
                continue;
            }
            if (tok.equals("") || tok.equals(".")) continue;
            if (tok.equals("..")) {
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/");
                if (ls == -1) continue;
                result = withoutSlash.substring(0, ls + 1);
                continue;
            }
            result = result + tok;
        }
        return result;
    }

    public static String mapToString(Map m, String indent) {
        StringBuffer sb = new StringBuffer();
        for (Object key : m.keySet()) {
            sb.append(indent).append(key).append(" -> ").append(m.get(key)).append("\n");
        }
        return sb.toString();
    }

    public static boolean isInSubTree(FileObject folder, FileObject fo) {
        if (fo == folder) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)folder, (FileObject)fo);
    }

    public static String findRelativePath(FileObject rootFolder, FileObject relativeObject) {
        String rfp = rootFolder.getPath();
        String rop = relativeObject.getPath();
        if (!JspUtils.isInSubTree(rootFolder, relativeObject)) {
            throw new IllegalArgumentException("" + rootFolder + " / " + relativeObject);
        }
        String result = rop.substring(rfp.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String findRelativeContextPath(FileObject rootFolder, FileObject relativeObject) {
        String result = "/" + JspUtils.findRelativePath(rootFolder, relativeObject);
        return relativeObject.isFolder() ? result + "/" : result;
    }

    public static FileObject findRelativeFileObject(FileObject rootFolder, String relativePath) {
        FileObject myObj;
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        for (myObj = rootFolder; myObj != null && st.hasMoreTokens(); myObj = myObj.getFileObject(st.nextToken())) {
        }
        return myObj;
    }
}

