/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap.validation;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPOperation;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;

public class SOAPComponentValidator
implements Validator,
SOAPComponent.Visitor {
    private static final ResourceBundle mMessages = ResourceBundle.getBundle("org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.resources.Bundle");
    private Validation mValidation;
    private Validation.ValidationType mValidationType;
    private ValidationResult mValidationResult;
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        this.mValidation = validation;
        this.mValidationType = validationType;
        HashSet<Validator.ResultItem> results = new HashSet<Validator.ResultItem>();
        HashSet<Model> models = new HashSet<Model>();
        models.add(model);
        this.mValidationResult = new ValidationResult(results, models);
        if (model instanceof WSDLModel) {
            WSDLModel wsdlModel = (WSDLModel)model;
            if (model.getState() == Model.State.NOT_WELL_FORMED) {
                return EMPTY_RESULT;
            }
            Definitions defs = wsdlModel.getDefinitions();
            for (Binding binding : defs.getBindings()) {
                int numSoapBindings = binding.getExtensibilityElements(SOAPBinding.class).size();
                if (numSoapBindings > 0 && numSoapBindings != 1) {
                    results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, mMessages.getString("SOAPBindingValidator.Only_one_binding_allowed")));
                }
                Iterator soapBindings = binding.getExtensibilityElements(SOAPBinding.class).iterator();
                while (soapBindings.hasNext()) {
                    ((SOAPBinding)soapBindings.next()).accept(this);
                }
                for (BindingOperation bindingOp : binding.getBindingOperations()) {
                    BindingOutput bindingOutput;
                    List soapOpsList = bindingOp.getExtensibilityElements(SOAPOperation.class);
                    Iterator soapOps = soapOpsList.iterator();
                    while (soapOps.hasNext()) {
                        ((SOAPOperation)soapOps.next()).accept(this);
                    }
                    if (soapOpsList.size() <= 0) continue;
                    BindingInput bindingInput = bindingOp.getBindingInput();
                    if (bindingInput != null) {
                        for (SOAPHeader soapHeader : bindingInput.getExtensibilityElements(SOAPHeader.class)) {
                            soapHeader.accept(this);
                            Iterator<SOAPHeaderFault> soapHeaderFaults = soapHeader.getSOAPHeaderFaults().iterator();
                            while (soapHeaderFaults.hasNext()) {
                                soapHeaderFaults.next().accept(this);
                            }
                        }
                        int numSoapBodies = bindingInput.getExtensibilityElements(SOAPBody.class).size();
                        if (numSoapBodies == 0) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingInput, mMessages.getString("SOAPBodyValidator.Atleast_one_body_Required")));
                        } else if (numSoapBodies > 0 && numSoapBodies != 1) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingInput, mMessages.getString("SOAPBodyValidator.Only_one_body_allowed")));
                        }
                        Iterator soapBodies = bindingInput.getExtensibilityElements(SOAPBody.class).iterator();
                        while (soapBodies.hasNext()) {
                            ((SOAPBody)soapBodies.next()).accept(this);
                        }
                    }
                    if ((bindingOutput = bindingOp.getBindingOutput()) != null) {
                        for (SOAPHeader soapHeader : bindingOutput.getExtensibilityElements(SOAPHeader.class)) {
                            soapHeader.accept(this);
                            Iterator<SOAPHeaderFault> soapHeaderFaults = soapHeader.getSOAPHeaderFaults().iterator();
                            while (soapHeaderFaults.hasNext()) {
                                soapHeaderFaults.next().accept(this);
                            }
                        }
                        int numSoapBodies = bindingOutput.getExtensibilityElements(SOAPBody.class).size();
                        if (numSoapBodies == 0) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingOutput, mMessages.getString("SOAPBodyValidator.Atleast_one_body_Required")));
                        } else if (numSoapBodies > 0 && numSoapBodies != 1) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingOutput, mMessages.getString("SOAPBodyValidator.Only_one_body_allowed")));
                        }
                        Iterator soapBodies = bindingOutput.getExtensibilityElements(SOAPBody.class).iterator();
                        while (soapBodies.hasNext()) {
                            ((SOAPBody)soapBodies.next()).accept(this);
                        }
                    }
                    for (BindingFault bindingFault : bindingOp.getBindingFaults()) {
                        int numSoapFaults = bindingFault.getExtensibilityElements(SOAPFault.class).size();
                        if (numSoapFaults > 0 && numSoapFaults != 1) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingFault, mMessages.getString("SOAPFaultValidator.Only_one_fault_allowed")));
                        }
                        Iterator soapFaults = bindingFault.getExtensibilityElements(SOAPFault.class).iterator();
                        while (soapFaults.hasNext()) {
                            ((SOAPFault)soapFaults.next()).accept(this);
                        }
                    }
                }
            }
            Iterator<Service> services = defs.getServices().iterator();
            while (services.hasNext()) {
                for (Port port : services.next().getPorts()) {
                    Binding binding;
                    if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()) == null) continue;
                    int numRelatedSoapBindings = binding.getExtensibilityElements(SOAPBinding.class).size();
                    Iterator soapAddresses = port.getExtensibilityElements(SOAPAddress.class).iterator();
                    if (numRelatedSoapBindings > 0 && !soapAddresses.hasNext()) {
                        results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, mMessages.getString("SOAPAddressValidator.Missing_SoapAddress")));
                    }
                    if (port.getExtensibilityElements(SOAPAddress.class).size() > 1) {
                        results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, mMessages.getString("SOAPAddressValidator.Only_one_SoapAddress_allowed")));
                    }
                    while (soapAddresses.hasNext()) {
                        ((SOAPAddress)soapAddresses.next()).accept(this);
                    }
                }
            }
        }
        this.mValidation = null;
        this.mValidationType = null;
        ValidationResult rv = this.mValidationResult;
        this.mValidationResult = null;
        return rv;
    }

    public void visit(SOAPHeader header) {
        String namespace;
        String part;
        Collection results = this.mValidationResult.getValidationResult();
        NamedComponentReference<Message> message = header.getMessage();
        if (message == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)header, mMessages.getString("SOAPHeaderValidator.Missing_message")));
        }
        if ((part = header.getPart()) == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)header, mMessages.getString("SOAPHeaderValidator.Missing_part")));
        }
        try {
            SOAPMessageBase.Use use = header.getUse();
            if (use == null) {
                results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)header, mMessages.getString("SOAPHeaderValidator.Missing_use")));
            }
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)header, mMessages.getString("SOAPHeaderValidator.Unsupported_header_use_attribute")));
        }
        Collection<String> encodingStyles = header.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = header.getNamespace()) != null) {
            // empty if block
        }
    }

    public void visit(SOAPAddress address) {
        Collection results = this.mValidationResult.getValidationResult();
        String location = address.getLocation();
        if (location == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, mMessages.getString("SOAPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(location)) {
            return;
        }
        try {
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                return;
            }
            URL url = uri.toURL();
        }
        catch (Exception ex) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, mMessages.getString("SOAPAddressValidator.Unsupported_location_attribute")));
        }
    }

    public void visit(SOAPBinding binding) {
        Collection results = this.mValidationResult.getValidationResult();
        String transportURI = binding.getTransportURI();
        if (transportURI == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, mMessages.getString("SOAPBindingValidator.Transport_URI_required")));
        } else if (!transportURI.equals("http://schemas.xmlsoap.org/soap/http")) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, mMessages.getString("SOAPBindingValidator.Unsupported_transport")));
        }
        try {
            SOAPBinding.Style style = binding.getStyle();
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, mMessages.getString("SOAPBindingValidator.Unsupported_style_attribute")));
        }
    }

    public void visit(SOAPBody body) {
        String namespace;
        Collection results = this.mValidationResult.getValidationResult();
        Collection<String> encodingStyles = body.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = body.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAPMessageBase.Use use = body.getUse();
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)body, mMessages.getString("SOAPBodyValidator.Unsupported_use_attribute")));
        }
        List<String> parts = body.getParts();
        if (parts != null) {
            // empty if block
        }
    }

    public void visit(SOAPFault fault) {
        String namespace;
        Collection<String> encodingStyles;
        Collection results = this.mValidationResult.getValidationResult();
        String name = fault.getName();
        if (name == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fault, mMessages.getString("SOAPFaultValidator.Missing_name")));
        }
        if ((encodingStyles = fault.getEncodingStyles()) != null) {
            // empty if block
        }
        if ((namespace = fault.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAPMessageBase.Use use = fault.getUse();
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fault, mMessages.getString("SOAPFaultValidator.Unsupported_use_attribute")));
        }
    }

    public void visit(SOAPHeaderFault headerFault) {
        String namespace;
        String part;
        Collection results = this.mValidationResult.getValidationResult();
        NamedComponentReference<Message> message = headerFault.getMessage();
        if (message == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)headerFault, mMessages.getString("SOAPHeaderFaultValidator.Missing_header_fault_message")));
        }
        if ((part = headerFault.getPart()) == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)headerFault, mMessages.getString("SOAPHeaderFaultValidator.Missing_header_fault_part")));
        }
        try {
            SOAPMessageBase.Use use = headerFault.getUse();
            if (use == null) {
                results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)headerFault, mMessages.getString("SOAPHeaderFaultValidator.Missing_header_fault_use")));
            }
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)headerFault, mMessages.getString("SOAPHeaderFaultValidator.Unsupported_header_fault_use_attribute")));
        }
        Collection<String> encodingStyles = headerFault.getEncodingStyles();
        if (encodingStyles != null) {
            // empty if block
        }
        if ((namespace = headerFault.getNamespace()) != null) {
            // empty if block
        }
    }

    public void visit(SOAPOperation operation) {
        Collection results = this.mValidationResult.getValidationResult();
        String soapActionURI = operation.getSoapAction();
        if (soapActionURI != null) {
            // empty if block
        }
        try {
            SOAPBinding.Style style = operation.getStyle();
        }
        catch (Throwable th) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)operation, mMessages.getString("SOAPOperationValidator.Unsupported_style_attribute")));
        }
    }
}

