/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Documentation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.NotificationOperation;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.wsdl.model.spi.GenericExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.validator.visitor.MessageManager;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateConfiguration;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLSemanticsVisitor
implements WSDLVisitor {
    private static MessageManager mMsg = MessageManager.getManager(WSDLSemanticsVisitor.class);
    private ValidateSupport mValidateSupport = null;
    private static ValidateConfiguration mValConfig;
    public static final String VAL_FAULT_NOT_ALLOWED_IN_OPERATION = "VAL_FAULT_NOT_ALLOWED_IN_OPERATION";
    public static final String FIX_FAULT_NOT_ALLOWED_IN_OPERATION = "FIX_FAULT_NOT_ALLOWED_IN_OPERATION";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT";
    public static final String VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT = "VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT = "FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT";
    public static final String FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT = "FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT";
    public static final String VAL_SCHEMA_DEFINED_NOT_FOUND = "VAL_SCHEMA_DEFINED_NOT_FOUND";
    public static final String FIX_SCHEMA_DEFINED_NOT_FOUND = "FIX_SCHEMA_DEFINED_NOT_FOUND";
    public static final String VAL_NO_SCHEMA_DEFINED = "VAL_NO_SCHEMA_DEFINED";
    public static final String FIX_NO_SCHEMA_DEFINED = "FIX_NO_SCHEMA_DEFINED";
    public static final String VAL_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL = "VAL_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL";
    public static final String FIX_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL = "FIX_NO_PARTNERLINKTYPE_PORTTYPE_DEFINED_IN_WSDL";
    public static final String VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED = "VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED";
    public static final String FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED = "FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED";
    public static final String VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART = "VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_PART";
    public static final String FIX_VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_PART = "FIX_VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_PART";
    public static final String VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID = "FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID";
    public static final String VAL_MISSING_PORTTYPE_IN_BINDING = "VAL_MISSING_PORTTYPE_IN_BINDING";
    public static final String FIX_MISSING_PORTTYPE_IN_BINDING = "FIX_MISSING_PORTTYPE_IN_BINDING";
    public static final String VAL_MISSING_BINDING_IN_SERVICE_PORT = "VAL_MISSING_BINDING_IN_SERVICE_PORT";
    public static final String FIX_MISSING_BINDING_IN_SERVICE_PORT = "FIX_MISSING_BINDING_IN_SERVICE_PORT";
    public static final String VAL_MISSING_IMPORTED_DOCUMENT = "VAL_MISSING_IMPORTED_DOCUMENT";
    public static final String FIX_MISSING_IMPORTED_DOCUMENT = "FIX_MISSING_IMPORTED_DOCUMENT";
    public static final String VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE = "VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE";
    public static final String FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE = "FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE";
    public static final String VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE = "VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE";
    public static final String FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE = "FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE";
    public static final String VAL_DUPLICATE_OPRATION_FAULT_NAME = "VAL_DUPLICATE_OPRATION_FAULT_NAME";
    public static final String FIX_DUPLICATE_OPRATION_FAULT_NAME = "FIX_DUPLICATE_OPRATION_FAULT_NAME";
    public static final String VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE = "VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE";
    public static final String FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE = "FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE";
    private static final String VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE = "VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE";
    private static final String FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE = "FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE";
    private static final String VAL_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "VAL_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String FIX_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "FIX_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String VAL_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "VAL_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    private static final String FIX_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST = "FIX_IMPORT_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST";
    public List<Validator.ResultItem> mResultItems;
    private Validation mValidation;
    private List<Model> mValidatedModels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLSemanticsVisitor(Validation validation, List<Model> validatedModels) {
        Properties defaults = new Properties();
        defaults.setProperty("wsdl.syntax.attrib.required", "true");
        defaults.setProperty("wsdl.syntax.attrib.qname", "true");
        defaults.setProperty("wsdl.syntax.attrib.ncname", "false");
        defaults.setProperty("wsdl.syntax.attrib.boolean", "true");
        defaults.setProperty("wsdl.syntax.elem.min", "true");
        defaults.setProperty("wsdl.syntax.elem.required", "true");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            mValConfig = new ValidateConfiguration(defaults);
            this.mResultItems = new Vector<Validator.ResultItem>();
        }
        this.mValidation = validation;
        this.mValidatedModels = validatedModels;
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResultItems;
    }

    public ValidateSupport getValidateSupport() {
        if (null == this.mValidateSupport) {
            this.mValidateSupport = new ValidateSupport(mValConfig);
        }
        return this.mValidateSupport;
    }

    public Validation getValidation() {
        return this.mValidation;
    }

    public void setValidation(Validation validation) {
        this.mValidation = validation;
    }

    public void prepare(Object[] v) {
        Collection resultItems = (Collection)v[0];
        this.getValidateSupport().setResultItems(resultItems);
        Validator validator = (Validator)v[1];
        this.getValidateSupport().setValidator(validator);
    }

    @Override
    public void visit(Definitions w) {
        if (w.getTargetNamespace() == null || w.getTargetNamespace().trim().length() == 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)w, mMsg.getString(VAL_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE), mMsg.getString(FIX_ERROR_WSDL_DEFINITIONS_NO_TARGETNAMESPACE));
        }
        this.visitChildren(w);
    }

    @Override
    public void visit(Message w) {
        if (w.getParts().size() == 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)w, mMsg.getString(VAL_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED, w.getName()), mMsg.getString(FIX_WARNING_WSDL_MESSAGE_DOES_NOT_HAVE_ANY_PARTS_DEFINED, w.getName()));
        }
        this.visitChildren(w);
    }

    @Override
    public void visit(Part p) {
        if (p.getElement() == null && p.getType() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, mMsg.getString(VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART, p.getName()), mMsg.getString(FIX_VAL_NO_ELEMENT_OR_TYPE_ATTRIBUTE_DEFINED_IN_PART));
        }
        if (p.getElement() != null && p.getElement().get() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, mMsg.getString(VAL_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID, p.getName(), p.getAttribute(new GenericExtensibilityElement.StringAttribute("element"))), mMsg.getString(FIX_ELEMENT_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID));
        }
        if (p.getType() != null && p.getType().get() == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)p, mMsg.getString(VAL_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID, p.getName(), p.getAttribute(new GenericExtensibilityElement.StringAttribute("type"))), mMsg.getString(FIX_TYPE_ATTRIBUTE_DEFINED_IN_MESSAGE_PART_IS_NOT_VALID));
        }
        this.visitChildren(p);
    }

    @Override
    public void visit(PortType portType) {
        ArrayList<String> inputNames = new ArrayList<String>();
        ArrayList<String> outputNames = new ArrayList<String>();
        Collection<Operation> operations = portType.getOperations();
        for (Operation operation : operations) {
            String outputName;
            Output output;
            String inputName;
            Input input = operation.getInput();
            if (input != null && (inputName = input.getName()) != null) {
                if (!inputNames.contains(inputName)) {
                    inputNames.add(inputName);
                } else {
                    this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)input, mMsg.getString(VAL_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE, inputName, portType.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_INPUT_NAME_IN_PORTTYPE));
                }
            }
            if ((output = operation.getOutput()) == null || (outputName = output.getName()) == null) continue;
            if (!outputNames.contains(outputName)) {
                outputNames.add(outputName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)output, mMsg.getString(VAL_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE, outputName, portType.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_OUTPUT_NAME_IN_PORTTYPE));
        }
        this.visitChildren(portType);
    }

    @Override
    public void visit(NotificationOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, mMsg.getString(VAL_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()), mMsg.getString(FIX_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()));
        }
        ArrayList<String> faultNames = new ArrayList<String>();
        Collection<Fault> faults = operation.getFaults();
        for (Fault fault : faults) {
            String faultName = fault.getName();
            if (faultName == null) continue;
            if (!faultNames.contains(faultName)) {
                faultNames.add(faultName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, mMsg.getString(VAL_DUPLICATE_OPRATION_FAULT_NAME, faultName, operation.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_FAULT_NAME));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(RequestResponseOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, mMsg.getString(VAL_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()), mMsg.getString(FIX_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()));
        }
        ArrayList<String> faultNames = new ArrayList<String>();
        Collection<Fault> faults = operation.getFaults();
        for (Fault fault : faults) {
            String faultName = fault.getName();
            if (faultName == null) continue;
            if (!faultNames.contains(faultName)) {
                faultNames.add(faultName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, mMsg.getString(VAL_DUPLICATE_OPRATION_FAULT_NAME, faultName, operation.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_FAULT_NAME));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(SolicitResponseOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, mMsg.getString(VAL_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()), mMsg.getString(FIX_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()));
        }
        ArrayList<String> faultNames = new ArrayList<String>();
        Collection<Fault> faults = operation.getFaults();
        for (Fault fault : faults) {
            String faultName = fault.getName();
            if (faultName == null) continue;
            if (!faultNames.contains(faultName)) {
                faultNames.add(faultName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, mMsg.getString(VAL_DUPLICATE_OPRATION_FAULT_NAME, faultName, operation.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_FAULT_NAME));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(OneWayOperation operation) {
        if ((operation.getInput() == null || operation.getOutput() == null) && operation.getFaults() != null && operation.getFaults().size() > 0) {
            this.getValidateSupport().fireToDo(Validator.ResultType.WARNING, (Component)operation, mMsg.getString(VAL_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()), mMsg.getString(FIX_FAULT_NOT_ALLOWED_IN_OPERATION, operation.getName()));
        }
        ArrayList<String> faultNames = new ArrayList<String>();
        Collection<Fault> faults = operation.getFaults();
        for (Fault fault : faults) {
            String faultName = fault.getName();
            if (faultName == null) continue;
            if (!faultNames.contains(faultName)) {
                faultNames.add(faultName);
                continue;
            }
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)operation, mMsg.getString(VAL_DUPLICATE_OPRATION_FAULT_NAME, faultName, operation.getName()), mMsg.getString(FIX_DUPLICATE_OPRATION_FAULT_NAME));
        }
        this.visitChildren(operation);
    }

    @Override
    public void visit(Input input) {
        NamedComponentReference<Message> msgRef = input.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if (message == null) {
            Operation operation = (Operation)input.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)input, mMsg.getString(VAL_MESSAGE_NOT_FOUND_IN_OPERATION_INPUT, input.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()), mMsg.getString("VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT", input.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()));
        }
        this.visitChildren(input);
    }

    @Override
    public void visit(Output output) {
        NamedComponentReference<Message> msgRef = output.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if (message == null) {
            Operation operation = (Operation)output.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)output, mMsg.getString(VAL_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT, output.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()), mMsg.getString(FIX_MESSAGE_NOT_FOUND_IN_OPERATION_OUTPUT, output.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()));
        }
        this.visitChildren(output);
    }

    @Override
    public void visit(Fault fault) {
        NamedComponentReference<Message> msgRef = fault.getMessage();
        Message message = null;
        if (msgRef != null) {
            message = (Message)msgRef.get();
        }
        if (message == null) {
            Operation operation = (Operation)fault.getParent();
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)fault, mMsg.getString("VAL_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT", fault.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()), mMsg.getString(FIX_MESSAGE_NOT_FOUND_IN_OPERATION_FAULT, fault.getAttribute(new GenericExtensibilityElement.StringAttribute("message")), operation.getName()));
        }
        this.visitChildren(fault);
    }

    @Override
    public void visit(Service service) {
        this.visitChildren(service);
    }

    @Override
    public void visit(Port port) {
        NamedComponentReference<Binding> bindingRef = port.getBinding();
        Binding binding = null;
        if (bindingRef != null) {
            binding = (Binding)bindingRef.get();
        }
        if (binding == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)port, mMsg.getString(VAL_MISSING_BINDING_IN_SERVICE_PORT, port.getName(), port.getAttribute(new GenericExtensibilityElement.StringAttribute("binding"))), mMsg.getString(FIX_MISSING_BINDING_IN_SERVICE_PORT));
        }
        this.visitChildren(port);
    }

    @Override
    public void visit(Import wsdlImport) {
        List<Schema> xsdImports;
        List<WSDLModel> importedDocuments = wsdlImport.getModel().findWSDLModel(wsdlImport.getNamespace());
        if (!(importedDocuments != null && !importedDocuments.isEmpty() || (xsdImports = wsdlImport.getModel().findSchemas(wsdlImport.getNamespace())) != null && xsdImports.size() != 0)) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)wsdlImport, mMsg.getString(VAL_MISSING_IMPORTED_DOCUMENT, wsdlImport.getNamespace(), wsdlImport.getLocation()), mMsg.getString(FIX_MISSING_IMPORTED_DOCUMENT));
        }
        this.visitChildren(wsdlImport);
        for (WSDLModel imp : importedDocuments) {
            this.mValidation.validate((Model)imp, Validation.ValidationType.COMPLETE);
        }
    }

    @Override
    public void visit(Binding binding) {
        NamedComponentReference<PortType> ptRef = binding.getType();
        PortType portType = null;
        if (ptRef != null) {
            portType = (PortType)ptRef.get();
        }
        if (portType == null) {
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)binding, mMsg.getString(VAL_MISSING_PORTTYPE_IN_BINDING, binding.getName(), binding.getAttribute(new GenericExtensibilityElement.StringAttribute("type"))), mMsg.getString(FIX_MISSING_PORTTYPE_IN_BINDING));
        }
        this.visitChildren(binding);
    }

    @Override
    public void visit(BindingOperation bindingOp) {
        Binding binding = (Binding)bindingOp.getParent();
        NamedComponentReference<PortType> ptRef = binding.getType();
        PortType portType = null;
        if (ptRef != null) {
            portType = (PortType)ptRef.get();
        }
        String operationName = bindingOp.getName();
        if (portType != null && operationName != null) {
            Collection<Operation> operations = portType.getOperations();
            boolean operationFound = false;
            if (operations != null) {
                for (Operation operation : operations) {
                    if (!operationName.equals(operation.getName())) continue;
                    operationFound = true;
                }
            }
            if (!operationFound) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)bindingOp, mMsg.getString(VAL_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE, operationName, binding.getName(), portType.getName()), mMsg.getString(FIX_OPERATION_DOES_NOT_EXIST_IN_PORT_TYPE, portType.getName()));
            }
        }
        this.visitChildren(bindingOp);
    }

    @Override
    public void visit(BindingInput bindingIn) {
        this.visitChildren(bindingIn);
    }

    @Override
    public void visit(BindingOutput bindingOut) {
        this.visitChildren(bindingOut);
    }

    @Override
    public void visit(BindingFault bindingFault) {
        this.visitChildren(bindingFault);
    }

    @Override
    public void visit(Documentation doc) {
    }

    @Override
    public void visit(Types types) {
        this.visitChildren(types);
    }

    @Override
    public void visit(ExtensibilityElement ext) {
        String targetNamespace;
        SchemaModel model;
        if (ext instanceof WSDLSchema && (model = ((WSDLSchema)ext).getSchemaModel()) != null && model.getSchema() != null && ((targetNamespace = model.getSchema().getTargetNamespace()) == null || targetNamespace.length() == 0)) {
            Schema schema = model.getSchema();
            List allTopLevelElements = schema.getChildren();
            for (SchemaComponent sc : allTopLevelElements) {
                if (sc instanceof Annotation || sc instanceof org.netbeans.modules.xml.schema.model.Import) continue;
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)ext, mMsg.getString(VAL_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST), mMsg.getString(FIX_SCHEMA_TARGETNAMESPACE_DOES_NOT_EXIST));
                break;
            }
        }
    }

    private void visitChildren(WSDLComponent w) {
        List coll = w.getChildren();
        if (coll != null) {
            for (WSDLComponent component : coll) {
                component.accept(this);
            }
        }
    }
}

