/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.modules.editor.mimelookup.CompositeLayerFolderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class LayerFolderObjectsProvider {
    private static final boolean debugFoldersListening = Boolean.getBoolean("netbeans.debug.editor.mimelookup.mimefolders.listening");
    private String suffixFolder;
    private Class clazz;
    private InstanceProvider instanceProvider;
    private Map mimePath2folderObjectsResults = new HashMap();

    public LayerFolderObjectsProvider() {
    }

    public LayerFolderObjectsProvider(String suffixFolder, Class clazz, InstanceProvider instanceProvider) {
        this.suffixFolder = suffixFolder;
        this.clazz = clazz;
        this.instanceProvider = instanceProvider;
    }

    public Class getClazz() {
        return this.clazz;
    }

    private DataFolder getDataFolder(FileObject fo) {
        if (fo == null) {
            return null;
        }
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            if (dobj instanceof DataFolder) {
                return (DataFolder)dobj;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Lookup.Result getLookupResult(String[] mimePath) {
        String s = this.mimePath2String(mimePath, true, true);
        FileObject fo = this.getExistingParentFolder(s);
        DataFolder dataFolder = this.getDataFolder(fo);
        if (dataFolder == null) {
            return null;
        }
        List inheritedFolders = new ArrayList();
        inheritedFolders = this.getInheritedFolders(mimePath);
        CompositeLayerFolderLookup lookup = new CompositeLayerFolderLookup(this.instanceProvider, inheritedFolders);
        Lookup.Result res = lookup.lookup(new Lookup.Template(this.clazz));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result folderObjects(String[] mimePath) {
        String s = this.mimePath2String(mimePath, true, true);
        Map map = this.mimePath2folderObjectsResults;
        synchronized (map) {
            Lookup.Result result = (Lookup.Result)this.mimePath2folderObjectsResults.get(s);
            if (result != null) {
                return result;
            }
            result = s.indexOf("+") > 0 ? new CompoundDelegatingLookupResult(mimePath) : new DelegatingLookupResult(mimePath);
            this.mimePath2folderObjectsResults.put(s, result);
            return result;
        }
    }

    private List getInheritedFolders(String[] mimePath) {
        ArrayList<DataFolder> list = new ArrayList<DataFolder>();
        for (int i = 0; i < mimePath.length; ++i) {
            String[] mimePathLocal = new String[mimePath.length - i];
            System.arraycopy(mimePath, 0, mimePathLocal, 0, mimePathLocal.length);
            String s = this.mimePath2String(mimePathLocal, true, true);
            DataFolder dataFolder = this.getDataFolder(this.getLayerFolder(s));
            if (dataFolder == null) continue;
            list.add(dataFolder);
        }
        FileObject layerFolder = this.getLayerFolder(this.mimePath2String(new String[0], true, true));
        DataFolder dataFolder = this.getDataFolder(layerFolder);
        if (dataFolder != null) {
            list.add(dataFolder);
        }
        return list;
    }

    private FileObject getLayerFolder(String path) {
        FileObject parentFolder = Repository.getDefault().getDefaultFileSystem().findResource(path);
        if (parentFolder == null || parentFolder.isData() || !parentFolder.isValid() || parentFolder.isVirtual()) {
            return null;
        }
        return parentFolder;
    }

    private String mimePath2String(String[] mimePath, boolean prefixEditorsFolder, boolean appendLookupFolder) {
        StringBuffer sb = new StringBuffer();
        if (prefixEditorsFolder) {
            sb.append("Editors/");
        }
        for (int i = 0; i < mimePath.length; ++i) {
            sb.append(mimePath[i]);
            if (i >= mimePath.length - 1) continue;
            sb.append("/");
        }
        if (appendLookupFolder && this.suffixFolder != null) {
            String sep = mimePath.length > 0 ? "/" : "";
            sb.append(sep + this.suffixFolder);
        }
        return sb.toString();
    }

    private FileObject getExistingParentFolder(String mimePath) {
        int i;
        StringTokenizer tokenizer = new StringTokenizer(mimePath, "/");
        int countTokens = tokenizer.countTokens();
        String[] tokens = new String[countTokens];
        for (i = 0; i < countTokens; ++i) {
            tokens[i] = i > 0 ? tokens[i - 1] + "/" + tokenizer.nextToken() : tokenizer.nextToken();
        }
        for (i = tokens.length - 1; i >= 0; --i) {
            FileObject folder = this.getLayerFolder(tokens[i]);
            if (folder == null) continue;
            return folder;
        }
        return null;
    }

    private class CompoundDelegatingLookupResult
    extends Lookup.Result {
        private String[] mimePath;
        private List delegators = new ArrayList();

        public CompoundDelegatingLookupResult(String[] mimePath) {
            this.mimePath = mimePath;
            List paths = this.getPaths(mimePath);
            for (int i = 0; i < paths.size(); ++i) {
                String[] s = (String[])paths.get(i);
                this.delegators.add(new DelegatingLookupResult(s));
            }
        }

        public synchronized void addLookupListener(LookupListener l) {
            Iterator it = this.delegators.iterator();
            while (it.hasNext()) {
                DelegatingLookupResult dlr = (DelegatingLookupResult)it.next();
                dlr.addLookupListener(l);
            }
        }

        public synchronized void removeLookupListener(LookupListener l) {
            Iterator it = this.delegators.iterator();
            while (it.hasNext()) {
                DelegatingLookupResult dlr = (DelegatingLookupResult)it.next();
                dlr.removeLookupListener(l);
            }
        }

        public synchronized Collection allInstances() {
            ArrayList inheritedFolders = new ArrayList();
            Iterator it = this.delegators.iterator();
            while (it.hasNext()) {
                DelegatingLookupResult dlr = (DelegatingLookupResult)it.next();
                DataFolder dataFolder = LayerFolderObjectsProvider.this.getDataFolder(LayerFolderObjectsProvider.this.getExistingParentFolder(dlr.path));
                if (dataFolder == null) continue;
                List folders = LayerFolderObjectsProvider.this.getInheritedFolders(dlr.mimePath);
                for (int i = 0; i < folders.size(); ++i) {
                    Object folder = folders.get(i);
                    if (inheritedFolders.contains(folder)) continue;
                    inheritedFolders.add(folder);
                }
            }
            CompositeLayerFolderLookup lookup = new CompositeLayerFolderLookup(LayerFolderObjectsProvider.this.instanceProvider, inheritedFolders);
            Lookup.Result res = lookup.lookup(new Lookup.Template(LayerFolderObjectsProvider.this.clazz));
            return res.allInstances();
        }

        public List getPaths(String[] path) {
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(new String[0]);
            for (int i = 0; i < path.length; ++i) {
                String forkName = null;
                int plusIndex = path[i].indexOf("+");
                int slashIndex = path[i].indexOf("/");
                if (plusIndex > 0) {
                    String prefix = path[i].substring(0, slashIndex + 1);
                    String suffix = path[i].substring(plusIndex + 1);
                    if (suffix != null && "xml".equals(suffix.toLowerCase())) {
                        prefix = "text/";
                    }
                    forkName = prefix + suffix;
                }
                ArrayList<String[]> tempList = new ArrayList<String[]>();
                for (int j = 0; j < ret.size(); ++j) {
                    String[] oldPath = (String[])ret.get(j);
                    int oldPathLength = oldPath.length;
                    String[] newPath = new String[oldPathLength + 1];
                    System.arraycopy(oldPath, 0, newPath, 0, oldPathLength);
                    newPath[oldPathLength] = path[i];
                    tempList.add(newPath);
                }
                ArrayList<String[]> tempListFork = new ArrayList<String[]>();
                if (forkName != null) {
                    for (int j = 0; j < ret.size(); ++j) {
                        String[] oldPath = (String[])ret.get(j);
                        int oldPathLength = oldPath.length;
                        String[] newPath = new String[oldPathLength + 1];
                        System.arraycopy(oldPath, 0, newPath, 0, oldPathLength);
                        newPath[oldPathLength] = forkName;
                        tempListFork.add(newPath);
                    }
                }
                ret = tempList;
                ret.addAll(tempListFork);
            }
            return ret;
        }
    }

    private class ParentFolderListener
    extends FileChangeAdapter {
        ParentFolderNotificator notificator;
        String path;

        public ParentFolderListener(ParentFolderNotificator notificator, String path) {
            this.notificator = notificator;
            this.path = path;
        }

        public void fileDeleted(FileEvent fe) {
            FileObject removedFolder;
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("ParentFolderListener.fileDeleted:" + fe.getFile());
            }
            if ((removedFolder = fe.getFile()) == null || !removedFolder.isFolder()) {
                if (debugFoldersListening) {
                    System.out.println("    - not a folder, ignore");
                }
                return;
            }
            if (this.path.equals(removedFolder.getPath())) {
                if (debugFoldersListening) {
                    System.out.println("    - folder on which we were listening has been removed:" + this.path);
                }
                this.notificator.folderDeleted(removedFolder);
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            FileObject createdFolder;
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("ParentFolderListener.fileFolderCreated:" + fe.getFile());
            }
            if ((createdFolder = fe.getFile()) == null || !createdFolder.isFolder()) {
                if (debugFoldersListening) {
                    System.out.println("    - not a folder, ignore");
                }
                return;
            }
            this.notificator.folderCreated(createdFolder);
        }
    }

    private static interface ParentFolderNotificator {
        public void folderCreated(FileObject var1);

        public void folderDeleted(FileObject var1);
    }

    private class DelegatingLookupResult
    extends Lookup.Result
    implements ParentFolderNotificator {
        private String[] mimePath;
        private Lookup.Result delegator;
        private ParentFolderListener parentFolderListener;
        private final String path;
        private String lastAttachedListenerPath = null;
        private WeakHashMap listeners = new WeakHashMap();

        public DelegatingLookupResult(String[] mimePath) {
            this.path = LayerFolderObjectsProvider.this.mimePath2String(mimePath, true, true);
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(mimePath);
            this.mimePath = mimePath;
            this.attachFolderListener(this.path);
        }

        public void folderCreated(FileObject fo) {
            List list;
            fo = LayerFolderObjectsProvider.this.getExistingParentFolder(this.path);
            Lookup.Result oldDelegator = this.delegator;
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(this.mimePath);
            if (debugFoldersListening) {
                System.out.println("    *** delegator created for:" + fo);
            }
            if ((list = (List)this.listeners.get(oldDelegator)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener l = (LookupListener)list.get(i);
                    oldDelegator.removeLookupListener(l);
                    this.delegator.addLookupListener(l);
                }
            }
            this.listeners.remove(oldDelegator);
            this.listeners.put(this.delegator, list);
            oldDelegator = null;
            this.fireResultChanged(new LookupEvent((Lookup.Result)this));
            this.attachFolderListener(this.path);
        }

        public void folderDeleted(FileObject fo) {
            Lookup.Result oldDelegator = this.delegator;
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(this.mimePath);
            List list = (List)this.listeners.get(oldDelegator);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener l = (LookupListener)list.get(i);
                    oldDelegator.removeLookupListener(l);
                    this.delegator.addLookupListener(l);
                }
            }
            this.listeners.remove(oldDelegator);
            this.listeners.put(this.delegator, list);
            oldDelegator = null;
            this.fireResultChanged(new LookupEvent((Lookup.Result)this));
            if (debugFoldersListening) {
                System.out.println("    *** delegator disposed, acting as FAKE lookup result");
            }
            this.attachFolderListener(this.path);
        }

        private void fireResultChanged(LookupEvent evt) {
            List list;
            if (this.delegator != null && (list = (List)this.listeners.get(this.delegator)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener l = (LookupListener)list.get(i);
                    l.resultChanged(evt);
                }
            }
        }

        private synchronized void attachFolderListener(String path) {
            FileObject existingParent;
            FileObject lastAttachedListener;
            if (this.lastAttachedListenerPath != null && (lastAttachedListener = LayerFolderObjectsProvider.this.getLayerFolder(this.lastAttachedListenerPath)) != null) {
                if (debugFoldersListening) {
                    System.out.println("remove PREVIOUSLY ATTACHED and now not needed parentFolderListener from:" + lastAttachedListener);
                }
                lastAttachedListener.removeFileChangeListener((FileChangeListener)this.parentFolderListener);
            }
            if ((existingParent = LayerFolderObjectsProvider.this.getExistingParentFolder(path)) == null) {
                return;
            }
            this.parentFolderListener = new ParentFolderListener(this, existingParent.getPath());
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("attaching parentFolderListener to existingParent:" + existingParent);
                System.out.println("for global path:" + path);
            }
            existingParent.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.parentFolderListener, (Object)existingParent));
            this.lastAttachedListenerPath = existingParent.getPath();
        }

        public synchronized void addLookupListener(LookupListener l) {
            this.delegator.addLookupListener(l);
            ArrayList<LookupListener> list = (ArrayList<LookupListener>)this.listeners.get(this.delegator);
            if (list == null) {
                list = new ArrayList<LookupListener>();
            }
            list.add(l);
            this.listeners.remove(this.delegator);
            this.listeners.put(this.delegator, list);
        }

        public synchronized void removeLookupListener(LookupListener l) {
            this.delegator.removeLookupListener(l);
            List list = (List)this.listeners.get(this.delegator);
            if (list != null) {
                list.remove(l);
            }
            this.listeners.remove(this.delegator);
            this.listeners.put(this.delegator, list);
        }

        public Collection allInstances() {
            if (this.delegator != null) {
                return this.delegator.allInstances();
            }
            return Collections.EMPTY_LIST;
        }

        public Collection allItems() {
            if (this.delegator != null) {
                return this.delegator.allItems();
            }
            return Collections.EMPTY_LIST;
        }

        public Set allClasses() {
            if (this.delegator != null) {
                return this.delegator.allClasses();
            }
            return Collections.EMPTY_SET;
        }
    }
}

