/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.FastHttpDateFormat;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class DefaultServlet
extends HttpServlet {
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = false;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected boolean encodeRedirects = false;
    protected String[] welcomes = new String[0];
    protected static MessageDigest md5Helper;
    protected String fileEncoding = null;
    protected static final MD5Encoder md5Encoder;
    protected static final SimpleDateFormat[] formats;
    protected static final TimeZone gmtZone;
    protected static URLEncoder urlEncoder;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static StringManager sm;
    private static final int BUFFER_SIZE = 4096;

    public void destroy() {
    }

    public void init() throws ServletException {
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("input");
            this.input = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("listings");
            this.listings = new Boolean(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("readonly");
            if (value != null) {
                this.readOnly = new Boolean(value);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("output");
            this.output = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("encodeRedirects");
            this.encodeRedirects = new Boolean(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.fileEncoding = value = this.getServletConfig().getInitParameter("fileEncoding");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
        if (this.welcomes == null) {
            this.welcomes = new String[0];
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
            for (int i = 0; i < this.welcomes.length; ++i) {
                this.log("DefaultServlet.init:  welcome file=" + this.welcomes[i]);
            }
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    protected DirContext getResources() {
        DirContext result = null;
        try {
            result = (DirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        try {
            result = (DirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
        }
        catch (NamingException e) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    protected void showRequestInfo(HttpServletRequest req) {
        System.out.println();
        System.out.println("SlideDAV Request Info");
        System.out.println();
        System.out.println("Encoding : " + req.getCharacterEncoding());
        System.out.println("Length : " + req.getContentLength());
        System.out.println("Type : " + req.getContentType());
        System.out.println();
        System.out.println("Parameters");
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = req.getParameterValues(paramName);
            System.out.print(paramName + " : ");
            for (int i = 0; i < values.length; ++i) {
                System.out.print(values[i] + ", ");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Protocol : " + req.getProtocol());
        System.out.println("Address : " + req.getRemoteAddr());
        System.out.println("Host : " + req.getRemoteHost());
        System.out.println("Scheme : " + req.getScheme());
        System.out.println("Server Name : " + req.getServerName());
        System.out.println("Server Port : " + req.getServerPort());
        System.out.println();
        System.out.println("Attributes");
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attributeName = (String)attributes.nextElement();
            System.out.print(attributeName + " : ");
            System.out.println(req.getAttribute(attributeName).toString());
        }
        System.out.println();
        System.out.println();
        System.out.println("HTTP Header Info");
        System.out.println();
        System.out.println("Authentication Type : " + req.getAuthType());
        System.out.println("HTTP Method : " + req.getMethod());
        System.out.println("Path Info : " + req.getPathInfo());
        System.out.println("Path translated : " + req.getPathTranslated());
        System.out.println("Query string : " + req.getQueryString());
        System.out.println("Remote user : " + req.getRemoteUser());
        System.out.println("Requested session id : " + req.getRequestedSessionId());
        System.out.println("Request URI : " + req.getRequestURI());
        System.out.println("Context path : " + req.getContextPath());
        System.out.println("Servlet path : " + req.getServletPath());
        System.out.println("User principal : " + req.getUserPrincipal());
        System.out.println();
        System.out.println("Headers : ");
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            System.out.print(headerName + " : ");
            System.out.println(req.getHeader(headerName));
        }
        System.out.println();
        System.out.println();
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return RequestUtil.normalize((String)result);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.debug > 999) {
            this.showRequestInfo(request);
        }
        this.serveResource(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        DirContext resources = this.getResources();
        if (resources == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        try {
            resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        boolean result = true;
        File contentFile = null;
        Range range = this.parseContentRange(req, resp);
        Object resourceInputStream = null;
        if (range != null) {
            contentFile = this.executePartialPut(req, range, path);
            resourceInputStream = new FileInputStream(contentFile);
        } else {
            resourceInputStream = req.getInputStream();
        }
        try {
            Resource newResource = new Resource((InputStream)resourceInputStream);
            if (exists) {
                resources.rebind(path, (Object)newResource);
            } else {
                resources.bind(path, (Object)newResource);
            }
        }
        catch (NamingException e) {
            result = false;
        }
        if (result) {
            if (exists) {
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else {
            resp.sendError(409);
        }
    }

    protected File executePartialPut(HttpServletRequest req, Range range, String path) throws IOException {
        int numBytesRead;
        String convertedResourcePath;
        File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File contentFile = new File(tempDir, convertedResourcePath = path.replace('/', '.'));
        if (contentFile.createNewFile()) {
            contentFile.deleteOnExit();
        }
        RandomAccessFile randAccessContentFile = new RandomAccessFile(contentFile, "rw");
        Resource oldResource = null;
        try {
            Object obj = this.getResources().lookup(path);
            if (obj instanceof Resource) {
                oldResource = (Resource)obj;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (oldResource != null) {
            int numBytesRead2;
            BufferedInputStream bufOldRevStream = new BufferedInputStream(oldResource.streamContent(), 4096);
            byte[] copyBuffer = new byte[4096];
            while ((numBytesRead2 = bufOldRevStream.read(copyBuffer)) != -1) {
                randAccessContentFile.write(copyBuffer, 0, numBytesRead2);
            }
            bufOldRevStream.close();
        }
        randAccessContentFile.setLength(range.length);
        randAccessContentFile.seek(range.start);
        byte[] transferBuffer = new byte[4096];
        BufferedInputStream requestBufInStream = new BufferedInputStream((InputStream)req.getInputStream(), 4096);
        while ((numBytesRead = requestBufInStream.read(transferBuffer)) != -1) {
            randAccessContentFile.write(transferBuffer, 0, numBytesRead);
        }
        randAccessContentFile.close();
        requestBufInStream.close();
        return contentFile;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        DirContext resources = this.getResources();
        if (resources == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        try {
            resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (exists) {
            boolean result = true;
            try {
                resources.unbind(path);
            }
            catch (NamingException e) {
                result = false;
            }
            if (result) {
                resp.setStatus(204);
            } else {
                resp.sendError(405);
            }
        } else {
            resp.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        return this.checkIfMatch(request, response, resourceInfo) && this.checkIfModifiedSince(request, response, resourceInfo) && this.checkIfNoneMatch(request, response, resourceInfo) && this.checkIfUnmodifiedSince(request, response, resourceInfo);
    }

    protected String getETag(ResourceInfo resourceInfo) {
        if (resourceInfo.strongETag != null) {
            return resourceInfo.strongETag;
        }
        if (resourceInfo.weakETag != null) {
            return resourceInfo.weakETag;
        }
        return "W/\"" + resourceInfo.length + "-" + resourceInfo.date + "\"";
    }

    protected String rewriteUrl(String path) {
        return urlEncoder.encode(path);
    }

    protected void displaySize(StringBuffer buf, int filesize) {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.append(leftside).append(".").append(rightside);
        buf.append(" KB");
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            if (content) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers only");
            }
        }
        DirContext resources = this.getResources();
        ResourceInfo resourceInfo = new ResourceInfo(path, resources);
        if (!resourceInfo.exists) {
            response.sendError(404, request.getRequestURI());
            return;
        }
        if (!resourceInfo.collection && (path.endsWith("/") || path.endsWith("\\"))) {
            response.sendError(404, request.getRequestURI());
            return;
        }
        if (resourceInfo.collection) {
            if (!request.getRequestURI().endsWith("/")) {
                String redirectPath = path;
                String contextPath = request.getContextPath();
                if (contextPath != null && !contextPath.equals("/")) {
                    redirectPath = contextPath + redirectPath;
                }
                if (!redirectPath.endsWith("/")) {
                    redirectPath = redirectPath + "/";
                }
                redirectPath = this.appendParameters(request, redirectPath);
                if (this.encodeRedirects) {
                    redirectPath = response.encodeRedirectURL(redirectPath);
                }
                response.sendRedirect(redirectPath);
                return;
            }
            ResourceInfo welcomeFileInfo = this.checkWelcomeFiles(path, resources);
            if (welcomeFileInfo != null) {
                String redirectPath = welcomeFileInfo.path;
                String contextPath = request.getContextPath();
                if (contextPath != null && !contextPath.equals("/")) {
                    redirectPath = contextPath + redirectPath;
                }
                redirectPath = this.appendParameters(request, redirectPath);
                if (this.encodeRedirects) {
                    redirectPath = response.encodeRedirectURL(redirectPath);
                }
                response.sendRedirect(redirectPath);
                return;
            }
        } else {
            boolean included;
            boolean bl = included = request.getAttribute("javax.servlet.include.context_path") != null;
            if (!included && !this.checkIfHeaders(request, response, resourceInfo)) {
                return;
            }
        }
        String contentType = this.getServletContext().getMimeType(resourceInfo.path);
        Vector ranges = null;
        if (resourceInfo.collection) {
            if (!this.listings) {
                response.sendError(404, request.getRequestURI());
                return;
            }
            contentType = "text/html;charset=UTF-8";
        } else {
            ranges = this.parseRange(request, response, resourceInfo);
            response.setHeader("ETag", this.getETag(resourceInfo));
            if (this.debug > 0) {
                this.log("DefaultServlet.serveFile:  lastModified='" + new Timestamp(resourceInfo.date).toString() + "'");
            }
            response.setHeader("Last-Modified", resourceInfo.httpDate);
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (resourceInfo.collection || (ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null) {
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            long contentLength = resourceInfo.length;
            if (!resourceInfo.collection && contentLength >= 0L) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + contentLength);
                }
                response.setContentLength((int)contentLength);
            }
            if (resourceInfo.collection && content) {
                resourceInfo.setStream(this.render(request.getContextPath(), resourceInfo));
            }
            if (content) {
                try {
                    response.setBufferSize(this.output);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                if (ostream != null) {
                    this.copy(resourceInfo, ostream);
                } else {
                    this.copy(resourceInfo, writer);
                }
            }
        } else {
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = (Range)ranges.elementAt(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                response.setContentLength((int)(range.end - range.start + 1L));
                if (contentType != null) {
                    if (this.debug > 0) {
                        this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                    }
                    response.setContentType(contentType);
                }
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(resourceInfo, ostream, range);
                    } else {
                        this.copy(resourceInfo, writer, range);
                    }
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(resourceInfo, ostream, ranges.elements(), contentType);
                    } else {
                        this.copy(resourceInfo, writer, ranges.elements(), contentType);
                    }
                }
            }
        }
    }

    protected Range parseContentRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rangeHeader = request.getHeader("Content-Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(400);
            return null;
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            response.sendError(400);
            return null;
        }
        if (slashPos == -1) {
            response.sendError(400);
            return null;
        }
        Range range = new Range();
        try {
            range.start = Long.parseLong(rangeHeader.substring(0, dashPos));
            range.end = Long.parseLong(rangeHeader.substring(dashPos + 1, slashPos));
            range.length = Long.parseLong(rangeHeader.substring(slashPos + 1, rangeHeader.length()));
        }
        catch (NumberFormatException e) {
            response.sendError(400);
            return null;
        }
        if (!range.validate()) {
            response.sendError(400);
            return null;
        }
        return range;
    }

    protected Vector parseRange(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            String eTag = this.getETag(resourceInfo);
            long lastModified = resourceInfo.date;
            Date date = null;
            for (int i = 0; date == null && i < formats.length; ++i) {
                try {
                    date = formats[i].parse(headerValue);
                    continue;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (date == null ? !eTag.equals(headerValue.trim()) : lastModified > date.getTime() + 1000L) {
                return null;
            }
        }
        if ((fileLength = resourceInfo.length) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        Vector<Range> result = new Vector<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.addElement(currentRange);
        }
        return result;
    }

    protected String appendParameters(HttpServletRequest request, String redirectPath) {
        StringBuffer result = new StringBuffer(this.rewriteUrl(redirectPath));
        String query = request.getQueryString();
        if (query != null) {
            result.append("?").append(query);
        }
        return result.toString();
    }

    protected InputStream render(String contextPath, ResourceInfo resourceInfo) {
        int slash;
        String name = resourceInfo.path;
        int trim = name.length();
        if (!name.endsWith("/")) {
            ++trim;
        }
        if (name.equals("/")) {
            trim = 1;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        }
        catch (Exception e) {
            osWriter = new OutputStreamWriter(stream);
        }
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append(sm.getString("directory.title", (Object)name));
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append("H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} ");
        sb.append("H3{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} ");
        sb.append("BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} ");
        sb.append("B{color : white;background-color : #0086b2;} ");
        sb.append("A{color : black;} ");
        sb.append("HR{color : #0086b2;} ");
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(sm.getString("directory.title", (Object)name));
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = name.substring(0, slash);
            sb.append(" - <a href=\"");
            sb.append(this.rewriteUrl(contextPath));
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append("<b>");
            sb.append(sm.getString("directory.parent", (Object)parent));
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.filename"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.size"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append(sm.getString("directory.lastModified"));
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        try {
            DirContext directory = resourceInfo.directory;
            NamingEnumeration<NameClassPair> enumeration = resourceInfo.resources.list(resourceInfo.path);
            boolean shade = false;
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String resourceName = ncPair.getName();
                ResourceInfo childResourceInfo = new ResourceInfo(resourceName, directory);
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"eeeeee\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                sb.append("<a href=\"");
                sb.append(this.rewriteUrl(contextPath));
                resourceName = this.rewriteUrl(name + resourceName);
                sb.append(resourceName);
                if (childResourceInfo.collection) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(trimmed);
                if (childResourceInfo.collection) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (childResourceInfo.collection) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(this.renderSize(childResourceInfo.length));
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                sb.append(childResourceInfo.httpDate);
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    private boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        String eTag = this.getETag(resourceInfo);
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            long lastModified = resourceInfo.date;
            if (headerValue != -1L && request.getHeader("If-None-Match") == null && lastModified <= headerValue + 1000L) {
                response.setStatus(304);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        String eTag = this.getETag(resourceInfo);
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        try {
            long lastModified = resourceInfo.date;
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified > headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
        exception = this.copyRange(reader, writer);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
        exception = this.copyRange(reader, writer, range.start, range.end);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = resourceInfo.getStream();
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = (Range)ranges.nextElement();
            ostream.println();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable t) {}
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = resourceInfo.getStream();
            InputStreamReader reader = this.fileEncoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, this.fileEncoding);
            Range currentRange = (Range)ranges.nextElement();
            writer.println();
            writer.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                writer.println("Content-Type: " + contentType);
            }
            writer.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            writer.println();
            exception = this.copyRange(reader, writer, currentRange.start, currentRange.end);
            try {
                ((Reader)reader).close();
            }
            catch (Throwable t) {}
        }
        writer.println();
        writer.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        if (this.debug > 10) {
            System.out.println("Serving bytes:" + start + "-" + end);
        }
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer, long start, long end) {
        try {
            reader.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = reader.read(buffer);
                if (bytesToRead >= (long)len) {
                    writer.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    writer.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceInfo checkWelcomeFiles(String pathname, DirContext resources) {
        String collectionName = pathname;
        if (!pathname.endsWith("/")) {
            collectionName = collectionName + "/";
        }
        String[] stringArray = this.welcomes;
        synchronized (this.welcomes) {
            this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
            if (this.welcomes == null) {
                this.welcomes = new String[0];
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (int i = 0; i < this.welcomes.length; ++i) {
                String resourceName = collectionName + this.welcomes[i];
                ResourceInfo resourceInfo = new ResourceInfo(resourceName, resources);
                if (!resourceInfo.exists()) continue;
                return resourceInfo;
            }
            return null;
        }
    }

    static {
        md5Encoder = new MD5Encoder();
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        gmtZone = TimeZone.getTimeZone("GMT");
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        sm = StringManager.getManager((String)"org.apache.catalina.servlets");
    }

    protected class ResourceInfo {
        public Object object;
        public DirContext directory;
        public Resource file;
        public Attributes attributes;
        public String path;
        public long creationDate;
        public String httpDate;
        public long date;
        public long length;
        public boolean collection;
        public String weakETag;
        public String strongETag;
        public boolean exists;
        public DirContext resources;
        protected InputStream is;

        public ResourceInfo(String path, DirContext resources) {
            this.set(path, resources);
        }

        public void recycle() {
            this.object = null;
            this.directory = null;
            this.file = null;
            this.attributes = null;
            this.path = null;
            this.creationDate = 0L;
            this.httpDate = null;
            this.date = 0L;
            this.length = -1L;
            this.collection = true;
            this.weakETag = null;
            this.strongETag = null;
            this.exists = false;
            this.resources = null;
            this.is = null;
        }

        public void set(String path, DirContext resources) {
            this.recycle();
            this.path = path;
            this.resources = resources;
            this.exists = true;
            try {
                this.object = resources.lookup(path);
                if (this.object instanceof Resource) {
                    this.file = (Resource)this.object;
                    this.collection = false;
                } else if (this.object instanceof DirContext) {
                    this.directory = (DirContext)this.object;
                    this.collection = true;
                } else {
                    this.exists = false;
                }
            }
            catch (NamingException e) {
                this.exists = false;
            }
            if (this.exists) {
                try {
                    this.attributes = resources.getAttributes(path);
                    if (this.attributes instanceof ResourceAttributes) {
                        ResourceAttributes tempAttrs = (ResourceAttributes)this.attributes;
                        Date tempDate = tempAttrs.getCreationDate();
                        if (tempDate != null) {
                            this.creationDate = tempDate.getTime();
                        }
                        if ((tempDate = tempAttrs.getLastModifiedDate()) != null) {
                            this.httpDate = FastHttpDateFormat.getDate((Date)tempDate);
                            this.date = tempDate.getTime();
                        } else {
                            this.httpDate = FastHttpDateFormat.getCurrentDate();
                        }
                        this.weakETag = tempAttrs.getETag();
                        this.strongETag = tempAttrs.getETag(true);
                        this.length = tempAttrs.getContentLength();
                    }
                }
                catch (NamingException e) {
                    this.exists = false;
                }
            }
        }

        public boolean exists() {
            return this.exists;
        }

        public String toString() {
            return this.path;
        }

        public void setStream(InputStream is) {
            this.is = is;
        }

        public InputStream getStream() throws IOException {
            if (this.is != null) {
                return this.is;
            }
            if (this.file != null) {
                return this.file.streamContent();
            }
            return null;
        }
    }

    private class Range {
        public long start;
        public long end;
        public long length;

        private Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }
}

