/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.ResourceLinksForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public class ListResourceLinksAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        String resourcetype = request.getParameter("resourcetype");
        String path = request.getParameter("path");
        String host = request.getParameter("host");
        String domain = request.getParameter("domain");
        if (resourcetype != null) {
            resourcetype = URLDecoder.decode(resourcetype, "UTF-8");
        }
        if (path != null) {
            path = URLDecoder.decode(path, "UTF-8");
        }
        if (host != null) {
            host = URLDecoder.decode(host, "UTF-8");
        }
        if (domain != null) {
            domain = URLDecoder.decode(domain, "UTF-8");
        }
        ResourceLinksForm resourceLinksForm = null;
        try {
            resourceLinksForm = ResourceUtils.getResourceLinksForm(this.mserver, resourcetype, path, host, domain);
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)"resources"), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)"resources"));
        }
        request.setAttribute("resourceLinksForm", (Object)resourceLinksForm);
        this.saveToken(request);
        String forward = URLDecoder.decode(request.getParameter("forward"), "UTF-8");
        return mapping.findForward(forward);
    }
}

