/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Graphics;

public class SequenceFeature {
    int start;
    int end;
    String type;
    String description;
    Color color;
    Sequence sequence;
    public static int CHAIN;
    public static int DOMAIN;
    public static int TRANSMEM;
    public static int SIGNAL;
    public static int HELIX;
    public static int TURN;
    public static int SHEET;
    public static int CARBOHYD;
    public static int ACT_SITE;
    public static int TRANSIT;
    public static int VARIANT;
    public static int BINDING;

    public SequenceFeature(Sequence sequence, String string, int n, int n2, String string2) {
        this.sequence = sequence;
        this.type = string;
        this.start = n;
        this.end = n2;
        this.description = string2;
        this.setColor();
    }

    public void setColor() {
        if (this.type.equals("CHAIN")) {
            this.color = Color.white;
            return;
        }
        if (this.type.equals("DOMAIN")) {
            this.color = Color.white;
            return;
        }
        if (this.type.equals("TRANSMEM")) {
            this.color = Color.red.darker();
            return;
        }
        if (this.type.equals("SIGNAL")) {
            this.color = Color.cyan;
            return;
        }
        if (this.type.equals("HELIX")) {
            this.color = Color.magenta;
            return;
        }
        if (this.type.equals("TURN")) {
            this.color = Color.cyan;
            return;
        }
        if (this.type.equals("SHEET")) {
            this.color = Color.yellow;
            return;
        }
        if (this.type.equals("STRAND")) {
            this.color = Color.yellow;
            return;
        }
        if (this.type.equals("CARBOHYD")) {
            this.color = Color.pink;
            return;
        }
        if (this.type.equals("ACT_SITE")) {
            this.color = Color.red;
            return;
        }
        if (this.type.equals("TRANSIT")) {
            this.color = Color.orange;
            return;
        }
        if (this.type.equals("VARIANT")) {
            this.color = Color.orange.darker();
            return;
        }
        if (this.type.equals("BINDING")) {
            this.color = Color.blue;
            return;
        }
        if (this.type.equals("DISULFID")) {
            this.color = Color.yellow.darker();
            return;
        }
        if (this.type.equals("NP_BIND")) {
            this.color = Color.red;
            return;
        }
        if (this.type.indexOf("BIND") > 0) {
            this.color = Color.red;
            return;
        }
        this.color = Color.lightGray;
    }

    public String print() {
        String string = new Format("%15s").form(this.type);
        string = String.valueOf(string) + new Format("%6d").form(this.start);
        string = String.valueOf(string) + new Format("%6d").form(this.end);
        string = String.valueOf(string) + " " + this.description;
        return string;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
        int n7 = this.start;
        int n8 = this.end;
        long l = System.currentTimeMillis();
        if (n8 >= n || n7 <= n2) {
            if (n7 > n) {
                n3 += (n7 - n) * n5;
                n = n7;
            }
            if (n8 < n2) {
                n2 = n8;
            }
            int n9 = n;
            while (n9 <= n2) {
                String string = this.sequence.sequence.substring(n9, n9 + 1);
                if (!(string.equals(".") || string.equals("-") || string.equals(" "))) {
                    graphics.fillRect(n3 + (n9 - n) * n5, n4, n5, n6);
                } else {
                    graphics.drawString("-", n3 + (n9 - n) * n5, n4 + n6);
                }
                ++n9;
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time = " + (l2 - l) + "ms");
    }

    static {
        DOMAIN = 1;
        TRANSMEM = 2;
        SIGNAL = 3;
        HELIX = 4;
        TURN = 5;
        SHEET = 6;
        CARBOHYD = 7;
        ACT_SITE = 8;
        TRANSIT = 9;
        VARIANT = 10;
        BINDING = 11;
    }
}

