/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

//////////////////////////////////////////////
// Extended mapi definitions

#ifndef ECMAPIEXT_H
#define ECMAPIEXT_H

#ifndef MAPI_E_STORE_FULL
#define MAPI_E_STORE_FULL (SCODE)0x8004060c
#endif

#ifndef PR_ATTACH_CONTENT_ID
#define PR_ATTACH_CONTENT_ID (PROP_TAG(PT_TSTRING,0x3712))
#endif

#define RETURN_PROP_CASE(pt) case PROP_ID(pt): return((#pt))

#ifndef PR_USER_X509_CERTIFICATE
#define PR_USER_X509_CERTIFICATE (PROP_TAG(PT_MV_BINARY,0x3a70))
#endif

// it seems this is not an named prop?!
#ifndef PR_EMS_AB_X509_CERT
#define PR_EMS_AB_X509_CERT PROP_TAG(PT_MV_BINARY, 0x8c6a)
#endif

#ifndef PR_NT_SECURITY_DESCRIPTOR
#define PR_NT_SECURITY_DESCRIPTOR (PROP_TAG(PT_BINARY,0x0E27))
#endif

#ifndef PR_BODY_HTML
#define PR_BODY_HTML (PROP_TAG(PT_TSTRING,0x1013))
#endif

#ifndef PR_INTERNET_MESSAGE_ID 
#define PR_INTERNET_MESSAGE_ID PROP_TAG(PT_TSTRING, 0x1035)
#endif

//Same as PR_INBOUND_NEWSFEED_DN
//#ifndef PR_RULE_VERSION
//#define PR_RULE_VERSION	PROP_TAG( PT_I2, 0x668D)
//#endif

//#ifndef	PR_STORE_SLOWLINK
//#define PR_STORE_SLOWLINK PROP_TAG( PT_BOOLEAN,	0x7c0a)
//#endif

#ifndef	PR_SMTP_ADDRESS
#define PR_SMTP_ADDRESS PROP_TAG(PT_TSTRING,0x39FE)
#endif

#ifndef PR_SMTP_ADDRESS_W
#define PR_SMTP_ADDRESS_W PROP_TAG(PT_UNICODE,0x39FE)
#endif

#ifndef	PR_DEF_POST_MSGCLASS
#define PR_DEF_POST_MSGCLASS PROP_TAG(PT_STRING8, 0x36E5)
#endif

#ifndef	PR_DEF_POST_DISPLAYNAME
#define PR_DEF_POST_DISPLAYNAME	PROP_TAG(PT_TSTRING, 0x36E6)
#endif

#ifndef	PR_INTERNET_ARTICLE_NUMBER
#define PR_INTERNET_ARTICLE_NUMBER PROP_TAG(PT_LONG, 0x0E23)
#endif

#ifndef	PR_FREEBUSY_ENTRYIDS
#define PR_FREEBUSY_ENTRYIDS PROP_TAG(PT_MV_BINARY, 0x36E4)
#endif

//in the msdn, but left out of mapitags.h
#ifndef	PR_SEND_INTERNET_ENCODING	
#define PR_SEND_INTERNET_ENCODING PROP_TAG(PT_LONG, 0x3A71)
#endif

#ifndef	PR_RECIPIENT_TRACKSTATUS	
#define PR_RECIPIENT_TRACKSTATUS PROP_TAG(PT_LONG, 0x5FFF)
#endif

#ifndef	PR_RECIPIENT_FLAGS	
#define PR_RECIPIENT_FLAGS PROP_TAG(PT_LONG, 0x5FFD)
#endif

#ifndef	PR_RECIPIENT_ENTRYID	
#define PR_RECIPIENT_ENTRYID PROP_TAG(PT_BINARY, 0x5FF7)
#endif

#ifndef	PR_RECIPIENT_DISPLAY_NAME	
#define PR_RECIPIENT_DISPLAY_NAME PROP_TAG(PT_TSTRING, 0x5FF6)
#endif

#ifndef	PR_ICON_INDEX	
#define PR_ICON_INDEX PROP_TAG(PT_LONG, 0x1080)
#endif

#ifndef	PR_OST_OSTID
#define PR_OST_OSTID PROP_TAG(PT_BINARY, 0x7c04)
#endif

#ifndef	PR_OFFLINE_FOLDER
#define PR_OFFLINE_FOLDER PROP_TAG(PT_BINARY, 0x7c05)
#endif

#ifndef	PR_FAV_DISPLAY_NAME
#define PR_FAV_DISPLAY_NAME PROP_TAG(PT_TSTRING, 0x7C00)
#endif

#ifndef	PR_FAV_DISPLAY_ALIAS
#define PR_FAV_DISPLAY_ALIAS PROP_TAG(PT_TSTRING, 0x7C01)
#endif

#ifndef	PR_FAV_PUBLIC_SOURCE_KEY
#define PR_FAV_PUBLIC_SOURCE_KEY PROP_TAG(PT_BINARY, 0x7C02)
#endif

#ifndef	PR_FAV_AUTOSUBFOLDERS
#define PR_FAV_AUTOSUBFOLDERS PROP_TAG(PT_LONG, 0x7d01)
#endif

#ifndef	PR_FAV_PARENT_SOURCE_KEY
#define PR_FAV_PARENT_SOURCE_KEY PROP_TAG(PT_BINARY, 0x7d02)
#endif

#ifndef	PR_FAV_LEVEL_MASK
#define PR_FAV_LEVEL_MASK PROP_TAG(PT_LONG, 0x7D03)
#endif

#ifndef	PR_FAV_KNOWN_SUBS
#define PR_FAV_KNOWN_SUBS PROP_TAG(PT_BINARY, 0x7D04)
#endif

#ifndef	PR_FAV_GUID_MAP
#define PR_FAV_GUID_MAP PROP_TAG(PT_BINARY, 0x7D05)
#endif

#ifndef	PR_FAV_KNOWN_DELS_OLD
#define PR_FAV_KNOWN_DELS_OLD PROP_TAG(PT_BINARY, 0x7D06)
#endif

#ifndef	PR_FAV_INHERIT_AUTO
#define PR_FAV_INHERIT_AUTO PROP_TAG(PT_LONG, 0x7d07)
#endif

#ifndef	PR_FAV_DEL_SUBS
#define PR_FAV_DEL_SUBS PROP_TAG(PT_BINARY, 0x7D08)
#endif

#ifndef	PR_FAV_CONTAINER_CLASS
#define PR_FAV_CONTAINER_CLASS PROP_TAG(PT_TSTRING, 0x7D09)
#endif

#ifndef	PR_IN_REPLY_TO_ID
#define PR_IN_REPLY_TO_ID PROP_TAG(PT_TSTRING, 0x1042)
#endif

#ifndef PR_ATTACH_FLAGS
#define PR_ATTACH_FLAGS PROP_TAG(PT_LONG, 0x3714)
#endif

#ifndef PR_ATTACHMENT_LINKID
#define PR_ATTACHMENT_LINKID PROP_TAG(PT_LONG, 0x7FFA)
#endif

#ifndef PR_EXCEPTION_STARTTIME
#define PR_EXCEPTION_STARTTIME PROP_TAG(PT_SYSTIME, 0x7FFB)
#endif

#ifndef PR_EXCEPTION_ENDTIME
#define PR_EXCEPTION_ENDTIME PROP_TAG(PT_SYSTIME, 0x7FFC)
#endif

#ifndef PR_ATTACHMENT_FLAGS
#define PR_ATTACHMENT_FLAGS PROP_TAG(PT_LONG, 0x7FFD)
#endif

#ifndef PR_ATTACHMENT_HIDDEN
#define PR_ATTACHMENT_HIDDEN PROP_TAG(PT_BOOLEAN, 0x7FFE)
#endif

#ifndef PR_ATTACHMENT_CONTACTPHOTO
#define PR_ATTACHMENT_CONTACTPHOTO PROP_TAG(PT_BOOLEAN, 0x7FFF)
#endif

#ifndef PR_CONFLICT_ITEMS
#define PR_CONFLICT_ITEMS PROP_TAG(PT_MV_BINARY,0x1098)
#endif

#ifndef PR_INTERNET_APPROVED
#define PR_INTERNET_APPROVED PROP_TAG(PT_TSTRING,0x1030)
#endif

#ifndef PR_INTERNET_CONTROL
#define PR_INTERNET_CONTROL PROP_TAG(PT_TSTRING,0x1031)
#endif

#ifndef PR_INTERNET_DISTRIBUTION
#define PR_INTERNET_DISTRIBUTION PROP_TAG(PT_TSTRING,0x1032)
#endif

#ifndef PR_INTERNET_FOLLOWUP_TO
#define PR_INTERNET_FOLLOWUP_TO PROP_TAG(PT_TSTRING,0x1033)
#endif

#ifndef PR_INTERNET_LINES
#define PR_INTERNET_LINES PROP_TAG(PT_LONG,0x1034)
#endif

#ifndef PR_INTERNET_NEWSGROUPS
#define PR_INTERNET_NEWSGROUPS PROP_TAG(PT_TSTRING,0x1036)
#endif

#ifndef PR_INTERNET_NNTP_PATH
#define PR_INTERNET_NNTP_PATH PROP_TAG(PT_TSTRING,0x1038)
#endif

#ifndef PR_INTERNET_ORGANIZATION
#define PR_INTERNET_ORGANIZATION PROP_TAG(PT_TSTRING,0x1037)
#endif

#ifndef PR_INTERNET_PRECEDENCE
#define PR_INTERNET_PRECEDENCE PROP_TAG(PT_TSTRING,0x1041)
#endif

#ifndef PR_INTERNET_REFERENCES
#define PR_INTERNET_REFERENCES PROP_TAG(PT_TSTRING,0x1039)
#endif

#ifndef PR_NEWSGROUP_NAME
#define PR_NEWSGROUP_NAME PROP_TAG(PT_TSTRING,0x0E24)
#endif

#ifndef PR_NNTP_XREF
#define PR_NNTP_XREF PROP_TAG(PT_TSTRING,0x1040)
#endif

#ifndef PR_POST_FOLDER_ENTRIES
#define PR_POST_FOLDER_ENTRIES PROP_TAG(PT_BINARY,0x103B)
#endif

#ifndef PR_POST_FOLDER_NAMES
#define PR_POST_FOLDER_NAMES PROP_TAG(PT_TSTRING,0x103C)
#endif

#ifndef PR_POST_REPLY_FOLDER_ENTRIES
#define PR_POST_REPLY_DENIED PROP_TAG(PT_BINARY,0x103F)
#endif

#ifndef PR_POST_REPLY_FOLDER_ENTRIES
#define PR_POST_REPLY_FOLDER_ENTRIES PROP_TAG(PT_BINARY,0x103D)
#endif

#ifndef PR_POST_REPLY_FOLDER_NAMES
#define PR_POST_REPLY_FOLDER_NAMES PROP_TAG(PT_TSTRING,0x103E)
#endif

#ifndef PR_SUPERSEDES
#define PR_SUPERSEDES PROP_TAG(PT_TSTRING,0x103A)
#endif

#define PR_PACKED_NAME_PROPS		PROP_TAG(PT_BINARY, 0x361C)

#define PR_IPM_APPOINTMENT_ENTRYID	PROP_TAG(PT_BINARY, 0x36D0)
#define PR_IPM_CONTACT_ENTRYID		PROP_TAG(PT_BINARY, 0x36D1)
#define PR_IPM_JOURNAL_ENTRYID		PROP_TAG(PT_BINARY, 0x36D2)
#define PR_IPM_NOTE_ENTRYID			PROP_TAG(PT_BINARY, 0x36D3)
#define PR_IPM_TASK_ENTRYID			PROP_TAG(PT_BINARY, 0x36D4)
#define PR_REM_ONLINE_ENTRYID		PROP_TAG(PT_BINARY, 0x36D5)
#define PR_REM_OFFLINE_ENTRYID		PROP_TAG(PT_BINARY, 0x36D6)
#define PR_IPM_DRAFTS_ENTRYID		PROP_TAG(PT_BINARY, 0x36D7)
#define PR_IPM_OL2007_ENTRYIDS		PROP_TAG(PT_BINARY, 0x36D9)

/*
PR_IPM_OL2007_ENTRYIDS:
	This is a single binary property containing the entryids for:
	- 'Rss feeds' folder
	- The searchfolder 'Tracked mail processing'
	- The searchfolder 'To-do list'

	However, it is encoded something like the following:

	01803200 (type: rss feeds ?)
	0100
	2E00
	00000000B774162F0098C84182DE9E4358E4249D01000B41FF66083D464EA7E34D6026C9B143000000006DDA0000 (entryid)
	04803200 (type: tracked mail processing ?)
	0100
	2E00
	00000000B774162F0098C84182DE9E4358E4249D01000B41FF66083D464EA7E34D6026C9B143000000006DDB0000 (entryid)
	02803200 (type: todo list ?)
	0100
	2E00
	00000000B774162F0098C84182DE9E4358E4249D01000B41FF66083D464EA7E34D6026C9B143000000006DE40000 (entryid)
	00000000 (terminator?)

	It may also only contain the rss feeds entryid, and then have the 00000000 terminator directly after the entryid:

	01803200 (type: rss feeds ?)
	0100
	2E00
	00000000B774162F0098C84182DE9E4358E4249D01000B41FF66083D464EA7E34D6026C9B143000000006DDA0000 (entryid)
	00000000 (terminator?)

PR_ADDITIONAL_REN_ENTRYIDS:
	This is a multivalued property which contains entry IDs for certain special folders. 
	The first 5 (0-4) entries in this multivalued property are as follows: 
		0 - Conflicts folder
		1 - Sync Issues folder
		2 - Local Failures folder
		3 - Server Failures folder
		4 - Junk E-mail Folder
		5 - sfSpamTagDontUse (unknown what this is, disable olk spam stuff?)
*/
#define PR_ADDITIONAL_REN_ENTRYIDS	PROP_TAG(PT_MV_BINARY, 0x36D8)

// Extra MAPI defines
//GetHierarchyTable(..) and GetContentsTable(..)
#define SHOW_SOFT_DELETES		((ULONG) 0x00000002)
//DeleteFolder(...)
#define DELETE_HARD_DELETE		((ULONG) 0x00000010)

#define PR_MDN_DISPOSITION_TYPE			PROP_TAG(PT_STRING8, 0x0080)
#define PR_MDN_DISPOSITION_SENDINGMODE	PROP_TAG(PT_STRING8, 0x0081)

#define PR_LAST_VERB_EXECUTED			PROP_TAG(PT_LONG, 0x1081)
#define PR_LAST_VERB_EXECUTION_TIME		PROP_TAG(PT_SYSTIME, 0x1082)

#ifndef EXCHIVERB_FORWARD
#define EXCHIVERB_FORWARD		104
#endif

//The following properties are used in MAPI restrictions: 
// Used when searching for attachment contents. 
#define PR_SEARCH_ATTACHMENTS			PROP_TAG(PT_TSTRING, 0x0EA5)
#define PR_SEARCH_ATTACHMENTS_A			PROP_TAG(PT_STRING8, 0x0EA5)
#define PR_SEARCH_ATTACHMENTS_W			PROP_TAG(PT_UNICODE, 0x0EA5)

// Used when searching for email address or display names the message was sent to.
#define PR_SEARCH_RECIP_EMAIL_TO		PROP_TAG(PT_TSTRING, 0x0EA6)
#define PR_SEARCH_RECIP_EMAIL_TO_A		PROP_TAG(PT_STRING8, 0x0EA6)
#define PR_SEARCH_RECIP_EMAIL_TO_W		PROP_TAG(PT_UNICODE, 0x0EA6)

// Used when searching for email address or display names the message was Cc'ed.
#define PR_SEARCH_RECIP_EMAIL_CC		PROP_TAG(PT_TSTRING, 0x0EA7)
#define PR_SEARCH_RECIP_EMAIL_CC_A		PROP_TAG(PT_STRING8, 0x0EA7)
#define PR_SEARCH_RECIP_EMAIL_CC_W		PROP_TAG(PT_UNICODE, 0x0EA7)

// Used when searching for email address or display names the message was Bcc'ed. 
// This is only interesting for messages not yet sent otherwise the BCC information will not be there.
#define PR_SEARCH_RECIP_EMAIL_BCC		PROP_TAG(PT_TSTRING, 0x0EA8)
#define PR_SEARCH_RECIP_EMAIL_BCC_A		PROP_TAG(PT_STRING8, 0x0EA8)
#define PR_SEARCH_RECIP_EMAIL_BCC_W		PROP_TAG(PT_UNICODE, 0x0EA8)

#define PR_FOLDER_XVIEWINFO_E			PROP_TAG(PT_BINARY, 0x36E0)
#define PR_FOLDER_DISPLAY_FLAGS			PROP_TAG(PT_BINARY, 0x36DA)
#define PR_NET_FOLDER_FLAGS				PROP_TAG(PT_LONG, 0x36DE)
#define PR_FOLDER_WEBVIEWINFO			PROP_TAG(PT_BINARY, 0x36DF) 
#define PR_FOLDER_VIEWS_ONLY			PROP_TAG(PT_LONG, 0x36E1)

#define MDB_ONLINE ((ULONG) 0x00000100)
#define MAPI_NO_CACHE ((ULONG) 0x00000200)


#define PR_MANAGED_FOLDER_INFORMATION	PROP_TAG(PT_LONG, 0x672D)
#define PR_MANAGED_FOLDER_STORAGE_QUOTA	PROP_TAG(PT_LONG, 0x6731)

/* delegate properties */
/* from exchange private range? */
#define PR_SCHDINFO_DELEGATE_NAMES			PROP_TAG(PT_MV_STRING8, 0x6844)
#define PR_SCHDINFO_DELEGATE_ENTRYIDS		PROP_TAG(PT_MV_BINARY, 0x6845)
#define PR_DELEGATE_FLAGS					PROP_TAG(PT_MV_LONG, 0x686B)

#define DELEGATE_FLAG_SEE_PRIVATE	1

#define PR_TODO_ITEM_FLAGS				PROP_TAG(PT_LONG, 0x0E2B)
#define PR_FOLLOWUP_ICON				PROP_TAG(PT_LONG, 0x1095)
#define PR_FLAG_STATUS					PROP_TAG(PT_LONG, 0x1090)
#define PR_FLAG_COMPLETE_TIME			PROP_TAG(PT_SYSTIME, 0x1091)
#define PR_INETMAIL_OVERRIDE_FORMAT		PROP_TAG(PT_LONG, 0x5902)

/* GetMessageStatus */
#define MSGSTATUS_DRAFT 0x20000
#define MSGSTATUS_ANSWERED 0x10000


#define FL_PREFIX_ON_ANY_WORD 			0x00000010
#define FL_PHRASE_MATCH					0x00000020


/* from edkmapi.h .. or so they say on internet */
/* Values of PR_NDR_REASON_CODE */
#ifndef MAPI_REASON
#define MAPI_REASON(_code)	((LONG) _code)
#define MAPI_REASON_TRANSFER_FAILED           MAPI_REASON( 0 )
#define MAPI_REASON_TRANSFER_IMPOSSIBLE       MAPI_REASON( 1 )
#define MAPI_REASON_CONVERSION_NOT_PERFORMED  MAPI_REASON( 2 )
#define MAPI_REASON_PHYSICAL_RENDITN_NOT_DONE MAPI_REASON( 3 )
#define MAPI_REASON_PHYSICAL_DELIV_NOT_DONE   MAPI_REASON( 4 )
#define MAPI_REASON_RESTRICTED_DELIVERY       MAPI_REASON( 5 )
#define MAPI_REASON_DIRECTORY_OPERATN_FAILED  MAPI_REASON( 6 )
#endif

#endif
