.\" You can view this file with:
.\" nroff -man [file]
.\" Adapted from libcurl docs by fandom@retemail.es
.TH TclCurl n "20 May 2003" "TclCurl 0.10.5" "TclCurl Easy Interface"
.SH NAME
TclCurl: - get  a  URL with FTP, TELNET, LDAP, GOPHER, DICT, FILE, HTTP or HTTPS syntax.
.SH SYNOPSIS
.BI "curl::init"
.sp
.IB curlHandle " configure " "?options?"
.sp
.IB curlHandle " perform"
.sp
.IB curlHandle " duhandle"
.sp
.IB curlHandle " getinfo " curlinfo_option
.sp
.IB curlhandle " cleanup"
.sp
.BI curl::transfer " ?options?"
.sp
.BI curl::version
.sp
.BI "curl::escape " url 
.sp
.BI "curl::unescape " url 
.sp
.BI "curl::curlConfig " option 
.sp
.BI "curl::versioninfo " option 

.SH DESCRIPTION
The TclCurl extension gives Tcl programmers access to the libcurl
library written by
.B Daniel Stenberg,
with it you can download urls, upload them and many other neat tricks,
for more information check
.I http://curl.haxx.se
.SH curl::init
This procedure must be the first one to call, it returns a
.I curlHandle
that you need to use to invoke TclCurl procedures. The init calls intializes
curl and this call MUST have a corresponding call to
.I cleanup
when the operation is completed.
You should perform all your sequential file transfers using the same
curlHandle. This enables TclCurl to use persistant connections when
possible.
.sp
.B RETURN VALUE
.sp
.I curlHandle
to use.
.SH curlHandle configure ?options?
.sp
.B configure
is called to set the options for the transfer. Most operations in TclCurl
have default actions, and by using the appropriate options you can
make them behave differently (as documented). All options are set with
the
.I option
followed by a parameter.
.sp
.B Notes:
the options set with this procedure are valid for the
forthcoming data transfers that are performed when you invoke
.I perform
.sp
The options are not reset between transfers (except where noted), so if
you want subsequent transfers with different options, you must change them
between the transfers.
.sp
.I "curlHandle"
is the return code from the
.I "curl::init"
call.
.sp

.BOPTIONS
.sp
.SH Behaviour options

.TP
.B -verbose
Set the parameter to non-zero to get the library to display a lot of verbose
information about its operations. Very useful for libcurl and/or protocol
debugging and understanding.

You hardly ever want this set in production use, you will almost always want
this when you debug/report problems. Another neat option for debugging is
.B -debugproc

.TP
.B -header
A non-zero parameter tells the extension to include the headers in the body
output. This is only relevant for protocols that actually have headers preceding
the  data (like HTTP).

.TP
.B -noprogress
A non-zero parameter tells the extension to turn on the built-in progress meter.
Nowadays it is turn off by default.

.TP
.B -nosignal
A non zero parameter tells TclCurl not use any functions that install signal
handlers or any functions that cause signals to be sent to the process. This
option is mainly here to allow multi-threaded unix applications to still
set/use all timeout options etc, without risking getting signals.


.SH Callback options

.TP
.B -writeproc
Use it to set a Tcl procedure that will be invoked by TclCurl as soon as
there is received data that needs to be saved. The procedure will receive
a single parameter with the data to be saved.

.TP
.B -file
File in which the transfered data will be saved.

.TP
.B -readproc
Sets a Tcl procedure to be called by TclCurl as soon as it needs to read
data in order to send it to the peer. The procedure has to take one
parameter, which will contain the maximun numbers of bytes to read. It
should return the actual number of bytes read, or '0' if you want to
stop the transfer.

.TP
.B -infile
File from which the data will be transfered.

.TP
.B -progressproc
Name of the Tcl procedure that will invoked by TclCurl whenever there is
new data, the prototype of the procedure must be:
.sp
.B proc ProgressCallback {dltotal dlnow ultotal ulnow}
.sp
In order to this option to work you have to set the \fBnoprogress\fP
option to '0'. Setting this option to the empty string will restore the
original progress function.

.TP
.B -writeheader
Pass a the file name to be used to write the header part of the received data to.
The headers are guaranteed to be written one-by-one to this file and
only complete lines are written. Parsing headers should be easy enough using
this.

.TP
.B -debugproc
Name of the procedure that will receive the debug data produced by the
.B -verbose
option, it should match the following prototype:
.sp
.B debugProc {infoType data}
.sp
where \fBinfoType\fP specifies what kind of information it is (0 text,
1 incoming header, 2 outgoing header, 3 incoming data, 4 outgoing data).

.SH Error Options

.TP
.B -errorbuffer
Pass a variable name where TclCurl may store human readable error
messages in. This may be more helpful than just the return code from the
command.

.TP
.B -stderr
Pass a file name as parameter. This is the stream to use internally instead
of stderr when reporting errors.
.TP
.B -failonerror
A non-zero parameter tells the extension to fail silently if the HTTP code
returned is equal or larger than 300. The default action would be to return
the page normally, ignoring that code.

.SH Network options

.TP
.B -url
The actual URL to deal with.

\fBNOTE\fP: this the one option required to be set
before
.B perform
is called.

.TP
.B -proxy
If you need to use a http proxy to access the outside world, set the
proxy string with this option. To specify port number in this string,
append :[port] to the end of the host name. The proxy string may be
prefixed with [protocol]:// since any such prefix will be ignored.

\fBNOTE\fP: when you tell the extension to use a HTTP proxy,
TclCurl will transparently convert operations to HTTP even if you
specify a FTP URL etc. This may have an impact on what other features
of the library you can use, such as
.B quote
and similar FTP specifics that will not work unless you tunnel through
the HTTP proxy. Such tunneling  is activated with
.B proxytunnel

\fBNOTE2\fP: TclCurl respects the environment variables http_proxy,
ftp_proxy, all_proxy etc, if any of those are set.

\fBNOTE3\fP: TclCurl doesn't understand Microsoft's NTLM protocol for
proxies.

.TP
.B -proxyport
Use this option to set the proxy port to use unless it is specified in
the proxy string by \fB-proxy\fP.

.TP
.B -proxytype
Pass the type of  the  proxy. Available options are 'http' and 'socks5',
with the HTTP one being default.

.TP
.B -httpproxytunnel
Set the parameter to non-zero to get the extension to tunnel all non-HTTP
operations through the given HTTP proxy. Do note that there is a big
difference between using a proxy and tunneling through it. If you don't know what
this means, you probably don't want this tunnel option.

.TP
.B -interface
Pass the interface name to use as outgoing
network interface. The name can be an interface name, an IP address or a host
name.

.TP
.B -dnscachetimeout
Pass the timeout in seconds. Name resolves will be kept in memory for this number
of seconds. Set to '0' to completely disable caching, or '-1' to make the
cached entries remain forever. By default, TclCurl caches info for 60 seconds. 

.TP
.B -dnsuseglobalcache
If the value passed is non-zero, it tells TclCurl to use a global DNS cache that
will survive between curl handles creations and deletions. This is not thread-safe
as it uses a global varible.

.TP
.B -buffersize
Pass your prefered size for the receive buffer in TclCurl. The main point of this
would be that the write callback gets called more often and with smaller chunks.
This is just treated as a request, not an order. You cannot be guaranteed to
actually get the given size.

.SH Names and Passwords options

.TP
.B -netrc
A non-zero parameter tells the extension to scan your
.B ~/.netrc
file to find user name and password for the remote site you are about to
access. Do note that TclCurl does not verify that the file has the correct
properties set (as the standard unix ftp client does), and that only machine
name, user name and password is taken into account (init macros and similar
things are not supported).

You can set it to the following values:
.RS
.TP 5
.B optional
The use of your ~/.netrc file is optional, and information in the URL is to
be preferred. The file will be scanned with the host and user name (to find
the password only) or with the host only, to find the first user name and
password after that machine, which ever information is not specified in
the URL.

Undefined  values  of  the  option  will  have this effect.
.TP
.B ignored
The extension will ignore the file and use only the information in the URL.
This is the default.
.TP
.B required
This value tells the library that use of the file is required, to ignore
the information in the URL, and to search the file with the host only.
.RE

.TP
.B -userpwd
Pass a string as parameter, which should be [username]:[password] to use for
the connection.

.TP
.B -proxyuserpwd
Pass a string as parameter, which should be [username]:[password] to use for
the connection to the HTTP proxy.


.SH HTTP options

.TP
.B -encoding
Sets the contents of the Accept-Encoding: header sent in an HTTP
request, and enables decoding of a response when a Content-Encoding:
header is received.  Three encodings are supported: \fIidentity\fP,
which does nothing, \fIdeflate\fP which requests the server to
compress its response using the zlib algorithm, and \fIgzip\fP which
requests the gzip algorithm.  Use \fIall\fP to send an
Accept-Encoding: header containing all supported encodings.

This is a request, not an order; the server may or may not do it.  This
option must be set or else any unsolicited
encoding done by the server is ignored. See the special file
lib/README.encoding in libcurl docs for details.

.TP
.B -followlocation
A non-zero parameter tells the library to follow any
.B Location: header
that the server sends as part of a HTTP header.

\fBNOTE\fP: this means that the extension will re-send the  same
request on the new location and follow new \fBLocation: headers\fP
all the way until no more such headers are returned.
\fB-maxredirs\fP can be used to limit the number of redirects
TclCurl will follow.

.TP
.B -unrestrictedauth
A non-zero parameter tells the extension it can continue
to  send authentication (user+password) when following
locations, even when hostname changed. Note that  this
is  meaningful  only  when setting \fB-followlocation\fP.

.TP
.B -maxredirs
Sets the redirection limit. If that many redirections have been followed,
the next redirect will cause an error. This option only makes sense if the
\fB-followlocation\fP option is used at the same time.

.TP
.B -put
A non-zero parameter tells the extension to use HTTP PUT a file. The file to put
must be set with
\fB-infile\fP and \fB-infilesize\fP.

.TP
.B -post
A non-zero parameter tells the library to do a regular HTTP post. This is a
normal application/x-www-form-urlencoded kind, which is the most commonly used
one by HTML forms. See the \fB-postfields\fP option for how to specify the
data to post and \fB-postfieldsize\fP about how to set the data size.

Starting with TclCurl 0.7.8, this option is obsolete. Using the
\fB-postfields\fP option will imply it.

.TP
.B -postfields
Pass a string as parameter, which should be the full data to post in a HTTP
post operation. This is a normal application/x-www-form-urlencoded  kind,
which is the most commonly used one by HTML forms.

\fBNote\fP: to make multipart/formdata posts (aka rfc1867-posts), check out
.B httppost
option.

.TP
.B -postfieldsize
If you want to post data to the server without letting TclCurl do a strlen()
to measure the data size, this option must be used. Also, when this option is
used, you can post fully binary data which otherwise is likely to fail. If
this size is set to zero, the library will use strlen() to get the data
size.

.TP
.B -httppost
Tells TclCurl you want a multipart/formdata HTTP POST to be made and you
instruct what data to pass on to the server through a
.B Tcl list.

\fBThis is the only case where the data is reset after a transfer.\fP

First, there are some basics you need to understand about multipart/formdata
posts. Each part consists of at least a \fBNAME\fP and a \fBCONTENTS\fP part. If the part
is made for file upload, there are also a stored \fBCONTENT-TYPE\fP and a
\fBFILENAME\fP. Below here, we'll discuss on what options you use to set these
properties in the parts you want to add to your post.

The list must contain a \fB'name'\fP tag with the name of the section followed
by a string with the name, there are three tags to indicate the value of
the section: \fB'value'\fP followed by a string with the data to post, \fB'file'\fP
followed by the name of the file to post and \fB'contenttype'\fP with the
type of the data (text/plain, image/jpg, ...), you can also indicate a \fIfalse\fP
file name with \fB'filename'\fP, this is useful in case the server checks if the given
file name is valid, for example, by testing if it starts with 'c:\\' as any real file
name does. You can also post the content of a variable as if it were a file with
the options \fB'bufferName'\fP and \fB'buffer'\fP

Should you need to specify extra headers for the form POST section, use
\fB'contentheader\fP' followed by a list with the headers to post.

Please see 'httpPost.tcl' and 'httpBufferPost.tcl' for examples.

.TP
.B -referer
Pass a string as parameter. It will be used to set the
.B referer
header in the http request sent to the remote server. This can be used to
fool servers or scripts. You can also set any custom header with 
.B -httpheader.

.TP
.B -useragent
Pass a string as parameter. It will be used to set the
.B user-agent:
header in the http request sent to the remote server. This can be used to fool
servers or scripts. You can also set any custom header with 
.B -httpheader.

.TP
.B -httpheader
Pass a
.B list
with the HTTP headers to pass to the server in your request.
If you add a header that is otherwise generated
and used by TclCurl internally, your added one will be used instead. If you
add a header with no contents as in 'Accept:', the internally used header will
just get disabled. Thus, using this option you can add new headers, replace
and remove internal headers.

\fBNOTE\fP:The most commonly replaced headers have "shortcuts" in the  options:
.B cookie, useragent,
and
.B referer.

.TP
.B -http200aliases
Pass a list of aliases to be treated as valid HTTP 200 responses. Some servers
respond with a custom header response line. For example, IceCast servers respond
with "ICY 200 OK". By including this string in your list of aliases, the
response will be treated as a valid HTTP header line such as "HTTP/1.0 200 OK".

\fBNOTE\fP:The alias itself is not parsed for any version strings. So if your
alias is "MYHTTP/9.9", TclCurl will not treat the server as responding with
HTTP version 9.9. Instead TclCurl will use the value set by option
.B httpversion

.TP
.B -cookie
Pass a string as parameter. It will be used to
set a cookie in the http request. The format of the string should be
'[NAME]=[CONTENTS];'. Where NAME is the cookie name and  CONTENTS is
what the cookie should contain.

If  you  need  to  set mulitple cookies, you need to set them all using
a single option and thus you need to concat them all in one single string.
Set multiple cookies in one string like this: "name1=content1; name2=content2;"
etc.

Using this option multiple times will only make the latest string override
the previously ones.

.TP
.B -cookiefile
Pass a string as parameter. It should contain the name of your file holding
cookie data. The cookie data may be in netscape cookie data format or just
regular HTTP-style headers dumped to a file.

Given an empty or non-existing file, this option will enable cookies for this
curl handle, making it understand and parse received cookies and then use
matching cookies in future requests.

.TP
.B -cookiejar
Pass a file name in which TclCurl will dump all internally known cookies
when
.B curlHandle cleanup
is called. If no cookies are known, no file will be created.
Specify "-" to have the cookies written to stdout.

Using this option also enables cookies for this session, so if you, for
example, follow a location it will make matching cookies get sent accordingly.

TclCurl will not and cannot report an error for  this. Using  '\fBverbose\fP'
will get a warning to display, but that is the only visible feedback you get
about this possibly lethal situation.

.TP
.B -timecondition
This defines how the
.B timevalue
value is treated. You can set this parameter to
\fBifmodsince\fP or \fBifunmodsince\fP. This is a HTTP-only feature.

.TP
.B -timevalue
This should be the time in seconds since 1 jan 1970, and the time will be
used in a condition as specified with
.B timecondition.

.TP
.B -httpget
If set to non-zero forces the HTTP request to get back to GET. Only really
usable if POST, PUT or a custom request have been used previously with the
same handle.

.TP
.B -httpversion
Set to one of the values decribed below, they force TclCurl to use the
specific http versions. It should only be used if you really MUST do
that because of a silly remote server.
.RS
.TP 5
.B none
We do not care about what version the library uses. TclCurl will use whatever
it thinks fit.
.TP
.B 1.0
Enforce HTTP 1.0 requests.
.TP
.B 1.1
Enforce HTTP 1.1 requests.
.RE


.SH FTP options

.TP
.B -ftpport
Pass a string as parameter. It will be used to
get the IP address to use for the ftp PORT instruction. The PORT instruction
tells the remote server to connect to our specified IP address. The string may
be a plain IP address, a host name, a network interface name (under unix) or
just a '-' to let the library use your systems default IP address. Default FTP
operations are passive, and thus will not use PORT.

.TP
.B -quote
Pass a
.B list
with the FTP commands to pass to the server prior to your ftp request. This will be
done before any other FTP commands are issued (even before the CWD command).If you
do not want to transfer any files, set
.B nobody
to '1' and
.B header
to '0'.

.TP
.B -postquote
Pass a
.B list
with the FTP commands to pass to the server after your ftp transfer request.
If you do not want to transfer any files, set
.B nobody
to '1' and
.B header
to '0'.

.TP
.B -prequote
Pass a
.B list
of FTP commands to issue
.I just before
the transfer command (RETR or STOR etc).

.TP
.B -ftplistonly
A non-zero parameter tells the library to just list the names of a ftp
directory, instead of doing a full directory listing that would include file
sizes, dates etc.

This causes an FTP NLST command to be sent. Beware that some FTP servers list
only files in their response to NLST they might not include subdirectories
and symbolic links.

.TP
.B -ftpappend
A non-zero parameter tells the extension to append to the remote file instead of
overwriting it. This is only useful when uploading to a ftp site.

.TP
.B -ftpuseeprt
Set to non-zero, to tell TclCurl to use the EPRT (and LPRT) command when doing
active FTP downloads (which is enabled by '\fBftpport\fP'). Using EPRT means
that it will first attempt to use EPRT and then LPRT before using PORT, if
you pass zero to this option, it will not try using EPRT or LPRT, only plain PORT.

.TP
.B -ftpuseepvs
Set to one to tell TclCurl to use the EPSV command when doing passive FTP
downloads (which it always does by default). Using EPSV means that it will
first attempt to use EPSV before using PASV, but if you pass a zero to this
option, it will not try using EPSV, only plain PASV.

.SH Protocol options


.TP
.B -transfertext
A non-zero parameter tells the extension to use ASCII mode for ftp transfers,
instead of the default binary transfer. For LDAP transfers it gets the data
in plain text instead of HTML and for win32 systems it does not set the stdout
to binary mode. This option can be usable when transferring text data between
systems with different views on certain characters, such as newlines or similar.

.TP
.B -crlf
Convert unix newlines to CRLF newlines on FTP transfers.

.TP
.B -range
Pass a string as parameter, which should contain the specified range you
want. It should be in the format
.I "X-Y"
, where X or Y may be left out. HTTP
transfers also support several intervals, separated with commas as in
.I "X-Y,N-M"
Using this kind of multiple intervals will cause the HTTP server to send the
response document in pieces.

.TP
.B -resumefrom
Pass the offset in number of bytes that you want the transfer to start from.

.TP
.B -customrequest
Pass a string as parameter. It will be used instead of GET or HEAD when doing
the HTTP request. This is useful for doing DELETE or other more obscure HTTP
requests. Do not do this at will, make sure your server supports the command first.

.TP
.B -filetime
If you pass a non-zero value, TclCurl will attempt to get the
modification date of the remote document in this operation. This requires that
the remote server sends the time or replies to a time querying command. The
getinfo procedure with the
.I filetime
argument can be used after a transfer to extract the received time (if any).

.TP
.B -nobody
A non-zero parameter tells the library not to include the body-part in the
output. This is only relevant for protocols that have a separate header and
body part.

.TP
.B -infilesize
When uploading a file to a remote site, this option should be used to tell
TclCurl what the expected size of the infile is.

.TP
.B -upload
A non-zero parameter tells the library to prepare for an upload. The
.B -infile
and
.B -infilesize
options are also interesting for uploads.


.SH Connection options

.B -timeout
Pass the maximum time in seconds that you allow
the TclCurl transfer operation to take. Do note that normally, name lookups
may take a considerable time and that limiting the operation to less than a
few minutes risks aborting perfectly normal operations. This option will
cause libcurl to use the SIGALRM to enable time-outing system calls.

\fBNOTE\fP: this is not recommended to use in unix multithreaded programs,
as it uses signals unless
.B -nosignal
is set.

.TP
.B -lowspeedlimit
Pass the speed in bytes per second that the transfer should be below during
.B lowspeedtime
seconds for the extension to consider it too slow and abort.

.TP
.B -lowspeedtime
Pass the time in seconds that the transfer should be below the
.B lowspeedlimit
for the extension to consider it too slow and abort.

.TP
.B -maxconnects
Sets the persistant connection cache size. The set amount will be the maximum
amount of simultaneous connections that TclCurl may cache between file transfers.
Default is 5, and there is not much point in changing this value unless you are
perfectly aware of how this works and changes the behaviour of TclCurl.

When reaching the maximum limit, TclCurl uses the
.B closepolicy
to figure out which of the existing connections to close to prevent the number of
open connections to increase.

\fBNote\fP: if you have already performed transfers with this curl handle,
setting a smaller
.B maxconnects
than before may cause open connections to unnecessarily get closed.

.TP
.B -closepolicy
This option sets what policy TclCurl should use when the
connection cache is filled and one of the open connections has to be closed to
make room for a new connection. Use \fBleastrecentlyused\fP
to make libcurl close the connection that was least recently used, that connection
is also least likely to be capable of reuse. Use \fBoldest\fP
to make libcurl close the oldest connection, the one that was created first
among the ones in the connection cache.

.TP
.B -connecttimeout
Maximum time in seconds that you allow the
connection to the server to take.  This only limits the connection phase, once
it has connected, this option is of no more use. Set to zero to disable
connection timeout (it will then only timeout on the internal timeouts).

\fBNOTE\fP: It is not recommended to use in unix multithreaded programs, as
it uses signals unless \fB-nosignal\fP is set.

.SH SSL and security options

.TP
.B -sslcert
Pass a string as parameter. The string should be the file name of your certificate.
The default format is "PEM" and can be changed with \fB-sslcerttype\fP.

.TP
.B -sslcerttype
Pass a string as parameter. The string should be the format of your certificate.
Supported formats are "PEM" and "DER".

.TP
.B -sslcertpasswd
Pass a string as parameter. It will be used as the password required to use the
\fB-sslcert\fP certificate

\fBNOTE:\fPThis option is replaced by \fB-sslkeypasswd\fP and only
kept for backward compatibility. You never need a pass phrase to load
a certificate but you need one to load your private key.

.TP
.B -sslkey
Pass a pointer to a zero terminated string as parameter. The string should be
the file name of your private key. The default format is "PEM" and can be
changed with \fB-sslkeytype\fP.

.TP
.B -sslkeytype
Pass a pointer to a zero terminated string as parameter. The string should be
the format of your private key. Supported formats are "PEM", "DER" and "ENG"

\fBNOTE:\fPThe format "ENG" enables you to load the private key from a crypto
engine. in this case \fB-sslkey\fP is used as an identifier passed to
the engine. You have to set the crypto engine with \fB-sslengine\fP.

.TP
.B -sslkeypasswd
Pass a string as parameter. It will be used as the password required to use the
\fB-sslkey\fP private key.

.TP
.B -sslengine
Pass a string as parameter. It will be used as the identifier for the crypto
engine you want to use for your private key.

\fBNOTE:\fPIf the crypto device cannot be loaded, an error will be returned.

.TP
.B -sslenginedefault
Sets the actual crypto engine as the default for (asymetric) crypto operations.

\fBNOTE:\fPIf the crypto device cannot be set, an error will be returned.

.TP
.B -sslversion
Pass what version of SSL to attempt to use, 2 or 3. By default, the SSL library
will try to solve this by itself although some servers make this difficult, that is
why you at times will have to use this option.

.TP
.B -sslverifypeer
Pass a zero value to stop TclCurl from verifying the peer's certificate. Alternate
certificates to verify against can be specified with the \fB-cainfo\fP option or a
certificate directory can be specified with the \fB-capath\fP option. 
\fB-sslverifyhost\fP may also need to be set to 1 or 0 if \fB-sslverifypeer\fP is
disabled (it defaults to 2).

.TP
.B -cainfo
Pass a file naming holding the certificate to verify the peer with. This only makes
sense when used in combination with the \fB-sslverifypeer\fP option.

.TP
.B -capath
Pass the directory holding multiple CA certificates to verify the peer with.
The certificate directory must be prepared using the openssl c_rehash utility.
This only makes sense when used in combination with the  \fB-sslverifypeer\fP
option.

.TP
.B -randomfile
Pass a file name. The file will be used to read from to seed the random engine
for SSL. The more random the specified file is, the more secure will the SSL
connection become.

.TP
.B -egdsocket
Pass a path name to the Entropy Gathering Daemon socket. It will be used to seed
the random engine for SSL.

.TP
.B -sslverifyhost
Set to non-zero if we should verify the Common name from the peer certificate
in the SSL handshake, set 1 to check existence, 2 to ensure that it matches
the provided hostname. (It defaults to 2)

.TP
.B -sslcypherlist
Pass a string holding the ciphers to use for the SSL connection.
The list must consists of one or more cipher strings separated by
colons. Commas or spaces are also acceptable separators but colons
are normally used, , - and + can be used as operators. Valid examples
of cipher lists include 'RC4-SHA',  'SHA1+DES', 'TLSv1' and 'DEFAULT'.
The default list is normally set when you compile OpenSSL.

You will find more details about cipher lists on this URL:
    http://www.openssl.org/docs/apps/ciphers.html


.TP
.B -krb4level
Set the krb4 security level, this also enables krb4 awareness. This is a
string, 'clear', 'safe', 'confidential' or 'private'. If the string is set
but does not match one of these, 'private' will be used. Set the string to
NULL to disable kerberos4. The kerberos support only works for FTP.

.SH TclCurl own options

.TP
.B -headervar
Name of the Tcl array variable where TclCurl will store the headers returned
by the server.

.TP
.B -bodyvar
Name of the Tcl variable where TclCurl will store the file requested, the file
may contain text or binary data.

.TP
.B -canceltransvar
Name of a Tcl variable, in case you have defined a procedure to call with
\fB-progressproc\fP setting this variable to '1' will cancel the transfer.


.SH NOT SUPPORTED
Some of the options libcurl offers are not supported, I don't think them
worth supporting in TclCurl but if you need one of them don't forget to
complain:
.sp
.B CURLOPT_PASSWDFUNCTION, CURLOPT_PASSWDDATA, CURLOPT_FRESH_CONNECT,
.B CURLOPT_FORBID_REUSE, CURLOPT_PRIVATE.

.SH curlHandle perform
This procedure is called after the
.B init
and all the
.B configure
calls are made, and will perform the transfer as described in the options.
.sp
It must be called with the same
.I curlHandle
.B curl::init
call returned.
You can do any amount of calls to perform while using the same handle. If you
intend to transfer more than one file, you are even encouraged to do
so. TclCurl will then attempt to re-use the same connection for the following
transfers, thus making the operations faster, less CPU intense and using less
network resources. Just note that you will have to use
.I configure
between the invokes to set options for the following perform.
.sp
You must never call this procedure simultaneously from two places using the
same handle. Let it return first before invoking it another time. If
you want parallel transfers, you must use several curl handles.
.TP
.B RETURN VALUE
'0' if all went well, non-zero if it didn't. In case of error, if the
.I errorBuffer
was set with
.I configure
there will be a readable error message.
The error codes are:
.IP 1
Unsupported protocol. This build of TclCurl has no support for this protocol.
.IP 2
Very early initialization code failed. This is likely to be and internal error
or problem.
.IP 3
URL malformat. The syntax was not correct.
.IP 4
URL user malformatted. The user-part of the URL syntax was not correct.
.IP 5
Couldn't resolve proxy. The given proxy host could not be resolved.
.IP 6
Couldn't resolve host. The given remote host was not resolved.
.IP 7
Failed to connect to host or proxy.
.IP 8
FTP weird server reply. The server sent data TclCurl couldn't parse.
The given remote server is probably not an OK FTP server.
.IP 9
We were denied access when trying to login to a FTP server or when trying
to change working directory to the one given in the URL.
.IP 10
FTP user/password incorrect. Either one or both were not accepted by the
server.
.IP 11
FTP weird PASS reply. TclCurl couldn't parse the reply sent to the PASS request.
.IP 12
FTP weird USER reply. TclCurl couldn't parse the reply sent to the USER request.
.IP 13
FTP weird PASV reply, TclCurl couldn't parse the reply sent to the PASV request.
.IP 14
FTP weird 227 format. TclCurl couldn't parse the 227-line the server sent.
.IP 15
FTP can't get host. Couldn't resolve the host IP we got in the 227-line.
.IP 16
FTP can't reconnect. A bad return code on either PASV or EPSV was sent by the
FTP server, preventing TclCurl from being able to continue.
.IP 17
FTP couldn't set binary. Couldn't change transfer method to binary.
.IP 18
Partial file. Only a part of the file was transfered, this happens when
the server first reports an expected transfer size and then delivers data
that doesn't match the given size.
.IP 19
FTP couldn't RETR file, we either got a weird reply to a 'RETR' command or
a zero byte transfer.
.IP 20
FTP write error. After a completed file transferm the FTP server did not 
respond properly.
.IP 21
FTP quote error. A custom 'QUOTE' returned error code 400 or higher from the server.
.IP 22
HTTP not found. The requested page was not found. This return code only
appears if --fail is used and the HTTP server returns an error code that
is 400 or higher.
.IP 23
Write error. TclCurl couldn't write data to a local filesystem or an error
was returned from a write callback.
.IP 24
Malformat user. User name badly specified. Not in use anymore
.IP 25
FTP couldn't STOR file. The server denied the STOR operation, the error
buffer will usually have the server explanation.
.IP 26
Read error. There was a problem reading from a local file or an error was returned
from the read callback.
.IP 27
Out of memory. A memory allocation request failed. This should never happen unless
something weird is going on in your computer.
.IP 28
Operation timeout. The specified time-out period was reached according to the
conditions.
.IP 29
FTP couldn't set ASCII. The server returned an unknown reply.
.IP 30
FTP PORT command failed, this usually happens when you haven't specified a good
enough address for TclCurl to use.
.IP 31
FTP couldn't use REST. This should never happen is the server is sane.
.IP 32
FTP couldn't use the SIZE command. The command is an extension
to the original FTP spec RFC 959, so not all servers support it.
.IP 33
HTTP range error. The server doesn't support or accept range requests.
.IP 34
HTTP post error. Internal post-request generation error.
.IP 35
SSL connect error. The SSL handshaking failed, the error buffer may have
a clue to the reason, could be certificates, passwords, ...
.IP 36
FTP bad download resume. Couldn't continue an earlier aborted download, probably
because you are trying to resume beyond the file size.
.IP 37
A file given with FILE:// couldn't be read. Did you checked the permissions?
.IP 38
LDAP cannot bind. LDAP bind operation failed.
.IP 39
LDAP search failed.
.IP 40
Library not found. The LDAP library was not found.
.IP 41
A required LDAP function was not found.
.IP 42
Aborted by callback. An application told TclCurl to abort the operation.
.IP 43
Internal error. A function was called with a bad parameter.
.IP 44
Internal error. A function was called in a bad order.
.IP 45
Interface error. A specified outgoing interface could not be used.
.IP 46
Bad password entered. An error was signalled when the password was entered.
.IP 47
Too many redirects. When following redirects, TclCurl hit the maximum amount, set
your limit with --maxredirs
.IP 48
Unknown TELNET option specified.
.IP 49
A telnet option string was illegally formatted.
.IP 50
Currently not used.
.IP 51
The remote peer's SSL certificate wasn't ok
.IP 52
The server didn't reply anything, which here is considered an error.
.IP 53
The specified crypto engine wasn't found.
.IP 54
Failed setting the selected SSL crypto engine as default!
.IP 55
Failed sending network data.
.IP 56
Failure with receiving network data.
.IP 57
Share is in use (internal error)
.IP 58
Problem with the local certificate
.IP 59
Couldn't use specified SSL cipher
.IP 60
Problem with the CA cert (path? permission?)
.IP 61
Unrecognized transfer encoding


.SH curlHandle getinfo option
Request internal information from the curl session with this procedure.
This procedure is intended to get used *AFTER* a performed transfer,
all results from this function are undefined until the transfer is completed.
.B AVAILABLE INFORMATION
These are informations that can be extracted:

.TP
.B effectiveurl
Returns the last used effective URL.

.TP
.B httpcode
Returns the last received HTTP code.

.TP
.B filetime
Returns the remote time of the retrieved document. If you get -1, TclCurl
couldn't read it, which can be because of many reasons (unknown, the server
hides it or the server doesn't support the command that tells document time,
etc) and the time of the document is unknown.
.sp
In order for this to work you have to set the
.B -filetime
option before the transfer.

.TP
.B totaltime
Returns the total transaction time in seconds for the previous transfer.

.TP
.B namelookuptime
Returns the time, in seconds, it took from the start until the name resolving
was completed.

.TP
.B connecttime
Returns the time, in seconds, it took from the start until the connect to the
remote host (or proxy) was completed.

.TP
.B pretransfertime
Returns the time, in seconds, it took from the start until the file transfer
is just about to begin. This includes all pre-transfer commands and
negotiations that are specific to the particular protocol(s) involved.

.TP
.B starttransfertime
Returns the time, in seconds, it took from the start until the first byte
is just about to be transfered. This includes the
.B pretransfertime
and also the time the server needs to calculate the result.

.TP
.B redirecttime
Returns the total time, in seconds, it took for all redirection steps
including name lookup, connect, pretransfer and transfer before
the final transaction was started, it returns the complete execution
time for multiple redirections.

.TP
.B redirectcount
Returns the total number of redirections that were actually followed.

.TP
.B sizeupload
Returns the total amount of bytes that were uploaded.

.TP
.B sizedownload
Returns the total amount of bytes that were downloaded. The amount is only
for the latest transfer and will be reset again for each new transfer.

.TP
.B speeddownload
Returns the average download speed that curl measured for the complete download.

.TP
.B speedupload
Returns the average upload speed that curl measured for the complete upload.

.TP
.B headersize
Returns the total size of all the headers received.

.TP
.B requestsize
Returns the total size of the issued requests. This is so far only for HTTP
requests. Note that this may be more than one request if followLocation is true.

.TP
.B sslverifyresult
Returns the result of the certification verification that was requested
(using the -sslverifypeer option to configure).

.TP
.B contentlengthdownload
Returns the content-length of the download. This is the value read from the
.B Content-Length:
field.

.TP
.B contentlengthupload
Returns the specified size of the upload.

.TP
.B contenttype
Returns the content-type of the downloaded object. This is the value
read from the Content-Type: field. If you get an empty string, it  means
the server didn't send a valid Content-Type header or that the protocol
used doesn't support this.


.SH curlHandle duphandle
This procedure will return a new curl handle, a duplicate,
using all the options previously set in the input curl handle.
Both handles can subsequently be used independently and
they must both be freed with
.B cleanup.
The new handle will not inherit any state information,
connections, SSL sessions or cookies.
.TP
.B RETURN VALUE
A new curl handle or an error message if the copy fails.

.SH curlHandle cleanup
This procedure must be the last one to call for a curl session. It is the
opposite of the
.I curl::init
procedure and must be called with the same
.I curlhandle
as input as the curl::init call returned.
This will effectively close all connections TclCurl has used and possibly
has kept open until now. Don't call this procedure if you intend to transfer
more files.

.SH curl::transfer
In case you do not want to use persistant connections you can use this
command, it takes the same arguments as the \fIcurlHandle\fP \fBconfigure\fP
and will init, configure, perform and cleanup a connection for you.

You can also get the \fIgetinfo\fP information by using \fI-infooption variable\fP
pairs, after the transfer \fIvariable\fP will contain the value that would have
been returned by \fI$curlHandle getinfo option\fP.
.TP
.B RETURN VALUE
The same error code \fBperform\fP would return.

.SH curl::version
Returns a string with the version number of tclcurl, libcurl and some of
its important components (like OpenSSL version).
.TP
.B RETURN VALUE
The string with the version info.

.SH curl::escape url
This procedure will convert the given input string to an URL encoded string and
return that. All input characters that are not a-z,
A-Z or 0-9 will be converted to their "URL escaped" version (%NN where NN is a
two-digit hexadecimal number)
.TP
.B RETURN VALUE
The converted string.
.SH curl::unescape url
This procedure will convert the given URL encoded input string to a "plain
string" and return that. All input characters that
are URL encoded (%XX where XX is a two-digit hexadecimal number, or +) will be
converted to their plain text versions (up to a ? letter, no letters to the
right of a ? letter will be converted).
.TP
.B RETURN VALUE
The string unencoded.

.SH curl::curlConfig option
Returns some information about how you have
.B cURL
installed.

\fBNOTE\fP: Not available in the Windows version.

.TP
.B OPTIONS
.TP
.B -prefix
Returns the directory root where you installed
.B cURL
.TP
.B -feature
Returns a list containing particular main features the installed
.B libcurl
was built with. The list may include SSL, KRB4 or IPv6, do not
assume any particular order.
.TP
.B -vernum
Outputs  version  information  about  the installed libcurl, in
numerical mode.  This outputs the  version  number,  in hexadecimal,
with 8 bits for each part; major, minor, patch. So  that  libcurl
7.7.4 would appear as 070704 and libcurl 12.13.14 would appear as
0c0d0e...

.SH curl::versionInfo option
Returns information about various run-time features in TclCurl.

Applications should use this information to judge if things are possible to do
or not, instead of using compile-time checks, as dynamic/DLL libraries can be
changed independent of applications.

.TP
.B OPTIONS
.TP
.B -version
Returns the version of libcurl we are using.

.TP
.B -versionnum
Retuns the version of libcurl we are using in hexadecimal with 8 bits for each
part; major, minor, patch. So  that  libcurl 7.7.4 would appear as 070704 and
libcurl 12.13.14 would appear as 0c0d0e...

.TP
.B -host
Returns a string with the host information as discovered by a configure
script or set by the build environment.

.TP
.B -features
Returns a list with the features compiled into libcurl, the possible elements are:
'IPV6', 'KERBEROS4', 'SSL' and 'LIBZ'.

.TP
.B -sslversion
Returns a string with the OpenSSL version used, like 'OpenSSL/0.9.6b'.

.TP
.B -sslversionnum
Returns the numerical OpenSSL version value as defined by the OpenSSL project.
If libcurl has no SSL support, this is 0.

.TP
.B -libzversion
Returns a string, there is no numerical  version, for example: '1.1.3'.

.TP
.B -protocols
Returns a list with the protocols compiled into libcurl, 'ftp', 'http',...


.SH "SEE ALSO"
.I curl, curl_formparse, The art of HTTP scripting (at http://curl.haxx.se), RFC 2396,
