/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;

public class CFB
extends BaseMode {
    private byte[] shiftRegister;
    private byte[] scratch;

    public Object clone() {
        return new CFB(this);
    }

    public void setup() {
        if (this.modeBlockSize > this.cipherBlockSize) {
            throw new IllegalArgumentException("CFB block size cannot be larger than the cipher block size");
        }
        this.shiftRegister = new byte[this.cipherBlockSize];
        this.scratch = new byte[this.cipherBlockSize];
        System.arraycopy(this.iv, 0, this.shiftRegister, 0, Math.min(this.iv.length, this.cipherBlockSize));
    }

    public void teardown() {
        if (this.shiftRegister != null) {
            int n = 0;
            while (n < this.shiftRegister.length) {
                this.shiftRegister[n] = 0;
                ++n;
            }
        }
        this.shiftRegister = null;
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.cipher.encryptBlock(this.shiftRegister, 0, this.scratch, 0);
        int n3 = 0;
        while (n3 < this.modeBlockSize) {
            byArray2[n2 + n3] = (byte)(byArray[n + n3] ^ this.scratch[n3]);
            ++n3;
        }
        System.arraycopy(this.shiftRegister, this.modeBlockSize, this.shiftRegister, 0, this.cipherBlockSize - this.modeBlockSize);
        System.arraycopy(byArray2, n2, this.shiftRegister, this.cipherBlockSize - this.modeBlockSize, this.modeBlockSize);
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.cipher.encryptBlock(this.shiftRegister, 0, this.scratch, 0);
        int n3 = 0;
        while (n3 < this.modeBlockSize) {
            byArray2[n2 + n3] = (byte)(byArray[n + n3] ^ this.scratch[n3]);
            ++n3;
        }
        System.arraycopy(this.shiftRegister, this.modeBlockSize, this.shiftRegister, 0, this.cipherBlockSize - this.modeBlockSize);
        System.arraycopy(byArray, n, this.shiftRegister, this.cipherBlockSize - this.modeBlockSize, this.modeBlockSize);
    }

    CFB(IBlockCipher iBlockCipher, int n) {
        super("cfb", iBlockCipher, n);
    }

    private CFB(CFB cFB) {
        this((IBlockCipher)cFB.cipher.clone(), cFB.cipherBlockSize);
    }
}

