/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public class MatteBorder
extends EmptyBorder {
    static final long serialVersionUID = 4422248989617298224L;
    protected Color color;
    protected Icon tileIcon;

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.getBorderInsets();
        this.paintEdge(component, graphics, n, n2, n3, insets.top, 0, 0);
        this.paintEdge(component, graphics, n, n2 + n4 - insets.bottom, n3, insets.bottom, 0, n4 - insets.bottom);
        this.paintEdge(component, graphics, n, n2 + insets.top, insets.left, n4 - insets.top, 0, insets.top);
        this.paintEdge(component, graphics, n + n3 - insets.right, n2 + insets.top, insets.right, n4 - insets.bottom, n3 - insets.right, insets.top);
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, null);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.tileIcon != null && this.top < 0 && this.left < 0 && this.right < 0 && this.bottom < 0) {
            insets.left = insets.right = this.tileIcon.getIconWidth();
            insets.top = insets.bottom = this.tileIcon.getIconHeight();
            return insets;
        }
        return super.getBorderInsets(component, insets);
    }

    public Insets getBorderInsets() {
        return this.getBorderInsets(null, null);
    }

    public Color getMatteColor() {
        return this.color;
    }

    public Icon getTileIcon() {
        return this.tileIcon;
    }

    public boolean isBorderOpaque() {
        boolean bl = false;
        if (this.color != null && this.color.getAlpha() == 255) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintEdge(Component component, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 <= 0) return;
        if (n4 <= 0) {
            return;
        }
        if (this.color != null) {
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.color);
                graphics.fillRect(n, n2, n3, n4);
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                graphics.setColor(color);
                throw throwable;
            }
            {
                Object var14_13 = null;
                graphics.setColor(color);
                return;
            }
        }
        int n7 = this.tileIcon.getIconWidth();
        int n8 = this.tileIcon.getIconHeight();
        if (n7 <= 0) return;
        if (n8 <= 0) {
            return;
        }
        n5 %= n7;
        n6 %= n8;
        Graphics graphics2 = graphics.create();
        try {
            graphics2.setClip(n, n2, n3, n4);
            int n9 = n2 - n6;
            block6: while (n9 < n2 + n4) {
                int n10 = n - n5;
                while (true) {
                    if (n10 >= n + n3) {
                        n9 += n8;
                        continue block6;
                    }
                    this.tileIcon.paintIcon(component, graphics2, n10, n9);
                    n10 += n7;
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            graphics2.dispose();
            throw throwable;
        }
        {
            Object var14_15 = null;
            graphics2.dispose();
            return;
        }
    }

    public MatteBorder(int n, int n2, int n3, int n4, Color color) {
        super(n, n2, n3, n4);
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.color = color;
    }

    public MatteBorder(Insets insets, Color color) {
        this(insets.top, insets.left, insets.bottom, insets.right, color);
    }

    public MatteBorder(int n, int n2, int n3, int n4, Icon icon) {
        super(n, n2, n3, n4);
        if (icon == null) {
            throw new IllegalArgumentException();
        }
        this.tileIcon = icon;
    }

    public MatteBorder(Insets insets, Icon icon) {
        this(insets.top, insets.left, insets.bottom, insets.right, icon);
    }

    public MatteBorder(Icon icon) {
        this(-1, -1, -1, -1, icon);
    }
}

