/*
 **********************************************************************
 ** md4.h -- Header file for implementation of MD4		     **
 ** RSA Data Security, Inc. MD4 Message Digest Algorithm	     **
 ** Created: 2/17/90 RLR					     **
 ** Revised: 12/27/90 SRD,AJ,BSK,JT Reference C version 	     **
 **********************************************************************
 */

/*
 **********************************************************************
 ** Copyright (C) 1990, RSA Data Security, Inc. All rights reserved. **
 **								     **
 ** License to copy and use this software is granted provided that   **
 ** it is identified as the "RSA Data Security, Inc. MD4 Message     **
 ** Digest Algorithm" in all material mentioning or referencing this **
 ** software or this function.					     **
 **								     **
 ** License is also granted to make and use derivative works	     **
 ** provided that such works are identified as "derived from the RSA **
 ** Data Security, Inc. MD4 Message Digest Algorithm" in all         **
 ** material mentioning or referencing the derived work.	     **
 **								     **
 ** RSA Data Security, Inc. makes no representations concerning      **
 ** either the merchantability of this software or the suitability   **
 ** of this software for any particular purpose.  It is provided "as **
 ** is" without express or implied warranty of any kind.             **
 **								     **
 ** These notices must be retained in any copies of any part of this **
 ** documentation and/or software.				     **
 **********************************************************************
 */

#ifndef CMD4_H
#define CMD4_H

#include <stdio.h>
#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

#ifndef WIN32
#include <fstream>
#include <iostream>
using namespace std;
#else
#include <fstream.h>
#include <iostream.h>
#endif

/* typedef a 32 bit type */
typedef unsigned long int UINT4;

/* Data structure for MD4 (Message Digest) computation */
typedef struct {
  UINT4 i[2];			/* number of _bits_ handled mod 2^64 */
  UINT4 buf[4]; 				   /* scratch buffer */
  unsigned char in[64]; 			     /* input buffer */
  unsigned char digest[16];	/* actual digest after MD4Final call */
} MD4_CTX;

class MD4 {

public:
	MD4();
	virtual ~MD4() {};
	void init ();
	void update(unsigned char *inBuf,unsigned int inLen);
	void  update     (FILE *file);
	void finalize ();

	unsigned char *raw_digest ();  // digest as a 16-byte binary array
	void raw_digest( unsigned char * s );  // digest as a 16-byte binary array

	CString hex_digest(  unsigned char * p = 0 );  // digest as a 33-byte ascii-hex string
private:
	void transform (UINT4 *buf,UINT4 *in);
	MD4_CTX mdContext;
};

#endif
