/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.font.opentype.NameDecoder;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class GdkFontPeer
extends ClasspathFontPeer {
    private final int native_state;
    private static ResourceBundle bundle;
    private HashMap metricsCache;
    private ByteBuffer nameTable;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.nameTable = null;
    }

    static native void initStaticState();

    private native void initState();

    private native void dispose();

    private native void setFont(String var1, int var2, int var3);

    native void getFontMetrics(double[] var1);

    native void getTextMetrics(String var1, double[] var2);

    native void releasePeerGraphicsResource();

    protected void finalize() {
        this.releasePeerGraphicsResource();
        this.dispose();
    }

    private String buildString(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        return stringBuffer.toString();
    }

    private String buildString(CharacterIterator characterIterator, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (n <= n3) {
                stringBuffer.append(c);
            }
            if (n2 <= n3) break;
            c = characterIterator.next();
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String buildString(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2 - n);
    }

    public GdkFontPeer(String string, int n) {
        this(string, n, 12);
    }

    public GdkFontPeer(String string, int n, int n2) {
        super(string, n, n2);
        this.finit$();
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
    }

    public GdkFontPeer(String string, Map map) {
        super(string, map);
        this.finit$();
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
    }

    public String getSubFamilyName(Font font, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getName(2, locale)) == null && "Regular".equals(string = this.getName(2, Locale.ENGLISH))) {
            string = null;
        }
        return string;
    }

    private native byte[] getTrueTypeTable(byte var1, byte var2, byte var3, byte var4);

    public String getPostScriptName(Font font) {
        String string = this.getName(6, null);
        if (string == null) {
            return this.familyName;
        }
        return string;
    }

    private String getName(int n, Locale locale) {
        if (this.nameTable == null) {
            byte[] byArray = this.getTrueTypeTable((byte)110, (byte)97, (byte)109, (byte)101);
            if (byArray == null) {
                return null;
            }
            this.nameTable = ByteBuffer.wrap(byArray);
        }
        return NameDecoder.getName(this.nameTable, n, locale);
    }

    public boolean canDisplay(Font font, char c) {
        return true;
    }

    public int canDisplayUpTo(Font font, CharacterIterator characterIterator, int n, int n2) {
        return -1;
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new FreetypeGlyphVector(font, this.buildString(characterIterator), fontRenderContext);
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray) {
        return new FreetypeGlyphVector(font, nArray, fontRenderContext);
    }

    public byte getBaselineFor(Font font, char c) {
        return 0;
    }

    public LineMetrics getLineMetrics(Font font, CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return new GdkFontLineMetrics(this, this.getFontMetrics(font), n2 - n);
    }

    public Rectangle2D getMaxCharBounds(Font font, FontRenderContext fontRenderContext) {
        throw new UnsupportedOperationException();
    }

    public int getMissingGlyphCode(Font font) {
        throw new UnsupportedOperationException();
    }

    public String getGlyphName(Font font, int n) {
        throw new UnsupportedOperationException();
    }

    public int getNumGlyphs(Font font) {
        byte[] byArray = this.getTrueTypeTable((byte)109, (byte)97, (byte)120, (byte)112);
        if (byArray == null) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return byteBuffer.getShort(4);
    }

    public Rectangle2D getStringBounds(Font font, CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        FreetypeGlyphVector freetypeGlyphVector = new FreetypeGlyphVector(font, this.buildString(characterIterator, n, n2), fontRenderContext);
        return ((GlyphVector)freetypeGlyphVector).getVisualBounds();
    }

    public boolean hasUniformLineMetrics(Font font) {
        return true;
    }

    public GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        return new FreetypeGlyphVector(font, new String(cArray, n, n2 - n), fontRenderContext, n3);
    }

    public LineMetrics getLineMetrics(Font font, String string, FontRenderContext fontRenderContext) {
        return new GdkFontLineMetrics(this, this.getFontMetrics(font), string.length());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    GlyphMetrics getGlyphMetrics(int n) {
        return (GlyphMetrics)this.metricsCache.get(new Integer(n));
    }

    void putGlyphMetrics(int n, Object object) {
        this.metricsCache.put(new Integer(n), object);
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkFontPeer.initStaticState();
        try {
            bundle = ResourceBundle.getBundle("gnu.java.awt.peer.gtk.font");
        }
        catch (Throwable throwable) {
            bundle = null;
        }
    }

    private static class GdkFontLineMetrics
    extends LineMetrics {
        private FontMetrics fm;
        private int nchars;
        private float strikethroughOffset;
        private float strikethroughThickness;
        private float underlineOffset;
        private float underlineThickness;

        public GdkFontLineMetrics(GdkFontPeer gdkFontPeer, FontMetrics fontMetrics, int n) {
            this.fm = fontMetrics;
            this.nchars = n;
            this.strikethroughOffset = 0.0f;
            this.underlineOffset = 0.0f;
            this.underlineThickness = this.strikethroughThickness = gdkFontPeer.getSize(null) / 12.0f;
        }

        public float getAscent() {
            return this.fm.getAscent();
        }

        public int getBaselineIndex() {
            return 0;
        }

        public float[] getBaselineOffsets() {
            return new float[3];
        }

        public float getDescent() {
            return this.fm.getDescent();
        }

        public float getHeight() {
            return this.fm.getHeight();
        }

        public float getLeading() {
            return 0.0f;
        }

        public int getNumChars() {
            return this.nchars;
        }

        public float getStrikethroughOffset() {
            return 0.0f;
        }

        public float getStrikethroughThickness() {
            return 0.0f;
        }

        public float getUnderlineOffset() {
            return 0.0f;
        }

        public float getUnderlineThickness() {
            return 0.0f;
        }
    }
}

