/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.IMessageDigest;

public abstract class BaseHash
implements IMessageDigest {
    protected String name;
    protected int hashSize;
    protected int blockSize;
    protected long count;
    protected byte[] buffer;

    protected BaseHash(String string, int n, int n2) {
        this.name = string;
        this.hashSize = n;
        this.blockSize = n2;
        this.buffer = new byte[n2];
        this.resetContext();
    }

    public String name() {
        return this.name;
    }

    public int hashSize() {
        return this.hashSize;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public void update(byte by) {
        int n = (int)(this.count % (long)this.blockSize);
        ++this.count;
        this.buffer[n] = by;
        if (n == this.blockSize - 1) {
            this.transform(this.buffer, 0);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = (int)(this.count % (long)this.blockSize);
        this.count += (long)n2;
        int n4 = this.blockSize - n3;
        int n5 = 0;
        if (n2 >= n4) {
            System.arraycopy(byArray, n, this.buffer, n3, n4);
            this.transform(this.buffer, 0);
            n5 = n4;
            while (n5 + this.blockSize - 1 < n2) {
                this.transform(byArray, n + n5);
                n5 += this.blockSize;
            }
            n3 = 0;
        }
        if (n5 < n2) {
            System.arraycopy(byArray, n + n5, this.buffer, n3, n2 - n5);
        }
    }

    public byte[] digest() {
        byte[] byArray = this.padBuffer();
        this.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.getResult();
        this.reset();
        return byArray2;
    }

    public void reset() {
        this.count = 0L;
        int n = 0;
        while (n < this.blockSize) {
            this.buffer[n++] = 0;
        }
        this.resetContext();
    }

    public abstract Object clone();

    public abstract boolean selfTest();

    protected abstract byte[] padBuffer();

    protected abstract byte[] getResult();

    protected abstract void resetContext();

    protected abstract void transform(byte[] var1, int var2);
}

