/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.net;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.net.GraphCellIdentityMap;
import org.jgraph.net.GraphNetworkModelListener;
import org.jgraph.net.GraphNetworkModelPeer;

public class GraphNetworkModel
implements GraphNetworkModelListener {
    public static final String PROPERTY_DATASOURCE = new String("datasource");
    protected PropertyChangeSupport changeSupport;
    public GraphCellIdentityMap idMap = new GraphCellIdentityMap();
    protected GraphNetworkModelPeer server;
    protected GraphModel graphModel;
    protected GraphNetworkModelListener datasource;
    protected DefaultListModel clients;
    protected boolean isLocalEdit = true;

    public GraphNetworkModel(GraphModel graphModel) {
        this.changeSupport = new PropertyChangeSupport(this);
        this.clients = new DefaultListModel();
        this.graphModel = graphModel;
        this.graphModel.addGraphModelListener(new GraphModelListener(){

            public void graphChanged(GraphModelEvent graphModelEvent) {
                GraphNetworkModel.this.fireUpdate(graphModelEvent.getChange());
            }
        });
    }

    public void fireUpdate(GraphModelEvent.GraphModelChange graphModelChange) {
        if (this.isLocalEdit) {
            ParentMap parentMap = graphModelChange.getPreviousParentMap();
            if (graphModelChange.getInserted() != null && graphModelChange.getPreviousParentMap() == null) {
                parentMap = ParentMap.create(this.graphModel, graphModelChange.getInserted(), false, true);
            }
            this.networkModelChanged(null, graphModelChange.getRemoved(), graphModelChange.getInserted(), graphModelChange.getPreviousAttributes(), graphModelChange.getPreviousConnectionSet(), parentMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
        try {
            block6: {
                try {
                    this.isLocalEdit = false;
                    if (objectArray != null && objectArray.length > 0) {
                        this.graphModel.remove(objectArray);
                        break block6;
                    }
                    if (objectArray2 != null) {
                        this.graphModel.insert(objectArray2, map, connectionSet, parentMap, null);
                        break block6;
                    }
                    this.graphModel.edit(map, connectionSet, parentMap, null);
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception.getMessage());
                    Object var8_7 = null;
                    this.isLocalEdit = true;
                }
            }
            Object var8_6 = null;
            this.isLocalEdit = true;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.isLocalEdit = true;
            throw throwable;
        }
    }

    public void networkModelChanged(GraphNetworkModelListener graphNetworkModelListener, Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
        if (graphNetworkModelListener != null) {
            this.execute(objectArray, objectArray2, map, connectionSet, parentMap);
        }
        if (graphNetworkModelListener != this.datasource && this.datasource != null) {
            this.datasource.networkModelChanged(this, objectArray, objectArray2, map, connectionSet, parentMap);
        }
        int n = 0;
        while (n < this.clients.size()) {
            GraphNetworkModelListener graphNetworkModelListener2 = (GraphNetworkModelListener)this.clients.get(n);
            if (graphNetworkModelListener2 != graphNetworkModelListener) {
                graphNetworkModelListener2.networkModelChanged(this, objectArray, objectArray2, map, connectionSet, parentMap);
            }
            ++n;
        }
    }

    public void addNetworkModelListener(GraphNetworkModelListener graphNetworkModelListener) {
        this.clients.addElement(graphNetworkModelListener);
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        Object[] objectArray2 = DefaultGraphModel.getDescendants(this.graphModel, objectArray).toArray();
        ConnectionSet connectionSet = ConnectionSet.create(this.graphModel, objectArray2, false);
        ParentMap parentMap = ParentMap.create(this.graphModel, objectArray2, false, false);
        Map map = GraphConstants.createAttributesFromModel(objectArray2, this.graphModel);
        graphNetworkModelListener.networkModelChanged(this, null, objectArray2, map, connectionSet, parentMap);
    }

    public void removeNetworkModelListener(GraphNetworkModelListener graphNetworkModelListener) {
        this.clients.removeElement(graphNetworkModelListener);
    }

    public void setDatasource(String string) {
        try {
            if (this.datasource instanceof GraphNetworkModelPeer.Connection) {
                ((GraphNetworkModelPeer.Connection)this.datasource).stop();
            }
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            Socket socket = new Socket(string2, Integer.parseInt(string3));
            GraphNetworkModelPeer.Connection connection = new GraphNetworkModelPeer.Connection(string, socket, this);
            GraphNetworkModelListener graphNetworkModelListener = this.datasource;
            this.datasource = connection;
            this.changeSupport.firePropertyChange(PROPERTY_DATASOURCE, graphNetworkModelListener, this.datasource);
        }
        catch (IOException iOException) {}
    }

    public boolean isConnected() {
        return this.datasource != null;
    }

    public GraphCellIdentityMap getIdMap() {
        return this.idMap;
    }

    public void setIdMap(GraphCellIdentityMap graphCellIdentityMap) {
        this.idMap = graphCellIdentityMap;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public DefaultListModel getClients() {
        return this.clients;
    }

    public void setClients(DefaultListModel defaultListModel) {
        this.clients = defaultListModel;
    }

    public GraphNetworkModelPeer getServer() {
        return this.server;
    }

    public void setServer(GraphNetworkModelPeer graphNetworkModelPeer) {
        this.server = graphNetworkModelPeer;
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-p") && stringArray.length > n + 1) {
                string = stringArray[n + 1];
            } else if (stringArray[n].equals("-s") && stringArray.length > n + 1) {
                string2 = stringArray[n + 1];
            }
            ++n;
        }
        DefaultGraphModel defaultGraphModel = new DefaultGraphModel();
        if (string != null) {
            System.out.println("Running server on port " + string);
            GraphNetworkModel graphNetworkModel = new GraphNetworkModel(defaultGraphModel);
            graphNetworkModel.setServer(new GraphNetworkModelPeer(Integer.parseInt(string), graphNetworkModel));
            if (string2 != null) {
                System.out.println("Connecting to " + string2);
                graphNetworkModel.setDatasource(string2);
            }
        } else {
            System.out.println("Usage: JGONetworkModel -p port -s host:port");
        }
    }
}

