/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.Graph;
import br.arca.morcego.Node;
import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcAppletClient;
import org.apache.xmlrpc.XmlRpcException;

public class GraphDataRetriever {
    private XmlRpcAppletClient client;
    private String url;

    public GraphDataRetriever(String server_url) {
        this.url = server_url;
        try {
            this.client = new XmlRpcAppletClient(server_url);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL " + this.url);
            e.printStackTrace();
        }
    }

    public Graph retrieveData(String centerNodeName) {
        Graph graph = new Graph();
        Vector<Object> params = new Vector<Object>();
        params.add(new String(centerNodeName));
        params.add(Config.getValue("navigationDepth"));
        Hashtable result = new Hashtable();
        try {
            result = (Hashtable)this.client.execute("getSubGraph", params);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Hashtable nodes = (Hashtable)result.get("graph");
        Enumeration eN = nodes.keys();
        while (eN.hasMoreElements()) {
            String nodeActionUrl;
            String nodeName = (String)eN.nextElement();
            Node node = new Node(nodeName, graph);
            Hashtable nodeData = (Hashtable)nodes.get(nodeName);
            Vector neighbours = (Vector)nodeData.get("neighbours");
            Enumeration eL = neighbours.elements();
            while (eL.hasMoreElements()) {
                node.addLink((String)eL.nextElement());
            }
            String nodeColor = (String)nodeData.get("color");
            if (nodeColor != null) {
                node.setColor(Color.decode(nodeColor));
            }
            if ((nodeActionUrl = (String)nodeData.get("actionUrl")) == null) continue;
            try {
                node.setActionUrl(new URL(nodeActionUrl));
            }
            catch (MalformedURLException e1) {}
        }
        return graph;
    }
}

