$OpenBSD: patch-gnats_cmds.c,v 1.4 2007/12/28 17:11:25 espie Exp $
--- gnats/cmds.c.orig	Sun Feb  4 21:56:10 2001
+++ gnats/cmds.c	Fri Dec 28 18:00:24 2007
@@ -115,28 +115,26 @@ get_text ()
 {
   register FILE *tf;
   char *path = (char *) xmalloc (PATH_MAX);
-#ifndef HAVE_MKTEMP
-  char name[L_tmpnam];
-#endif
   char *buf, *tmpdir;
   MsgType r;
-  int i;
+  int i, fd;
 
   tmpdir = getenv ("TMPDIR");
   if (tmpdir == NULL)
     tmpdir = "/tmp"; /* XXX */
-#ifdef HAVE_MKTEMP
-  sprintf (path, "%s/gnatsXXXXXX", tmpdir);
-  mktemp (path);
-#else
-  tmpnam (name);
-  strcpy (path, name);
-#endif
-
-  if ((tf = fopen (path, "w")) == (FILE *) NULL)
+  
+  snprintf (path, PATH_MAX, "%s/gnatsXXXXXX", tmpdir);
+  if ((fd = mkstemp (path)) < 0)
     {
+      xfree(path); 
+      return (NULL);
+    }
+  
+  if ((tf = fdopen (fd, "w")) == (FILE *) NULL)
+    {
       /* give error that we can't create the temp and leave. */
-      xfree (path);
+      close(fd);
+      xfree(path);
       return NULL;
     }
 
@@ -228,8 +226,8 @@ do_query (ac, av)
           p = av[i];
           if ((n = (char *) strchr (p, '/')) != NULL) /* Remove the category */
                p = ++n;
-          strcpy (pat, p);
-          strcat (pat, "\\'");
+          strlcpy (pat, p, sizeof(pat));
+          strlcat (pat, "\\'", sizeof(pat));
           for (j = index_chain ; j ; j = j->next)
        	    if (regcmp (pat, j->number) == 0)
               {
@@ -352,12 +350,13 @@ GNATS_lock (ac, av)
       /* XXX FIXME -- we need a cleaner approach to this.  */
       for (i = 2, len = 0; i < ac; i++)
 	len += strlen (av[i]);
-      l = (char *) xmalloc (sizeof (char) * len + ac - 2);
-      sprintf (l, "%s", av[2]);
+      len += ac - 2;
+      l = (char *) xmalloc (len);
+      snprintf (l, len, "%s", av[2]);
       for (i = 3; i < ac; i++)
 	{
-	  strcat (l, " ");
-	  strcat (l, av[i]);
+	  strlcat (l, " ", len);
+	  strlcat (l, av[i], len);
 	}
     }
 
@@ -461,7 +460,7 @@ GNATS_user (ac, av)
     }
   
   path = (char *) xmalloc (PATH_MAX);
-  sprintf (path, "%s/gnats-adm/%s", gnats_root, DB_ACCESS_FILE);
+  snprintf (path, PATH_MAX, "%s/gnats-adm/%s", gnats_root, DB_ACCESS_FILE);
   access = get_user_access (gnats_root, path, av[0], av[1]);
   xfree (path);
 
@@ -1531,8 +1530,8 @@ GNATS_auth (ac, av)
 	  return;
 	}
 
-      strcpy (keyfile, gnats_root);
-      strcat (keyfile, "/gnats-adm/srvtab");
+      strlcpy (keyfile, gnats_root, sizeof(keyfile));
+      strlcat (keyfile, "/gnats-adm/srvtab", sizeof(keyfile));
       /* Sanity-check installation.  */
       {
 	struct stat statbuf;
@@ -1601,7 +1600,7 @@ GNATS_auth (ac, av)
       p += 8;
       k.ticket.length = strlen (p) / 2;
       fromhex (k.ticket.dat, p, k.ticket.length);
-      strcpy (instance, "*");
+      strlcpy (instance, "*", sizeof(instance));
       status = krb_rd_req (&k.ticket, GNATS_KRB4_PRINCIPAL_NAME, instance,
 			   peer.sin_addr.s_addr, &k.auth, keyfile);
       if (status != KSUCCESS)
