# $OpenBSD: tk.port.mk,v 1.6 2009/05/19 21:14:52 sthen Exp $

CATEGORIES +=		x11/tk

MODTK_VERSION ?= 	8.5
MODTCL_VERSION ?= 	${MODTK_VERSION}

.if ${MODTK_VERSION} == 8.4
_MODTK_SPEC = tk->=${MODTK_VERSION},<8.5
.elif ${MODTK_VERSION} == 8.5
_MODTK_SPEC = tk->=${MODTK_VERSION},<8.6
.endif

MODTK_BIN ?=		${LOCALBASE}/bin/wish${MODTK_VERSION}
MODTK_INCDIR ?=		${LOCALBASE}/include/tk${MODTK_VERSION}
MODTK_LIBDIR ?=		${LOCALBASE}/lib/tk${MODTK_VERSION}
MODTK_CONFIG ?=		${MODTK_LIBDIR}/tkConfig.sh

USE_X11 =		Yes

SUBST_VARS +=		MODTK_VERSION MODTK_BIN

MODULES +=		lang/tcl

MODTK_BUILD_DEPENDS ?=	:${_MODTK_SPEC}:x11/tk/${MODTK_VERSION} \
			${MODTCL_BUILD_DEPENDS}
MODTK_RUN_DEPENDS ?=	:${_MODTK_SPEC}:x11/tk/${MODTK_VERSION} \
			${MODTCL_RUN_DEPENDS}
MODTK_LIB ?=		tk${MODTK_VERSION:S/.//}
MODTK_LIB_DEPENDS ?=	${MODTK_LIB}:${_MODTK_SPEC}:x11/tk/${MODTK_VERSION} \
			${MODTCL_LIB_DEPENDS}
