/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment media rendering library
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 *
 * Based on the gdkkeysyms.h file which is auto-generated from the
 * XOrg http://cvs.freedesktop.org/xorg/xc/include/keysymdef.h file.
 */

#ifndef __PGM_KEYSYMS_H__
#define __PGM_KEYSYMS_H__

#define PGM_VoidSymbol 0xffffff
#define PGM_BackSpace 0xff08
#define PGM_Tab 0xff09
#define PGM_Linefeed 0xff0a
#define PGM_Clear 0xff0b
#define PGM_Return 0xff0d
#define PGM_Pause 0xff13
#define PGM_Scroll_Lock 0xff14
#define PGM_Sys_Req 0xff15
#define PGM_Escape 0xff1b
#define PGM_Delete 0xffff
#define PGM_Multi_key 0xff20
#define PGM_Codeinput 0xff37
#define PGM_SingleCandidate 0xff3c
#define PGM_MultipleCandidate 0xff3d
#define PGM_PreviousCandidate 0xff3e
#define PGM_Kanji 0xff21
#define PGM_Muhenkan 0xff22
#define PGM_Henkan_Mode 0xff23
#define PGM_Henkan 0xff23
#define PGM_Romaji 0xff24
#define PGM_Hiragana 0xff25
#define PGM_Katakana 0xff26
#define PGM_Hiragana_Katakana 0xff27
#define PGM_Zenkaku 0xff28
#define PGM_Hankaku 0xff29
#define PGM_Zenkaku_Hankaku 0xff2a
#define PGM_Touroku 0xff2b
#define PGM_Massyo 0xff2c
#define PGM_Kana_Lock 0xff2d
#define PGM_Kana_Shift 0xff2e
#define PGM_Eisu_Shift 0xff2f
#define PGM_Eisu_toggle 0xff30
#define PGM_Kanji_Bangou 0xff37
#define PGM_Zen_Koho 0xff3d
#define PGM_Mae_Koho 0xff3e
#define PGM_Home 0xff50
#define PGM_Left 0xff51
#define PGM_Up 0xff52
#define PGM_Right 0xff53
#define PGM_Down 0xff54
#define PGM_Prior 0xff55
#define PGM_Page_Up 0xff55
#define PGM_Next 0xff56
#define PGM_Page_Down 0xff56
#define PGM_End 0xff57
#define PGM_Begin 0xff58
#define PGM_Select 0xff60
#define PGM_Print 0xff61
#define PGM_Execute 0xff62
#define PGM_Insert 0xff63
#define PGM_Undo 0xff65
#define PGM_Redo 0xff66
#define PGM_Menu 0xff67
#define PGM_Find 0xff68
#define PGM_Cancel 0xff69
#define PGM_Help 0xff6a
#define PGM_Break 0xff6b
#define PGM_Mode_switch 0xff7e
#define PGM_script_switch 0xff7e
#define PGM_Num_Lock 0xff7f
#define PGM_KP_Space 0xff80
#define PGM_KP_Tab 0xff89
#define PGM_KP_Enter 0xff8d
#define PGM_KP_F1 0xff91
#define PGM_KP_F2 0xff92
#define PGM_KP_F3 0xff93
#define PGM_KP_F4 0xff94
#define PGM_KP_Home 0xff95
#define PGM_KP_Left 0xff96
#define PGM_KP_Up 0xff97
#define PGM_KP_Right 0xff98
#define PGM_KP_Down 0xff99
#define PGM_KP_Prior 0xff9a
#define PGM_KP_Page_Up 0xff9a
#define PGM_KP_Next 0xff9b
#define PGM_KP_Page_Down 0xff9b
#define PGM_KP_End 0xff9c
#define PGM_KP_Begin 0xff9d
#define PGM_KP_Insert 0xff9e
#define PGM_KP_Delete 0xff9f
#define PGM_KP_Equal 0xffbd
#define PGM_KP_Multiply 0xffaa
#define PGM_KP_Add 0xffab
#define PGM_KP_Separator 0xffac
#define PGM_KP_Subtract 0xffad
#define PGM_KP_Decimal 0xffae
#define PGM_KP_Divide 0xffaf
#define PGM_KP_0 0xffb0
#define PGM_KP_1 0xffb1
#define PGM_KP_2 0xffb2
#define PGM_KP_3 0xffb3
#define PGM_KP_4 0xffb4
#define PGM_KP_5 0xffb5
#define PGM_KP_6 0xffb6
#define PGM_KP_7 0xffb7
#define PGM_KP_8 0xffb8
#define PGM_KP_9 0xffb9
#define PGM_F1 0xffbe
#define PGM_F2 0xffbf
#define PGM_F3 0xffc0
#define PGM_F4 0xffc1
#define PGM_F5 0xffc2
#define PGM_F6 0xffc3
#define PGM_F7 0xffc4
#define PGM_F8 0xffc5
#define PGM_F9 0xffc6
#define PGM_F10 0xffc7
#define PGM_F11 0xffc8
#define PGM_L1 0xffc8
#define PGM_F12 0xffc9
#define PGM_L2 0xffc9
#define PGM_F13 0xffca
#define PGM_L3 0xffca
#define PGM_F14 0xffcb
#define PGM_L4 0xffcb
#define PGM_F15 0xffcc
#define PGM_L5 0xffcc
#define PGM_F16 0xffcd
#define PGM_L6 0xffcd
#define PGM_F17 0xffce
#define PGM_L7 0xffce
#define PGM_F18 0xffcf
#define PGM_L8 0xffcf
#define PGM_F19 0xffd0
#define PGM_L9 0xffd0
#define PGM_F20 0xffd1
#define PGM_L10 0xffd1
#define PGM_F21 0xffd2
#define PGM_R1 0xffd2
#define PGM_F22 0xffd3
#define PGM_R2 0xffd3
#define PGM_F23 0xffd4
#define PGM_R3 0xffd4
#define PGM_F24 0xffd5
#define PGM_R4 0xffd5
#define PGM_F25 0xffd6
#define PGM_R5 0xffd6
#define PGM_F26 0xffd7
#define PGM_R6 0xffd7
#define PGM_F27 0xffd8
#define PGM_R7 0xffd8
#define PGM_F28 0xffd9
#define PGM_R8 0xffd9
#define PGM_F29 0xffda
#define PGM_R9 0xffda
#define PGM_F30 0xffdb
#define PGM_R10 0xffdb
#define PGM_F31 0xffdc
#define PGM_R11 0xffdc
#define PGM_F32 0xffdd
#define PGM_R12 0xffdd
#define PGM_F33 0xffde
#define PGM_R13 0xffde
#define PGM_F34 0xffdf
#define PGM_R14 0xffdf
#define PGM_F35 0xffe0
#define PGM_R15 0xffe0
#define PGM_Shift_L 0xffe1
#define PGM_Shift_R 0xffe2
#define PGM_Control_L 0xffe3
#define PGM_Control_R 0xffe4
#define PGM_Caps_Lock 0xffe5
#define PGM_Shift_Lock 0xffe6
#define PGM_Meta_L 0xffe7
#define PGM_Meta_R 0xffe8
#define PGM_Alt_L 0xffe9
#define PGM_Alt_R 0xffea
#define PGM_Super_L 0xffeb
#define PGM_Super_R 0xffec
#define PGM_Hyper_L 0xffed
#define PGM_Hyper_R 0xffee
#define PGM_ISO_Lock 0xfe01
#define PGM_ISO_Level2_Latch 0xfe02
#define PGM_ISO_Level3_Shift 0xfe03
#define PGM_ISO_Level3_Latch 0xfe04
#define PGM_ISO_Level3_Lock 0xfe05
#define PGM_ISO_Group_Shift 0xff7e
#define PGM_ISO_Group_Latch 0xfe06
#define PGM_ISO_Group_Lock 0xfe07
#define PGM_ISO_Next_Group 0xfe08
#define PGM_ISO_Next_Group_Lock 0xfe09
#define PGM_ISO_Prev_Group 0xfe0a
#define PGM_ISO_Prev_Group_Lock 0xfe0b
#define PGM_ISO_First_Group 0xfe0c
#define PGM_ISO_First_Group_Lock 0xfe0d
#define PGM_ISO_Last_Group 0xfe0e
#define PGM_ISO_Last_Group_Lock 0xfe0f
#define PGM_ISO_Left_Tab 0xfe20
#define PGM_ISO_Move_Line_Up 0xfe21
#define PGM_ISO_Move_Line_Down 0xfe22
#define PGM_ISO_Partial_Line_Up 0xfe23
#define PGM_ISO_Partial_Line_Down 0xfe24
#define PGM_ISO_Partial_Space_Left 0xfe25
#define PGM_ISO_Partial_Space_Right 0xfe26
#define PGM_ISO_Set_Margin_Left 0xfe27
#define PGM_ISO_Set_Margin_Right 0xfe28
#define PGM_ISO_Release_Margin_Left 0xfe29
#define PGM_ISO_Release_Margin_Right 0xfe2a
#define PGM_ISO_Release_Both_Margins 0xfe2b
#define PGM_ISO_Fast_Cursor_Left 0xfe2c
#define PGM_ISO_Fast_Cursor_Right 0xfe2d
#define PGM_ISO_Fast_Cursor_Up 0xfe2e
#define PGM_ISO_Fast_Cursor_Down 0xfe2f
#define PGM_ISO_Continuous_Underline 0xfe30
#define PGM_ISO_Discontinuous_Underline 0xfe31
#define PGM_ISO_Emphasize 0xfe32
#define PGM_ISO_Center_Object 0xfe33
#define PGM_ISO_Enter 0xfe34
#define PGM_dead_grave 0xfe50
#define PGM_dead_acute 0xfe51
#define PGM_dead_circumflex 0xfe52
#define PGM_dead_tilde 0xfe53
#define PGM_dead_macron 0xfe54
#define PGM_dead_breve 0xfe55
#define PGM_dead_abovedot 0xfe56
#define PGM_dead_diaeresis 0xfe57
#define PGM_dead_abovering 0xfe58
#define PGM_dead_doubleacute 0xfe59
#define PGM_dead_caron 0xfe5a
#define PGM_dead_cedilla 0xfe5b
#define PGM_dead_ogonek 0xfe5c
#define PGM_dead_iota 0xfe5d
#define PGM_dead_voiced_sound 0xfe5e
#define PGM_dead_semivoiced_sound 0xfe5f
#define PGM_dead_belowdot 0xfe60
#define PGM_dead_hook 0xfe61
#define PGM_dead_horn 0xfe62
#define PGM_First_Virtual_Screen 0xfed0
#define PGM_Prev_Virtual_Screen 0xfed1
#define PGM_Next_Virtual_Screen 0xfed2
#define PGM_Last_Virtual_Screen 0xfed4
#define PGM_Terminate_Server 0xfed5
#define PGM_AccessX_Enable 0xfe70
#define PGM_AccessX_Feedback_Enable 0xfe71
#define PGM_RepeatKeys_Enable 0xfe72
#define PGM_SlowKeys_Enable 0xfe73
#define PGM_BounceKeys_Enable 0xfe74
#define PGM_StickyKeys_Enable 0xfe75
#define PGM_MouseKeys_Enable 0xfe76
#define PGM_MouseKeys_Accel_Enable 0xfe77
#define PGM_Overlay1_Enable 0xfe78
#define PGM_Overlay2_Enable 0xfe79
#define PGM_AudibleBell_Enable 0xfe7a
#define PGM_Pointer_Left 0xfee0
#define PGM_Pointer_Right 0xfee1
#define PGM_Pointer_Up 0xfee2
#define PGM_Pointer_Down 0xfee3
#define PGM_Pointer_UpLeft 0xfee4
#define PGM_Pointer_UpRight 0xfee5
#define PGM_Pointer_DownLeft 0xfee6
#define PGM_Pointer_DownRight 0xfee7
#define PGM_Pointer_Button_Dflt 0xfee8
#define PGM_Pointer_Button1 0xfee9
#define PGM_Pointer_Button2 0xfeea
#define PGM_Pointer_Button3 0xfeeb
#define PGM_Pointer_Button4 0xfeec
#define PGM_Pointer_Button5 0xfeed
#define PGM_Pointer_DblClick_Dflt 0xfeee
#define PGM_Pointer_DblClick1 0xfeef
#define PGM_Pointer_DblClick2 0xfef0
#define PGM_Pointer_DblClick3 0xfef1
#define PGM_Pointer_DblClick4 0xfef2
#define PGM_Pointer_DblClick5 0xfef3
#define PGM_Pointer_Drag_Dflt 0xfef4
#define PGM_Pointer_Drag1 0xfef5
#define PGM_Pointer_Drag2 0xfef6
#define PGM_Pointer_Drag3 0xfef7
#define PGM_Pointer_Drag4 0xfef8
#define PGM_Pointer_Drag5 0xfefd
#define PGM_Pointer_EnableKeys 0xfef9
#define PGM_Pointer_Accelerate 0xfefa
#define PGM_Pointer_DfltBtnNext 0xfefb
#define PGM_Pointer_DfltBtnPrev 0xfefc
#define PGM_3270_Duplicate 0xfd01
#define PGM_3270_FieldMark 0xfd02
#define PGM_3270_Right2 0xfd03
#define PGM_3270_Left2 0xfd04
#define PGM_3270_BackTab 0xfd05
#define PGM_3270_EraseEOF 0xfd06
#define PGM_3270_EraseInput 0xfd07
#define PGM_3270_Reset 0xfd08
#define PGM_3270_Quit 0xfd09
#define PGM_3270_PA1 0xfd0a
#define PGM_3270_PA2 0xfd0b
#define PGM_3270_PA3 0xfd0c
#define PGM_3270_Test 0xfd0d
#define PGM_3270_Attn 0xfd0e
#define PGM_3270_CursorBlink 0xfd0f
#define PGM_3270_AltCursor 0xfd10
#define PGM_3270_KeyClick 0xfd11
#define PGM_3270_Jump 0xfd12
#define PGM_3270_Ident 0xfd13
#define PGM_3270_Rule 0xfd14
#define PGM_3270_Copy 0xfd15
#define PGM_3270_Play 0xfd16
#define PGM_3270_Setup 0xfd17
#define PGM_3270_Record 0xfd18
#define PGM_3270_ChangeScreen 0xfd19
#define PGM_3270_DeleteWord 0xfd1a
#define PGM_3270_ExSelect 0xfd1b
#define PGM_3270_CursorSelect 0xfd1c
#define PGM_3270_PrintScreen 0xfd1d
#define PGM_3270_Enter 0xfd1e
#define PGM_space 0x020
#define PGM_exclam 0x021
#define PGM_quotedbl 0x022
#define PGM_numbersign 0x023
#define PGM_dollar 0x024
#define PGM_percent 0x025
#define PGM_ampersand 0x026
#define PGM_apostrophe 0x027
#define PGM_quoteright 0x027
#define PGM_parenleft 0x028
#define PGM_parenright 0x029
#define PGM_asterisk 0x02a
#define PGM_plus 0x02b
#define PGM_comma 0x02c
#define PGM_minus 0x02d
#define PGM_period 0x02e
#define PGM_slash 0x02f
#define PGM_0 0x030
#define PGM_1 0x031
#define PGM_2 0x032
#define PGM_3 0x033
#define PGM_4 0x034
#define PGM_5 0x035
#define PGM_6 0x036
#define PGM_7 0x037
#define PGM_8 0x038
#define PGM_9 0x039
#define PGM_colon 0x03a
#define PGM_semicolon 0x03b
#define PGM_less 0x03c
#define PGM_equal 0x03d
#define PGM_greater 0x03e
#define PGM_question 0x03f
#define PGM_at 0x040
#define PGM_A 0x041
#define PGM_B 0x042
#define PGM_C 0x043
#define PGM_D 0x044
#define PGM_E 0x045
#define PGM_F 0x046
#define PGM_G 0x047
#define PGM_H 0x048
#define PGM_I 0x049
#define PGM_J 0x04a
#define PGM_K 0x04b
#define PGM_L 0x04c
#define PGM_M 0x04d
#define PGM_N 0x04e
#define PGM_O 0x04f
#define PGM_P 0x050
#define PGM_Q 0x051
#define PGM_R 0x052
#define PGM_S 0x053
#define PGM_T 0x054
#define PGM_U 0x055
#define PGM_V 0x056
#define PGM_W 0x057
#define PGM_X 0x058
#define PGM_Y 0x059
#define PGM_Z 0x05a
#define PGM_bracketleft 0x05b
#define PGM_backslash 0x05c
#define PGM_bracketright 0x05d
#define PGM_asciicircum 0x05e
#define PGM_underscore 0x05f
#define PGM_grave 0x060
#define PGM_quoteleft 0x060
#define PGM_a 0x061
#define PGM_b 0x062
#define PGM_c 0x063
#define PGM_d 0x064
#define PGM_e 0x065
#define PGM_f 0x066
#define PGM_g 0x067
#define PGM_h 0x068
#define PGM_i 0x069
#define PGM_j 0x06a
#define PGM_k 0x06b
#define PGM_l 0x06c
#define PGM_m 0x06d
#define PGM_n 0x06e
#define PGM_o 0x06f
#define PGM_p 0x070
#define PGM_q 0x071
#define PGM_r 0x072
#define PGM_s 0x073
#define PGM_t 0x074
#define PGM_u 0x075
#define PGM_v 0x076
#define PGM_w 0x077
#define PGM_x 0x078
#define PGM_y 0x079
#define PGM_z 0x07a
#define PGM_braceleft 0x07b
#define PGM_bar 0x07c
#define PGM_braceright 0x07d
#define PGM_asciitilde 0x07e
#define PGM_nobreakspace 0x0a0
#define PGM_exclamdown 0x0a1
#define PGM_cent 0x0a2
#define PGM_sterling 0x0a3
#define PGM_currency 0x0a4
#define PGM_yen 0x0a5
#define PGM_brokenbar 0x0a6
#define PGM_section 0x0a7
#define PGM_diaeresis 0x0a8
#define PGM_copyright 0x0a9
#define PGM_ordfeminine 0x0aa
#define PGM_guillemotleft 0x0ab
#define PGM_notsign 0x0ac
#define PGM_hyphen 0x0ad
#define PGM_registered 0x0ae
#define PGM_macron 0x0af
#define PGM_degree 0x0b0
#define PGM_plusminus 0x0b1
#define PGM_twosuperior 0x0b2
#define PGM_threesuperior 0x0b3
#define PGM_acute 0x0b4
#define PGM_mu 0x0b5
#define PGM_paragraph 0x0b6
#define PGM_periodcentered 0x0b7
#define PGM_cedilla 0x0b8
#define PGM_onesuperior 0x0b9
#define PGM_masculine 0x0ba
#define PGM_guillemotright 0x0bb
#define PGM_onequarter 0x0bc
#define PGM_onehalf 0x0bd
#define PGM_threequarters 0x0be
#define PGM_questiondown 0x0bf
#define PGM_Agrave 0x0c0
#define PGM_Aacute 0x0c1
#define PGM_Acircumflex 0x0c2
#define PGM_Atilde 0x0c3
#define PGM_Adiaeresis 0x0c4
#define PGM_Aring 0x0c5
#define PGM_AE 0x0c6
#define PGM_Ccedilla 0x0c7
#define PGM_Egrave 0x0c8
#define PGM_Eacute 0x0c9
#define PGM_Ecircumflex 0x0ca
#define PGM_Ediaeresis 0x0cb
#define PGM_Igrave 0x0cc
#define PGM_Iacute 0x0cd
#define PGM_Icircumflex 0x0ce
#define PGM_Idiaeresis 0x0cf
#define PGM_ETH 0x0d0
#define PGM_Eth 0x0d0
#define PGM_Ntilde 0x0d1
#define PGM_Ograve 0x0d2
#define PGM_Oacute 0x0d3
#define PGM_Ocircumflex 0x0d4
#define PGM_Otilde 0x0d5
#define PGM_Odiaeresis 0x0d6
#define PGM_multiply 0x0d7
#define PGM_Oslash 0x0d8
#define PGM_Ooblique 0x0d8
#define PGM_Ugrave 0x0d9
#define PGM_Uacute 0x0da
#define PGM_Ucircumflex 0x0db
#define PGM_Udiaeresis 0x0dc
#define PGM_Yacute 0x0dd
#define PGM_THORN 0x0de
#define PGM_Thorn 0x0de
#define PGM_ssharp 0x0df
#define PGM_agrave 0x0e0
#define PGM_aacute 0x0e1
#define PGM_acircumflex 0x0e2
#define PGM_atilde 0x0e3
#define PGM_adiaeresis 0x0e4
#define PGM_aring 0x0e5
#define PGM_ae 0x0e6
#define PGM_ccedilla 0x0e7
#define PGM_egrave 0x0e8
#define PGM_eacute 0x0e9
#define PGM_ecircumflex 0x0ea
#define PGM_ediaeresis 0x0eb
#define PGM_igrave 0x0ec
#define PGM_iacute 0x0ed
#define PGM_icircumflex 0x0ee
#define PGM_idiaeresis 0x0ef
#define PGM_eth 0x0f0
#define PGM_ntilde 0x0f1
#define PGM_ograve 0x0f2
#define PGM_oacute 0x0f3
#define PGM_ocircumflex 0x0f4
#define PGM_otilde 0x0f5
#define PGM_odiaeresis 0x0f6
#define PGM_division 0x0f7
#define PGM_oslash 0x0f8
#define PGM_ooblique 0x0f8
#define PGM_ugrave 0x0f9
#define PGM_uacute 0x0fa
#define PGM_ucircumflex 0x0fb
#define PGM_udiaeresis 0x0fc
#define PGM_yacute 0x0fd
#define PGM_thorn 0x0fe
#define PGM_ydiaeresis 0x0ff
#define PGM_Aogonek 0x1a1
#define PGM_breve 0x1a2
#define PGM_Lstroke 0x1a3
#define PGM_Lcaron 0x1a5
#define PGM_Sacute 0x1a6
#define PGM_Scaron 0x1a9
#define PGM_Scedilla 0x1aa
#define PGM_Tcaron 0x1ab
#define PGM_Zacute 0x1ac
#define PGM_Zcaron 0x1ae
#define PGM_Zabovedot 0x1af
#define PGM_aogonek 0x1b1
#define PGM_ogonek 0x1b2
#define PGM_lstroke 0x1b3
#define PGM_lcaron 0x1b5
#define PGM_sacute 0x1b6
#define PGM_caron 0x1b7
#define PGM_scaron 0x1b9
#define PGM_scedilla 0x1ba
#define PGM_tcaron 0x1bb
#define PGM_zacute 0x1bc
#define PGM_doubleacute 0x1bd
#define PGM_zcaron 0x1be
#define PGM_zabovedot 0x1bf
#define PGM_Racute 0x1c0
#define PGM_Abreve 0x1c3
#define PGM_Lacute 0x1c5
#define PGM_Cacute 0x1c6
#define PGM_Ccaron 0x1c8
#define PGM_Eogonek 0x1ca
#define PGM_Ecaron 0x1cc
#define PGM_Dcaron 0x1cf
#define PGM_Dstroke 0x1d0
#define PGM_Nacute 0x1d1
#define PGM_Ncaron 0x1d2
#define PGM_Odoubleacute 0x1d5
#define PGM_Rcaron 0x1d8
#define PGM_Uring 0x1d9
#define PGM_Udoubleacute 0x1db
#define PGM_Tcedilla 0x1de
#define PGM_racute 0x1e0
#define PGM_abreve 0x1e3
#define PGM_lacute 0x1e5
#define PGM_cacute 0x1e6
#define PGM_ccaron 0x1e8
#define PGM_eogonek 0x1ea
#define PGM_ecaron 0x1ec
#define PGM_dcaron 0x1ef
#define PGM_dstroke 0x1f0
#define PGM_nacute 0x1f1
#define PGM_ncaron 0x1f2
#define PGM_odoubleacute 0x1f5
#define PGM_udoubleacute 0x1fb
#define PGM_rcaron 0x1f8
#define PGM_uring 0x1f9
#define PGM_tcedilla 0x1fe
#define PGM_abovedot 0x1ff
#define PGM_Hstroke 0x2a1
#define PGM_Hcircumflex 0x2a6
#define PGM_Iabovedot 0x2a9
#define PGM_Gbreve 0x2ab
#define PGM_Jcircumflex 0x2ac
#define PGM_hstroke 0x2b1
#define PGM_hcircumflex 0x2b6
#define PGM_idotless 0x2b9
#define PGM_gbreve 0x2bb
#define PGM_jcircumflex 0x2bc
#define PGM_Cabovedot 0x2c5
#define PGM_Ccircumflex 0x2c6
#define PGM_Gabovedot 0x2d5
#define PGM_Gcircumflex 0x2d8
#define PGM_Ubreve 0x2dd
#define PGM_Scircumflex 0x2de
#define PGM_cabovedot 0x2e5
#define PGM_ccircumflex 0x2e6
#define PGM_gabovedot 0x2f5
#define PGM_gcircumflex 0x2f8
#define PGM_ubreve 0x2fd
#define PGM_scircumflex 0x2fe
#define PGM_kra 0x3a2
#define PGM_kappa 0x3a2
#define PGM_Rcedilla 0x3a3
#define PGM_Itilde 0x3a5
#define PGM_Lcedilla 0x3a6
#define PGM_Emacron 0x3aa
#define PGM_Gcedilla 0x3ab
#define PGM_Tslash 0x3ac
#define PGM_rcedilla 0x3b3
#define PGM_itilde 0x3b5
#define PGM_lcedilla 0x3b6
#define PGM_emacron 0x3ba
#define PGM_gcedilla 0x3bb
#define PGM_tslash 0x3bc
#define PGM_ENG 0x3bd
#define PGM_eng 0x3bf
#define PGM_Amacron 0x3c0
#define PGM_Iogonek 0x3c7
#define PGM_Eabovedot 0x3cc
#define PGM_Imacron 0x3cf
#define PGM_Ncedilla 0x3d1
#define PGM_Omacron 0x3d2
#define PGM_Kcedilla 0x3d3
#define PGM_Uogonek 0x3d9
#define PGM_Utilde 0x3dd
#define PGM_Umacron 0x3de
#define PGM_amacron 0x3e0
#define PGM_iogonek 0x3e7
#define PGM_eabovedot 0x3ec
#define PGM_imacron 0x3ef
#define PGM_ncedilla 0x3f1
#define PGM_omacron 0x3f2
#define PGM_kcedilla 0x3f3
#define PGM_uogonek 0x3f9
#define PGM_utilde 0x3fd
#define PGM_umacron 0x3fe
#define PGM_Babovedot 0x1001e02
#define PGM_babovedot 0x1001e03
#define PGM_Dabovedot 0x1001e0a
#define PGM_Wgrave 0x1001e80
#define PGM_Wacute 0x1001e82
#define PGM_dabovedot 0x1001e0b
#define PGM_Ygrave 0x1001ef2
#define PGM_Fabovedot 0x1001e1e
#define PGM_fabovedot 0x1001e1f
#define PGM_Mabovedot 0x1001e40
#define PGM_mabovedot 0x1001e41
#define PGM_Pabovedot 0x1001e56
#define PGM_wgrave 0x1001e81
#define PGM_pabovedot 0x1001e57
#define PGM_wacute 0x1001e83
#define PGM_Sabovedot 0x1001e60
#define PGM_ygrave 0x1001ef3
#define PGM_Wdiaeresis 0x1001e84
#define PGM_wdiaeresis 0x1001e85
#define PGM_sabovedot 0x1001e61
#define PGM_Wcircumflex 0x1000174
#define PGM_Tabovedot 0x1001e6a
#define PGM_Ycircumflex 0x1000176
#define PGM_wcircumflex 0x1000175
#define PGM_tabovedot 0x1001e6b
#define PGM_ycircumflex 0x1000177
#define PGM_OE 0x13bc
#define PGM_oe 0x13bd
#define PGM_Ydiaeresis 0x13be
#define PGM_overline 0x47e
#define PGM_kana_fullstop 0x4a1
#define PGM_kana_openingbracket 0x4a2
#define PGM_kana_closingbracket 0x4a3
#define PGM_kana_comma 0x4a4
#define PGM_kana_conjunctive 0x4a5
#define PGM_kana_middledot 0x4a5
#define PGM_kana_WO 0x4a6
#define PGM_kana_a 0x4a7
#define PGM_kana_i 0x4a8
#define PGM_kana_u 0x4a9
#define PGM_kana_e 0x4aa
#define PGM_kana_o 0x4ab
#define PGM_kana_ya 0x4ac
#define PGM_kana_yu 0x4ad
#define PGM_kana_yo 0x4ae
#define PGM_kana_tsu 0x4af
#define PGM_kana_tu 0x4af
#define PGM_prolongedsound 0x4b0
#define PGM_kana_A 0x4b1
#define PGM_kana_I 0x4b2
#define PGM_kana_U 0x4b3
#define PGM_kana_E 0x4b4
#define PGM_kana_O 0x4b5
#define PGM_kana_KA 0x4b6
#define PGM_kana_KI 0x4b7
#define PGM_kana_KU 0x4b8
#define PGM_kana_KE 0x4b9
#define PGM_kana_KO 0x4ba
#define PGM_kana_SA 0x4bb
#define PGM_kana_SHI 0x4bc
#define PGM_kana_SU 0x4bd
#define PGM_kana_SE 0x4be
#define PGM_kana_SO 0x4bf
#define PGM_kana_TA 0x4c0
#define PGM_kana_CHI 0x4c1
#define PGM_kana_TI 0x4c1
#define PGM_kana_TSU 0x4c2
#define PGM_kana_TU 0x4c2
#define PGM_kana_TE 0x4c3
#define PGM_kana_TO 0x4c4
#define PGM_kana_NA 0x4c5
#define PGM_kana_NI 0x4c6
#define PGM_kana_NU 0x4c7
#define PGM_kana_NE 0x4c8
#define PGM_kana_NO 0x4c9
#define PGM_kana_HA 0x4ca
#define PGM_kana_HI 0x4cb
#define PGM_kana_FU 0x4cc
#define PGM_kana_HU 0x4cc
#define PGM_kana_HE 0x4cd
#define PGM_kana_HO 0x4ce
#define PGM_kana_MA 0x4cf
#define PGM_kana_MI 0x4d0
#define PGM_kana_MU 0x4d1
#define PGM_kana_ME 0x4d2
#define PGM_kana_MO 0x4d3
#define PGM_kana_YA 0x4d4
#define PGM_kana_YU 0x4d5
#define PGM_kana_YO 0x4d6
#define PGM_kana_RA 0x4d7
#define PGM_kana_RI 0x4d8
#define PGM_kana_RU 0x4d9
#define PGM_kana_RE 0x4da
#define PGM_kana_RO 0x4db
#define PGM_kana_WA 0x4dc
#define PGM_kana_N 0x4dd
#define PGM_voicedsound 0x4de
#define PGM_semivoicedsound 0x4df
#define PGM_kana_switch 0xff7e
#define PGM_Farsi_0 0x10006f0
#define PGM_Farsi_1 0x10006f1
#define PGM_Farsi_2 0x10006f2
#define PGM_Farsi_3 0x10006f3
#define PGM_Farsi_4 0x10006f4
#define PGM_Farsi_5 0x10006f5
#define PGM_Farsi_6 0x10006f6
#define PGM_Farsi_7 0x10006f7
#define PGM_Farsi_8 0x10006f8
#define PGM_Farsi_9 0x10006f9
#define PGM_Arabic_percent 0x100066a
#define PGM_Arabic_superscript_alef 0x1000670
#define PGM_Arabic_tteh 0x1000679
#define PGM_Arabic_peh 0x100067e
#define PGM_Arabic_tcheh 0x1000686
#define PGM_Arabic_ddal 0x1000688
#define PGM_Arabic_rreh 0x1000691
#define PGM_Arabic_comma 0x5ac
#define PGM_Arabic_fullstop 0x10006d4
#define PGM_Arabic_0 0x1000660
#define PGM_Arabic_1 0x1000661
#define PGM_Arabic_2 0x1000662
#define PGM_Arabic_3 0x1000663
#define PGM_Arabic_4 0x1000664
#define PGM_Arabic_5 0x1000665
#define PGM_Arabic_6 0x1000666
#define PGM_Arabic_7 0x1000667
#define PGM_Arabic_8 0x1000668
#define PGM_Arabic_9 0x1000669
#define PGM_Arabic_semicolon 0x5bb
#define PGM_Arabic_question_mark 0x5bf
#define PGM_Arabic_hamza 0x5c1
#define PGM_Arabic_maddaonalef 0x5c2
#define PGM_Arabic_hamzaonalef 0x5c3
#define PGM_Arabic_hamzaonwaw 0x5c4
#define PGM_Arabic_hamzaunderalef 0x5c5
#define PGM_Arabic_hamzaonyeh 0x5c6
#define PGM_Arabic_alef 0x5c7
#define PGM_Arabic_beh 0x5c8
#define PGM_Arabic_tehmarbuta 0x5c9
#define PGM_Arabic_teh 0x5ca
#define PGM_Arabic_theh 0x5cb
#define PGM_Arabic_jeem 0x5cc
#define PGM_Arabic_hah 0x5cd
#define PGM_Arabic_khah 0x5ce
#define PGM_Arabic_dal 0x5cf
#define PGM_Arabic_thal 0x5d0
#define PGM_Arabic_ra 0x5d1
#define PGM_Arabic_zain 0x5d2
#define PGM_Arabic_seen 0x5d3
#define PGM_Arabic_sheen 0x5d4
#define PGM_Arabic_sad 0x5d5
#define PGM_Arabic_dad 0x5d6
#define PGM_Arabic_tah 0x5d7
#define PGM_Arabic_zah 0x5d8
#define PGM_Arabic_ain 0x5d9
#define PGM_Arabic_ghain 0x5da
#define PGM_Arabic_tatweel 0x5e0
#define PGM_Arabic_feh 0x5e1
#define PGM_Arabic_qaf 0x5e2
#define PGM_Arabic_kaf 0x5e3
#define PGM_Arabic_lam 0x5e4
#define PGM_Arabic_meem 0x5e5
#define PGM_Arabic_noon 0x5e6
#define PGM_Arabic_ha 0x5e7
#define PGM_Arabic_heh 0x5e7
#define PGM_Arabic_waw 0x5e8
#define PGM_Arabic_alefmaksura 0x5e9
#define PGM_Arabic_yeh 0x5ea
#define PGM_Arabic_fathatan 0x5eb
#define PGM_Arabic_dammatan 0x5ec
#define PGM_Arabic_kasratan 0x5ed
#define PGM_Arabic_fatha 0x5ee
#define PGM_Arabic_damma 0x5ef
#define PGM_Arabic_kasra 0x5f0
#define PGM_Arabic_shadda 0x5f1
#define PGM_Arabic_sukun 0x5f2
#define PGM_Arabic_madda_above 0x1000653
#define PGM_Arabic_hamza_above 0x1000654
#define PGM_Arabic_hamza_below 0x1000655
#define PGM_Arabic_jeh 0x1000698
#define PGM_Arabic_veh 0x10006a4
#define PGM_Arabic_keheh 0x10006a9
#define PGM_Arabic_gaf 0x10006af
#define PGM_Arabic_noon_ghunna 0x10006ba
#define PGM_Arabic_heh_doachashmee 0x10006be
#define PGM_Farsi_yeh 0x10006cc
#define PGM_Arabic_farsi_yeh 0x10006cc
#define PGM_Arabic_yeh_baree 0x10006d2
#define PGM_Arabic_heh_goal 0x10006c1
#define PGM_Arabic_switch 0xff7e
#define PGM_Cyrillic_GHE_bar 0x1000492
#define PGM_Cyrillic_ghe_bar 0x1000493
#define PGM_Cyrillic_ZHE_descender 0x1000496
#define PGM_Cyrillic_zhe_descender 0x1000497
#define PGM_Cyrillic_KA_descender 0x100049a
#define PGM_Cyrillic_ka_descender 0x100049b
#define PGM_Cyrillic_KA_vertstroke 0x100049c
#define PGM_Cyrillic_ka_vertstroke 0x100049d
#define PGM_Cyrillic_EN_descender 0x10004a2
#define PGM_Cyrillic_en_descender 0x10004a3
#define PGM_Cyrillic_U_straight 0x10004ae
#define PGM_Cyrillic_u_straight 0x10004af
#define PGM_Cyrillic_U_straight_bar 0x10004b0
#define PGM_Cyrillic_u_straight_bar 0x10004b1
#define PGM_Cyrillic_HA_descender 0x10004b2
#define PGM_Cyrillic_ha_descender 0x10004b3
#define PGM_Cyrillic_CHE_descender 0x10004b6
#define PGM_Cyrillic_che_descender 0x10004b7
#define PGM_Cyrillic_CHE_vertstroke 0x10004b8
#define PGM_Cyrillic_che_vertstroke 0x10004b9
#define PGM_Cyrillic_SHHA 0x10004ba
#define PGM_Cyrillic_shha 0x10004bb
#define PGM_Cyrillic_SCHWA 0x10004d8
#define PGM_Cyrillic_schwa 0x10004d9
#define PGM_Cyrillic_I_macron 0x10004e2
#define PGM_Cyrillic_i_macron 0x10004e3
#define PGM_Cyrillic_O_bar 0x10004e8
#define PGM_Cyrillic_o_bar 0x10004e9
#define PGM_Cyrillic_U_macron 0x10004ee
#define PGM_Cyrillic_u_macron 0x10004ef
#define PGM_Serbian_dje 0x6a1
#define PGM_Macedonia_gje 0x6a2
#define PGM_Cyrillic_io 0x6a3
#define PGM_Ukrainian_ie 0x6a4
#define PGM_Ukranian_je 0x6a4
#define PGM_Macedonia_dse 0x6a5
#define PGM_Ukrainian_i 0x6a6
#define PGM_Ukranian_i 0x6a6
#define PGM_Ukrainian_yi 0x6a7
#define PGM_Ukranian_yi 0x6a7
#define PGM_Cyrillic_je 0x6a8
#define PGM_Serbian_je 0x6a8
#define PGM_Cyrillic_lje 0x6a9
#define PGM_Serbian_lje 0x6a9
#define PGM_Cyrillic_nje 0x6aa
#define PGM_Serbian_nje 0x6aa
#define PGM_Serbian_tshe 0x6ab
#define PGM_Macedonia_kje 0x6ac
#define PGM_Ukrainian_ghe_with_upturn 0x6ad
#define PGM_Byelorussian_shortu 0x6ae
#define PGM_Cyrillic_dzhe 0x6af
#define PGM_Serbian_dze 0x6af
#define PGM_numerosign 0x6b0
#define PGM_Serbian_DJE 0x6b1
#define PGM_Macedonia_GJE 0x6b2
#define PGM_Cyrillic_IO 0x6b3
#define PGM_Ukrainian_IE 0x6b4
#define PGM_Ukranian_JE 0x6b4
#define PGM_Macedonia_DSE 0x6b5
#define PGM_Ukrainian_I 0x6b6
#define PGM_Ukranian_I 0x6b6
#define PGM_Ukrainian_YI 0x6b7
#define PGM_Ukranian_YI 0x6b7
#define PGM_Cyrillic_JE 0x6b8
#define PGM_Serbian_JE 0x6b8
#define PGM_Cyrillic_LJE 0x6b9
#define PGM_Serbian_LJE 0x6b9
#define PGM_Cyrillic_NJE 0x6ba
#define PGM_Serbian_NJE 0x6ba
#define PGM_Serbian_TSHE 0x6bb
#define PGM_Macedonia_KJE 0x6bc
#define PGM_Ukrainian_GHE_WITH_UPTURN 0x6bd
#define PGM_Byelorussian_SHORTU 0x6be
#define PGM_Cyrillic_DZHE 0x6bf
#define PGM_Serbian_DZE 0x6bf
#define PGM_Cyrillic_yu 0x6c0
#define PGM_Cyrillic_a 0x6c1
#define PGM_Cyrillic_be 0x6c2
#define PGM_Cyrillic_tse 0x6c3
#define PGM_Cyrillic_de 0x6c4
#define PGM_Cyrillic_ie 0x6c5
#define PGM_Cyrillic_ef 0x6c6
#define PGM_Cyrillic_ghe 0x6c7
#define PGM_Cyrillic_ha 0x6c8
#define PGM_Cyrillic_i 0x6c9
#define PGM_Cyrillic_shorti 0x6ca
#define PGM_Cyrillic_ka 0x6cb
#define PGM_Cyrillic_el 0x6cc
#define PGM_Cyrillic_em 0x6cd
#define PGM_Cyrillic_en 0x6ce
#define PGM_Cyrillic_o 0x6cf
#define PGM_Cyrillic_pe 0x6d0
#define PGM_Cyrillic_ya 0x6d1
#define PGM_Cyrillic_er 0x6d2
#define PGM_Cyrillic_es 0x6d3
#define PGM_Cyrillic_te 0x6d4
#define PGM_Cyrillic_u 0x6d5
#define PGM_Cyrillic_zhe 0x6d6
#define PGM_Cyrillic_ve 0x6d7
#define PGM_Cyrillic_softsign 0x6d8
#define PGM_Cyrillic_yeru 0x6d9
#define PGM_Cyrillic_ze 0x6da
#define PGM_Cyrillic_sha 0x6db
#define PGM_Cyrillic_e 0x6dc
#define PGM_Cyrillic_shcha 0x6dd
#define PGM_Cyrillic_che 0x6de
#define PGM_Cyrillic_hardsign 0x6df
#define PGM_Cyrillic_YU 0x6e0
#define PGM_Cyrillic_A 0x6e1
#define PGM_Cyrillic_BE 0x6e2
#define PGM_Cyrillic_TSE 0x6e3
#define PGM_Cyrillic_DE 0x6e4
#define PGM_Cyrillic_IE 0x6e5
#define PGM_Cyrillic_EF 0x6e6
#define PGM_Cyrillic_GHE 0x6e7
#define PGM_Cyrillic_HA 0x6e8
#define PGM_Cyrillic_I 0x6e9
#define PGM_Cyrillic_SHORTI 0x6ea
#define PGM_Cyrillic_KA 0x6eb
#define PGM_Cyrillic_EL 0x6ec
#define PGM_Cyrillic_EM 0x6ed
#define PGM_Cyrillic_EN 0x6ee
#define PGM_Cyrillic_O 0x6ef
#define PGM_Cyrillic_PE 0x6f0
#define PGM_Cyrillic_YA 0x6f1
#define PGM_Cyrillic_ER 0x6f2
#define PGM_Cyrillic_ES 0x6f3
#define PGM_Cyrillic_TE 0x6f4
#define PGM_Cyrillic_U 0x6f5
#define PGM_Cyrillic_ZHE 0x6f6
#define PGM_Cyrillic_VE 0x6f7
#define PGM_Cyrillic_SOFTSIGN 0x6f8
#define PGM_Cyrillic_YERU 0x6f9
#define PGM_Cyrillic_ZE 0x6fa
#define PGM_Cyrillic_SHA 0x6fb
#define PGM_Cyrillic_E 0x6fc
#define PGM_Cyrillic_SHCHA 0x6fd
#define PGM_Cyrillic_CHE 0x6fe
#define PGM_Cyrillic_HARDSIGN 0x6ff
#define PGM_Greek_ALPHAaccent 0x7a1
#define PGM_Greek_EPSILONaccent 0x7a2
#define PGM_Greek_ETAaccent 0x7a3
#define PGM_Greek_IOTAaccent 0x7a4
#define PGM_Greek_IOTAdieresis 0x7a5
#define PGM_Greek_IOTAdiaeresis 0x7a5
#define PGM_Greek_OMICRONaccent 0x7a7
#define PGM_Greek_UPSILONaccent 0x7a8
#define PGM_Greek_UPSILONdieresis 0x7a9
#define PGM_Greek_OMEGAaccent 0x7ab
#define PGM_Greek_accentdieresis 0x7ae
#define PGM_Greek_horizbar 0x7af
#define PGM_Greek_alphaaccent 0x7b1
#define PGM_Greek_epsilonaccent 0x7b2
#define PGM_Greek_etaaccent 0x7b3
#define PGM_Greek_iotaaccent 0x7b4
#define PGM_Greek_iotadieresis 0x7b5
#define PGM_Greek_iotaaccentdieresis 0x7b6
#define PGM_Greek_omicronaccent 0x7b7
#define PGM_Greek_upsilonaccent 0x7b8
#define PGM_Greek_upsilondieresis 0x7b9
#define PGM_Greek_upsilonaccentdieresis 0x7ba
#define PGM_Greek_omegaaccent 0x7bb
#define PGM_Greek_ALPHA 0x7c1
#define PGM_Greek_BETA 0x7c2
#define PGM_Greek_GAMMA 0x7c3
#define PGM_Greek_DELTA 0x7c4
#define PGM_Greek_EPSILON 0x7c5
#define PGM_Greek_ZETA 0x7c6
#define PGM_Greek_ETA 0x7c7
#define PGM_Greek_THETA 0x7c8
#define PGM_Greek_IOTA 0x7c9
#define PGM_Greek_KAPPA 0x7ca
#define PGM_Greek_LAMDA 0x7cb
#define PGM_Greek_LAMBDA 0x7cb
#define PGM_Greek_MU 0x7cc
#define PGM_Greek_NU 0x7cd
#define PGM_Greek_XI 0x7ce
#define PGM_Greek_OMICRON 0x7cf
#define PGM_Greek_PI 0x7d0
#define PGM_Greek_RHO 0x7d1
#define PGM_Greek_SIGMA 0x7d2
#define PGM_Greek_TAU 0x7d4
#define PGM_Greek_UPSILON 0x7d5
#define PGM_Greek_PHI 0x7d6
#define PGM_Greek_CHI 0x7d7
#define PGM_Greek_PSI 0x7d8
#define PGM_Greek_OMEGA 0x7d9
#define PGM_Greek_alpha 0x7e1
#define PGM_Greek_beta 0x7e2
#define PGM_Greek_gamma 0x7e3
#define PGM_Greek_delta 0x7e4
#define PGM_Greek_epsilon 0x7e5
#define PGM_Greek_zeta 0x7e6
#define PGM_Greek_eta 0x7e7
#define PGM_Greek_theta 0x7e8
#define PGM_Greek_iota 0x7e9
#define PGM_Greek_kappa 0x7ea
#define PGM_Greek_lamda 0x7eb
#define PGM_Greek_lambda 0x7eb
#define PGM_Greek_mu 0x7ec
#define PGM_Greek_nu 0x7ed
#define PGM_Greek_xi 0x7ee
#define PGM_Greek_omicron 0x7ef
#define PGM_Greek_pi 0x7f0
#define PGM_Greek_rho 0x7f1
#define PGM_Greek_sigma 0x7f2
#define PGM_Greek_finalsmallsigma 0x7f3
#define PGM_Greek_tau 0x7f4
#define PGM_Greek_upsilon 0x7f5
#define PGM_Greek_phi 0x7f6
#define PGM_Greek_chi 0x7f7
#define PGM_Greek_psi 0x7f8
#define PGM_Greek_omega 0x7f9
#define PGM_Greek_switch 0xff7e
#define PGM_leftradical 0x8a1
#define PGM_topleftradical 0x8a2
#define PGM_horizconnector 0x8a3
#define PGM_topintegral 0x8a4
#define PGM_botintegral 0x8a5
#define PGM_vertconnector 0x8a6
#define PGM_topleftsqbracket 0x8a7
#define PGM_botleftsqbracket 0x8a8
#define PGM_toprightsqbracket 0x8a9
#define PGM_botrightsqbracket 0x8aa
#define PGM_topleftparens 0x8ab
#define PGM_botleftparens 0x8ac
#define PGM_toprightparens 0x8ad
#define PGM_botrightparens 0x8ae
#define PGM_leftmiddlecurlybrace 0x8af
#define PGM_rightmiddlecurlybrace 0x8b0
#define PGM_topleftsummation 0x8b1
#define PGM_botleftsummation 0x8b2
#define PGM_topvertsummationconnector 0x8b3
#define PGM_botvertsummationconnector 0x8b4
#define PGM_toprightsummation 0x8b5
#define PGM_botrightsummation 0x8b6
#define PGM_rightmiddlesummation 0x8b7
#define PGM_lessthanequal 0x8bc
#define PGM_notequal 0x8bd
#define PGM_greaterthanequal 0x8be
#define PGM_integral 0x8bf
#define PGM_therefore 0x8c0
#define PGM_variation 0x8c1
#define PGM_infinity 0x8c2
#define PGM_nabla 0x8c5
#define PGM_approximate 0x8c8
#define PGM_similarequal 0x8c9
#define PGM_ifonlyif 0x8cd
#define PGM_implies 0x8ce
#define PGM_identical 0x8cf
#define PGM_radical 0x8d6
#define PGM_includedin 0x8da
#define PGM_includes 0x8db
#define PGM_intersection 0x8dc
#define PGM_union 0x8dd
#define PGM_logicaland 0x8de
#define PGM_logicalor 0x8df
#define PGM_partialderivative 0x8ef
#define PGM_function 0x8f6
#define PGM_leftarrow 0x8fb
#define PGM_uparrow 0x8fc
#define PGM_rightarrow 0x8fd
#define PGM_downarrow 0x8fe
#define PGM_blank 0x9df
#define PGM_soliddiamond 0x9e0
#define PGM_checkerboard 0x9e1
#define PGM_ht 0x9e2
#define PGM_ff 0x9e3
#define PGM_cr 0x9e4
#define PGM_lf 0x9e5
#define PGM_nl 0x9e8
#define PGM_vt 0x9e9
#define PGM_lowrightcorner 0x9ea
#define PGM_uprightcorner 0x9eb
#define PGM_upleftcorner 0x9ec
#define PGM_lowleftcorner 0x9ed
#define PGM_crossinglines 0x9ee
#define PGM_horizlinescan1 0x9ef
#define PGM_horizlinescan3 0x9f0
#define PGM_horizlinescan5 0x9f1
#define PGM_horizlinescan7 0x9f2
#define PGM_horizlinescan9 0x9f3
#define PGM_leftt 0x9f4
#define PGM_rightt 0x9f5
#define PGM_bott 0x9f6
#define PGM_topt 0x9f7
#define PGM_vertbar 0x9f8
#define PGM_emspace 0xaa1
#define PGM_enspace 0xaa2
#define PGM_em3space 0xaa3
#define PGM_em4space 0xaa4
#define PGM_digitspace 0xaa5
#define PGM_punctspace 0xaa6
#define PGM_thinspace 0xaa7
#define PGM_hairspace 0xaa8
#define PGM_emdash 0xaa9
#define PGM_endash 0xaaa
#define PGM_signifblank 0xaac
#define PGM_ellipsis 0xaae
#define PGM_doubbaselinedot 0xaaf
#define PGM_onethird 0xab0
#define PGM_twothirds 0xab1
#define PGM_onefifth 0xab2
#define PGM_twofifths 0xab3
#define PGM_threefifths 0xab4
#define PGM_fourfifths 0xab5
#define PGM_onesixth 0xab6
#define PGM_fivesixths 0xab7
#define PGM_careof 0xab8
#define PGM_figdash 0xabb
#define PGM_leftanglebracket 0xabc
#define PGM_decimalpoint 0xabd
#define PGM_rightanglebracket 0xabe
#define PGM_marker 0xabf
#define PGM_oneeighth 0xac3
#define PGM_threeeighths 0xac4
#define PGM_fiveeighths 0xac5
#define PGM_seveneighths 0xac6
#define PGM_trademark 0xac9
#define PGM_signaturemark 0xaca
#define PGM_trademarkincircle 0xacb
#define PGM_leftopentriangle 0xacc
#define PGM_rightopentriangle 0xacd
#define PGM_emopencircle 0xace
#define PGM_emopenrectangle 0xacf
#define PGM_leftsinglequotemark 0xad0
#define PGM_rightsinglequotemark 0xad1
#define PGM_leftdoublequotemark 0xad2
#define PGM_rightdoublequotemark 0xad3
#define PGM_prescription 0xad4
#define PGM_minutes 0xad6
#define PGM_seconds 0xad7
#define PGM_latincross 0xad9
#define PGM_hexagram 0xada
#define PGM_filledrectbullet 0xadb
#define PGM_filledlefttribullet 0xadc
#define PGM_filledrighttribullet 0xadd
#define PGM_emfilledcircle 0xade
#define PGM_emfilledrect 0xadf
#define PGM_enopencircbullet 0xae0
#define PGM_enopensquarebullet 0xae1
#define PGM_openrectbullet 0xae2
#define PGM_opentribulletup 0xae3
#define PGM_opentribulletdown 0xae4
#define PGM_openstar 0xae5
#define PGM_enfilledcircbullet 0xae6
#define PGM_enfilledsqbullet 0xae7
#define PGM_filledtribulletup 0xae8
#define PGM_filledtribulletdown 0xae9
#define PGM_leftpointer 0xaea
#define PGM_rightpointer 0xaeb
#define PGM_club 0xaec
#define PGM_diamond 0xaed
#define PGM_heart 0xaee
#define PGM_maltesecross 0xaf0
#define PGM_dagger 0xaf1
#define PGM_doubledagger 0xaf2
#define PGM_checkmark 0xaf3
#define PGM_ballotcross 0xaf4
#define PGM_musicalsharp 0xaf5
#define PGM_musicalflat 0xaf6
#define PGM_malesymbol 0xaf7
#define PGM_femalesymbol 0xaf8
#define PGM_telephone 0xaf9
#define PGM_telephonerecorder 0xafa
#define PGM_phonographcopyright 0xafb
#define PGM_caret 0xafc
#define PGM_singlelowquotemark 0xafd
#define PGM_doublelowquotemark 0xafe
#define PGM_cursor 0xaff
#define PGM_leftcaret 0xba3
#define PGM_rightcaret 0xba6
#define PGM_downcaret 0xba8
#define PGM_upcaret 0xba9
#define PGM_overbar 0xbc0
#define PGM_downtack 0xbc2
#define PGM_upshoe 0xbc3
#define PGM_downstile 0xbc4
#define PGM_underbar 0xbc6
#define PGM_jot 0xbca
#define PGM_quad 0xbcc
#define PGM_uptack 0xbce
#define PGM_circle 0xbcf
#define PGM_upstile 0xbd3
#define PGM_downshoe 0xbd6
#define PGM_rightshoe 0xbd8
#define PGM_leftshoe 0xbda
#define PGM_lefttack 0xbdc
#define PGM_righttack 0xbfc
#define PGM_hebrew_doublelowline 0xcdf
#define PGM_hebrew_aleph 0xce0
#define PGM_hebrew_bet 0xce1
#define PGM_hebrew_beth 0xce1
#define PGM_hebrew_gimel 0xce2
#define PGM_hebrew_gimmel 0xce2
#define PGM_hebrew_dalet 0xce3
#define PGM_hebrew_daleth 0xce3
#define PGM_hebrew_he 0xce4
#define PGM_hebrew_waw 0xce5
#define PGM_hebrew_zain 0xce6
#define PGM_hebrew_zayin 0xce6
#define PGM_hebrew_chet 0xce7
#define PGM_hebrew_het 0xce7
#define PGM_hebrew_tet 0xce8
#define PGM_hebrew_teth 0xce8
#define PGM_hebrew_yod 0xce9
#define PGM_hebrew_finalkaph 0xcea
#define PGM_hebrew_kaph 0xceb
#define PGM_hebrew_lamed 0xcec
#define PGM_hebrew_finalmem 0xced
#define PGM_hebrew_mem 0xcee
#define PGM_hebrew_finalnun 0xcef
#define PGM_hebrew_nun 0xcf0
#define PGM_hebrew_samech 0xcf1
#define PGM_hebrew_samekh 0xcf1
#define PGM_hebrew_ayin 0xcf2
#define PGM_hebrew_finalpe 0xcf3
#define PGM_hebrew_pe 0xcf4
#define PGM_hebrew_finalzade 0xcf5
#define PGM_hebrew_finalzadi 0xcf5
#define PGM_hebrew_zade 0xcf6
#define PGM_hebrew_zadi 0xcf6
#define PGM_hebrew_qoph 0xcf7
#define PGM_hebrew_kuf 0xcf7
#define PGM_hebrew_resh 0xcf8
#define PGM_hebrew_shin 0xcf9
#define PGM_hebrew_taw 0xcfa
#define PGM_hebrew_taf 0xcfa
#define PGM_Hebrew_switch 0xff7e
#define PGM_Thai_kokai 0xda1
#define PGM_Thai_khokhai 0xda2
#define PGM_Thai_khokhuat 0xda3
#define PGM_Thai_khokhwai 0xda4
#define PGM_Thai_khokhon 0xda5
#define PGM_Thai_khorakhang 0xda6
#define PGM_Thai_ngongu 0xda7
#define PGM_Thai_chochan 0xda8
#define PGM_Thai_choching 0xda9
#define PGM_Thai_chochang 0xdaa
#define PGM_Thai_soso 0xdab
#define PGM_Thai_chochoe 0xdac
#define PGM_Thai_yoying 0xdad
#define PGM_Thai_dochada 0xdae
#define PGM_Thai_topatak 0xdaf
#define PGM_Thai_thothan 0xdb0
#define PGM_Thai_thonangmontho 0xdb1
#define PGM_Thai_thophuthao 0xdb2
#define PGM_Thai_nonen 0xdb3
#define PGM_Thai_dodek 0xdb4
#define PGM_Thai_totao 0xdb5
#define PGM_Thai_thothung 0xdb6
#define PGM_Thai_thothahan 0xdb7
#define PGM_Thai_thothong 0xdb8
#define PGM_Thai_nonu 0xdb9
#define PGM_Thai_bobaimai 0xdba
#define PGM_Thai_popla 0xdbb
#define PGM_Thai_phophung 0xdbc
#define PGM_Thai_fofa 0xdbd
#define PGM_Thai_phophan 0xdbe
#define PGM_Thai_fofan 0xdbf
#define PGM_Thai_phosamphao 0xdc0
#define PGM_Thai_moma 0xdc1
#define PGM_Thai_yoyak 0xdc2
#define PGM_Thai_rorua 0xdc3
#define PGM_Thai_ru 0xdc4
#define PGM_Thai_loling 0xdc5
#define PGM_Thai_lu 0xdc6
#define PGM_Thai_wowaen 0xdc7
#define PGM_Thai_sosala 0xdc8
#define PGM_Thai_sorusi 0xdc9
#define PGM_Thai_sosua 0xdca
#define PGM_Thai_hohip 0xdcb
#define PGM_Thai_lochula 0xdcc
#define PGM_Thai_oang 0xdcd
#define PGM_Thai_honokhuk 0xdce
#define PGM_Thai_paiyannoi 0xdcf
#define PGM_Thai_saraa 0xdd0
#define PGM_Thai_maihanakat 0xdd1
#define PGM_Thai_saraaa 0xdd2
#define PGM_Thai_saraam 0xdd3
#define PGM_Thai_sarai 0xdd4
#define PGM_Thai_saraii 0xdd5
#define PGM_Thai_saraue 0xdd6
#define PGM_Thai_sarauee 0xdd7
#define PGM_Thai_sarau 0xdd8
#define PGM_Thai_sarauu 0xdd9
#define PGM_Thai_phinthu 0xdda
#define PGM_Thai_maihanakat_maitho 0xdde
#define PGM_Thai_baht 0xddf
#define PGM_Thai_sarae 0xde0
#define PGM_Thai_saraae 0xde1
#define PGM_Thai_sarao 0xde2
#define PGM_Thai_saraaimaimuan 0xde3
#define PGM_Thai_saraaimaimalai 0xde4
#define PGM_Thai_lakkhangyao 0xde5
#define PGM_Thai_maiyamok 0xde6
#define PGM_Thai_maitaikhu 0xde7
#define PGM_Thai_maiek 0xde8
#define PGM_Thai_maitho 0xde9
#define PGM_Thai_maitri 0xdea
#define PGM_Thai_maichattawa 0xdeb
#define PGM_Thai_thanthakhat 0xdec
#define PGM_Thai_nikhahit 0xded
#define PGM_Thai_leksun 0xdf0
#define PGM_Thai_leknung 0xdf1
#define PGM_Thai_leksong 0xdf2
#define PGM_Thai_leksam 0xdf3
#define PGM_Thai_leksi 0xdf4
#define PGM_Thai_lekha 0xdf5
#define PGM_Thai_lekhok 0xdf6
#define PGM_Thai_lekchet 0xdf7
#define PGM_Thai_lekpaet 0xdf8
#define PGM_Thai_lekkao 0xdf9
#define PGM_Hangul 0xff31
#define PGM_Hangul_Start 0xff32
#define PGM_Hangul_End 0xff33
#define PGM_Hangul_Hanja 0xff34
#define PGM_Hangul_Jamo 0xff35
#define PGM_Hangul_Romaja 0xff36
#define PGM_Hangul_Codeinput 0xff37
#define PGM_Hangul_Jeonja 0xff38
#define PGM_Hangul_Banja 0xff39
#define PGM_Hangul_PreHanja 0xff3a
#define PGM_Hangul_PostHanja 0xff3b
#define PGM_Hangul_SingleCandidate 0xff3c
#define PGM_Hangul_MultipleCandidate 0xff3d
#define PGM_Hangul_PreviousCandidate 0xff3e
#define PGM_Hangul_Special 0xff3f
#define PGM_Hangul_switch 0xff7e
#define PGM_Hangul_Kiyeog 0xea1
#define PGM_Hangul_SsangKiyeog 0xea2
#define PGM_Hangul_KiyeogSios 0xea3
#define PGM_Hangul_Nieun 0xea4
#define PGM_Hangul_NieunJieuj 0xea5
#define PGM_Hangul_NieunHieuh 0xea6
#define PGM_Hangul_Dikeud 0xea7
#define PGM_Hangul_SsangDikeud 0xea8
#define PGM_Hangul_Rieul 0xea9
#define PGM_Hangul_RieulKiyeog 0xeaa
#define PGM_Hangul_RieulMieum 0xeab
#define PGM_Hangul_RieulPieub 0xeac
#define PGM_Hangul_RieulSios 0xead
#define PGM_Hangul_RieulTieut 0xeae
#define PGM_Hangul_RieulPhieuf 0xeaf
#define PGM_Hangul_RieulHieuh 0xeb0
#define PGM_Hangul_Mieum 0xeb1
#define PGM_Hangul_Pieub 0xeb2
#define PGM_Hangul_SsangPieub 0xeb3
#define PGM_Hangul_PieubSios 0xeb4
#define PGM_Hangul_Sios 0xeb5
#define PGM_Hangul_SsangSios 0xeb6
#define PGM_Hangul_Ieung 0xeb7
#define PGM_Hangul_Jieuj 0xeb8
#define PGM_Hangul_SsangJieuj 0xeb9
#define PGM_Hangul_Cieuc 0xeba
#define PGM_Hangul_Khieuq 0xebb
#define PGM_Hangul_Tieut 0xebc
#define PGM_Hangul_Phieuf 0xebd
#define PGM_Hangul_Hieuh 0xebe
#define PGM_Hangul_A 0xebf
#define PGM_Hangul_AE 0xec0
#define PGM_Hangul_YA 0xec1
#define PGM_Hangul_YAE 0xec2
#define PGM_Hangul_EO 0xec3
#define PGM_Hangul_E 0xec4
#define PGM_Hangul_YEO 0xec5
#define PGM_Hangul_YE 0xec6
#define PGM_Hangul_O 0xec7
#define PGM_Hangul_WA 0xec8
#define PGM_Hangul_WAE 0xec9
#define PGM_Hangul_OE 0xeca
#define PGM_Hangul_YO 0xecb
#define PGM_Hangul_U 0xecc
#define PGM_Hangul_WEO 0xecd
#define PGM_Hangul_WE 0xece
#define PGM_Hangul_WI 0xecf
#define PGM_Hangul_YU 0xed0
#define PGM_Hangul_EU 0xed1
#define PGM_Hangul_YI 0xed2
#define PGM_Hangul_I 0xed3
#define PGM_Hangul_J_Kiyeog 0xed4
#define PGM_Hangul_J_SsangKiyeog 0xed5
#define PGM_Hangul_J_KiyeogSios 0xed6
#define PGM_Hangul_J_Nieun 0xed7
#define PGM_Hangul_J_NieunJieuj 0xed8
#define PGM_Hangul_J_NieunHieuh 0xed9
#define PGM_Hangul_J_Dikeud 0xeda
#define PGM_Hangul_J_Rieul 0xedb
#define PGM_Hangul_J_RieulKiyeog 0xedc
#define PGM_Hangul_J_RieulMieum 0xedd
#define PGM_Hangul_J_RieulPieub 0xede
#define PGM_Hangul_J_RieulSios 0xedf
#define PGM_Hangul_J_RieulTieut 0xee0
#define PGM_Hangul_J_RieulPhieuf 0xee1
#define PGM_Hangul_J_RieulHieuh 0xee2
#define PGM_Hangul_J_Mieum 0xee3
#define PGM_Hangul_J_Pieub 0xee4
#define PGM_Hangul_J_PieubSios 0xee5
#define PGM_Hangul_J_Sios 0xee6
#define PGM_Hangul_J_SsangSios 0xee7
#define PGM_Hangul_J_Ieung 0xee8
#define PGM_Hangul_J_Jieuj 0xee9
#define PGM_Hangul_J_Cieuc 0xeea
#define PGM_Hangul_J_Khieuq 0xeeb
#define PGM_Hangul_J_Tieut 0xeec
#define PGM_Hangul_J_Phieuf 0xeed
#define PGM_Hangul_J_Hieuh 0xeee
#define PGM_Hangul_RieulYeorinHieuh 0xeef
#define PGM_Hangul_SunkyeongeumMieum 0xef0
#define PGM_Hangul_SunkyeongeumPieub 0xef1
#define PGM_Hangul_PanSios 0xef2
#define PGM_Hangul_KkogjiDalrinIeung 0xef3
#define PGM_Hangul_SunkyeongeumPhieuf 0xef4
#define PGM_Hangul_YeorinHieuh 0xef5
#define PGM_Hangul_AraeA 0xef6
#define PGM_Hangul_AraeAE 0xef7
#define PGM_Hangul_J_PanSios 0xef8
#define PGM_Hangul_J_KkogjiDalrinIeung 0xef9
#define PGM_Hangul_J_YeorinHieuh 0xefa
#define PGM_Korean_Won 0xeff
#define PGM_Armenian_ligature_ew 0x1000587
#define PGM_Armenian_full_stop 0x1000589
#define PGM_Armenian_verjaket 0x1000589
#define PGM_Armenian_separation_mark 0x100055d
#define PGM_Armenian_but 0x100055d
#define PGM_Armenian_hyphen 0x100058a
#define PGM_Armenian_yentamna 0x100058a
#define PGM_Armenian_exclam 0x100055c
#define PGM_Armenian_amanak 0x100055c
#define PGM_Armenian_accent 0x100055b
#define PGM_Armenian_shesht 0x100055b
#define PGM_Armenian_question 0x100055e
#define PGM_Armenian_paruyk 0x100055e
#define PGM_Armenian_AYB 0x1000531
#define PGM_Armenian_ayb 0x1000561
#define PGM_Armenian_BEN 0x1000532
#define PGM_Armenian_ben 0x1000562
#define PGM_Armenian_GIM 0x1000533
#define PGM_Armenian_gim 0x1000563
#define PGM_Armenian_DA 0x1000534
#define PGM_Armenian_da 0x1000564
#define PGM_Armenian_YECH 0x1000535
#define PGM_Armenian_yech 0x1000565
#define PGM_Armenian_ZA 0x1000536
#define PGM_Armenian_za 0x1000566
#define PGM_Armenian_E 0x1000537
#define PGM_Armenian_e 0x1000567
#define PGM_Armenian_AT 0x1000538
#define PGM_Armenian_at 0x1000568
#define PGM_Armenian_TO 0x1000539
#define PGM_Armenian_to 0x1000569
#define PGM_Armenian_ZHE 0x100053a
#define PGM_Armenian_zhe 0x100056a
#define PGM_Armenian_INI 0x100053b
#define PGM_Armenian_ini 0x100056b
#define PGM_Armenian_LYUN 0x100053c
#define PGM_Armenian_lyun 0x100056c
#define PGM_Armenian_KHE 0x100053d
#define PGM_Armenian_khe 0x100056d
#define PGM_Armenian_TSA 0x100053e
#define PGM_Armenian_tsa 0x100056e
#define PGM_Armenian_KEN 0x100053f
#define PGM_Armenian_ken 0x100056f
#define PGM_Armenian_HO 0x1000540
#define PGM_Armenian_ho 0x1000570
#define PGM_Armenian_DZA 0x1000541
#define PGM_Armenian_dza 0x1000571
#define PGM_Armenian_GHAT 0x1000542
#define PGM_Armenian_ghat 0x1000572
#define PGM_Armenian_TCHE 0x1000543
#define PGM_Armenian_tche 0x1000573
#define PGM_Armenian_MEN 0x1000544
#define PGM_Armenian_men 0x1000574
#define PGM_Armenian_HI 0x1000545
#define PGM_Armenian_hi 0x1000575
#define PGM_Armenian_NU 0x1000546
#define PGM_Armenian_nu 0x1000576
#define PGM_Armenian_SHA 0x1000547
#define PGM_Armenian_sha 0x1000577
#define PGM_Armenian_VO 0x1000548
#define PGM_Armenian_vo 0x1000578
#define PGM_Armenian_CHA 0x1000549
#define PGM_Armenian_cha 0x1000579
#define PGM_Armenian_PE 0x100054a
#define PGM_Armenian_pe 0x100057a
#define PGM_Armenian_JE 0x100054b
#define PGM_Armenian_je 0x100057b
#define PGM_Armenian_RA 0x100054c
#define PGM_Armenian_ra 0x100057c
#define PGM_Armenian_SE 0x100054d
#define PGM_Armenian_se 0x100057d
#define PGM_Armenian_VEV 0x100054e
#define PGM_Armenian_vev 0x100057e
#define PGM_Armenian_TYUN 0x100054f
#define PGM_Armenian_tyun 0x100057f
#define PGM_Armenian_RE 0x1000550
#define PGM_Armenian_re 0x1000580
#define PGM_Armenian_TSO 0x1000551
#define PGM_Armenian_tso 0x1000581
#define PGM_Armenian_VYUN 0x1000552
#define PGM_Armenian_vyun 0x1000582
#define PGM_Armenian_PYUR 0x1000553
#define PGM_Armenian_pyur 0x1000583
#define PGM_Armenian_KE 0x1000554
#define PGM_Armenian_ke 0x1000584
#define PGM_Armenian_O 0x1000555
#define PGM_Armenian_o 0x1000585
#define PGM_Armenian_FE 0x1000556
#define PGM_Armenian_fe 0x1000586
#define PGM_Armenian_apostrophe 0x100055a
#define PGM_Georgian_an 0x10010d0
#define PGM_Georgian_ban 0x10010d1
#define PGM_Georgian_gan 0x10010d2
#define PGM_Georgian_don 0x10010d3
#define PGM_Georgian_en 0x10010d4
#define PGM_Georgian_vin 0x10010d5
#define PGM_Georgian_zen 0x10010d6
#define PGM_Georgian_tan 0x10010d7
#define PGM_Georgian_in 0x10010d8
#define PGM_Georgian_kan 0x10010d9
#define PGM_Georgian_las 0x10010da
#define PGM_Georgian_man 0x10010db
#define PGM_Georgian_nar 0x10010dc
#define PGM_Georgian_on 0x10010dd
#define PGM_Georgian_par 0x10010de
#define PGM_Georgian_zhar 0x10010df
#define PGM_Georgian_rae 0x10010e0
#define PGM_Georgian_san 0x10010e1
#define PGM_Georgian_tar 0x10010e2
#define PGM_Georgian_un 0x10010e3
#define PGM_Georgian_phar 0x10010e4
#define PGM_Georgian_khar 0x10010e5
#define PGM_Georgian_ghan 0x10010e6
#define PGM_Georgian_qar 0x10010e7
#define PGM_Georgian_shin 0x10010e8
#define PGM_Georgian_chin 0x10010e9
#define PGM_Georgian_can 0x10010ea
#define PGM_Georgian_jil 0x10010eb
#define PGM_Georgian_cil 0x10010ec
#define PGM_Georgian_char 0x10010ed
#define PGM_Georgian_xan 0x10010ee
#define PGM_Georgian_jhan 0x10010ef
#define PGM_Georgian_hae 0x10010f0
#define PGM_Georgian_he 0x10010f1
#define PGM_Georgian_hie 0x10010f2
#define PGM_Georgian_we 0x10010f3
#define PGM_Georgian_har 0x10010f4
#define PGM_Georgian_hoe 0x10010f5
#define PGM_Georgian_fi 0x10010f6
#define PGM_Xabovedot 0x1001e8a
#define PGM_Ibreve 0x100012c
#define PGM_Zstroke 0x10001b5
#define PGM_Gcaron 0x10001e6
#define PGM_Ocaron 0x10001d1
#define PGM_Obarred 0x100019f
#define PGM_xabovedot 0x1001e8b
#define PGM_ibreve 0x100012d
#define PGM_zstroke 0x10001b6
#define PGM_gcaron 0x10001e7
#define PGM_ocaron 0x10001d2
#define PGM_obarred 0x1000275
#define PGM_SCHWA 0x100018f
#define PGM_schwa 0x1000259
#define PGM_Lbelowdot 0x1001e36
#define PGM_lbelowdot 0x1001e37
#define PGM_Abelowdot 0x1001ea0
#define PGM_abelowdot 0x1001ea1
#define PGM_Ahook 0x1001ea2
#define PGM_ahook 0x1001ea3
#define PGM_Acircumflexacute 0x1001ea4
#define PGM_acircumflexacute 0x1001ea5
#define PGM_Acircumflexgrave 0x1001ea6
#define PGM_acircumflexgrave 0x1001ea7
#define PGM_Acircumflexhook 0x1001ea8
#define PGM_acircumflexhook 0x1001ea9
#define PGM_Acircumflextilde 0x1001eaa
#define PGM_acircumflextilde 0x1001eab
#define PGM_Acircumflexbelowdot 0x1001eac
#define PGM_acircumflexbelowdot 0x1001ead
#define PGM_Abreveacute 0x1001eae
#define PGM_abreveacute 0x1001eaf
#define PGM_Abrevegrave 0x1001eb0
#define PGM_abrevegrave 0x1001eb1
#define PGM_Abrevehook 0x1001eb2
#define PGM_abrevehook 0x1001eb3
#define PGM_Abrevetilde 0x1001eb4
#define PGM_abrevetilde 0x1001eb5
#define PGM_Abrevebelowdot 0x1001eb6
#define PGM_abrevebelowdot 0x1001eb7
#define PGM_Ebelowdot 0x1001eb8
#define PGM_ebelowdot 0x1001eb9
#define PGM_Ehook 0x1001eba
#define PGM_ehook 0x1001ebb
#define PGM_Etilde 0x1001ebc
#define PGM_etilde 0x1001ebd
#define PGM_Ecircumflexacute 0x1001ebe
#define PGM_ecircumflexacute 0x1001ebf
#define PGM_Ecircumflexgrave 0x1001ec0
#define PGM_ecircumflexgrave 0x1001ec1
#define PGM_Ecircumflexhook 0x1001ec2
#define PGM_ecircumflexhook 0x1001ec3
#define PGM_Ecircumflextilde 0x1001ec4
#define PGM_ecircumflextilde 0x1001ec5
#define PGM_Ecircumflexbelowdot 0x1001ec6
#define PGM_ecircumflexbelowdot 0x1001ec7
#define PGM_Ihook 0x1001ec8
#define PGM_ihook 0x1001ec9
#define PGM_Ibelowdot 0x1001eca
#define PGM_ibelowdot 0x1001ecb
#define PGM_Obelowdot 0x1001ecc
#define PGM_obelowdot 0x1001ecd
#define PGM_Ohook 0x1001ece
#define PGM_ohook 0x1001ecf
#define PGM_Ocircumflexacute 0x1001ed0
#define PGM_ocircumflexacute 0x1001ed1
#define PGM_Ocircumflexgrave 0x1001ed2
#define PGM_ocircumflexgrave 0x1001ed3
#define PGM_Ocircumflexhook 0x1001ed4
#define PGM_ocircumflexhook 0x1001ed5
#define PGM_Ocircumflextilde 0x1001ed6
#define PGM_ocircumflextilde 0x1001ed7
#define PGM_Ocircumflexbelowdot 0x1001ed8
#define PGM_ocircumflexbelowdot 0x1001ed9
#define PGM_Ohornacute 0x1001eda
#define PGM_ohornacute 0x1001edb
#define PGM_Ohorngrave 0x1001edc
#define PGM_ohorngrave 0x1001edd
#define PGM_Ohornhook 0x1001ede
#define PGM_ohornhook 0x1001edf
#define PGM_Ohorntilde 0x1001ee0
#define PGM_ohorntilde 0x1001ee1
#define PGM_Ohornbelowdot 0x1001ee2
#define PGM_ohornbelowdot 0x1001ee3
#define PGM_Ubelowdot 0x1001ee4
#define PGM_ubelowdot 0x1001ee5
#define PGM_Uhook 0x1001ee6
#define PGM_uhook 0x1001ee7
#define PGM_Uhornacute 0x1001ee8
#define PGM_uhornacute 0x1001ee9
#define PGM_Uhorngrave 0x1001eea
#define PGM_uhorngrave 0x1001eeb
#define PGM_Uhornhook 0x1001eec
#define PGM_uhornhook 0x1001eed
#define PGM_Uhorntilde 0x1001eee
#define PGM_uhorntilde 0x1001eef
#define PGM_Uhornbelowdot 0x1001ef0
#define PGM_uhornbelowdot 0x1001ef1
#define PGM_Ybelowdot 0x1001ef4
#define PGM_ybelowdot 0x1001ef5
#define PGM_Yhook 0x1001ef6
#define PGM_yhook 0x1001ef7
#define PGM_Ytilde 0x1001ef8
#define PGM_ytilde 0x1001ef9
#define PGM_Ohorn 0x10001a0
#define PGM_ohorn 0x10001a1
#define PGM_Uhorn 0x10001af
#define PGM_uhorn 0x10001b0
#define PGM_EcuSign 0x10020a0
#define PGM_ColonSign 0x10020a1
#define PGM_CruzeiroSign 0x10020a2
#define PGM_FFrancSign 0x10020a3
#define PGM_LiraSign 0x10020a4
#define PGM_MillSign 0x10020a5
#define PGM_NairaSign 0x10020a6
#define PGM_PesetaSign 0x10020a7
#define PGM_RupeeSign 0x10020a8
#define PGM_WonSign 0x10020a9
#define PGM_NewSheqelSign 0x10020aa
#define PGM_DongSign 0x10020ab
#define PGM_EuroSign 0x20ac
#define PGM_zerosuperior 0x1002070
#define PGM_foursuperior 0x1002074
#define PGM_fivesuperior 0x1002075
#define PGM_sixsuperior 0x1002076
#define PGM_sevensuperior 0x1002077
#define PGM_eightsuperior 0x1002078
#define PGM_ninesuperior 0x1002079
#define PGM_zerosubscript 0x1002080
#define PGM_onesubscript 0x1002081
#define PGM_twosubscript 0x1002082
#define PGM_threesubscript 0x1002083
#define PGM_foursubscript 0x1002084
#define PGM_fivesubscript 0x1002085
#define PGM_sixsubscript 0x1002086
#define PGM_sevensubscript 0x1002087
#define PGM_eightsubscript 0x1002088
#define PGM_ninesubscript 0x1002089
#define PGM_partdifferential 0x1002202
#define PGM_emptyset 0x1002205
#define PGM_elementof 0x1002208
#define PGM_notelementof 0x1002209
#define PGM_containsas 0x100220b
#define PGM_squareroot 0x100221a
#define PGM_cuberoot 0x100221b
#define PGM_fourthroot 0x100221c
#define PGM_dintegral 0x100222c
#define PGM_tintegral 0x100222d
#define PGM_because 0x1002235
#define PGM_approxeq 0x1002248
#define PGM_notapproxeq 0x1002247
#define PGM_notidentical 0x1002262
#define PGM_stricteq 0x1002263

#endif /* __PGM_KEYSYMS_H__ */
