'''OpenGL extension SGI.color_table

Overview (from the spec)
	
	This extension defines a new RGBA-format color lookup mechanism.  It does
	not replace the color lookups defined by the GL Specification, but rather
	provides additional lookup capabilities with different operation.  The key
	difference is that the new lookup tables are treated as 1-dimensional images
	with internal formats, like texture images and convolution filter images.
	From this follows the fact that the new tables can operate on a subset of
	the components of passing pixel groups.  For example, a table with internal
	format ALPHA modifies only the A component of each pixel group, leaving the
	R, G, and B components unmodified.
	
	If EXT_copy_texture is implemented, this extension also defines methods to
	initialize the color lookup tables from the framebuffer, in addition to the
	standard memory source mechanisms.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGI/color_table.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGI_color_table'
GL_COLOR_TABLE_SGI = constant.Constant( 'GL_COLOR_TABLE_SGI', 0x80D0 )
glget.addGLGetConstant( GL_COLOR_TABLE_SGI, (1,) )
GL_POST_CONVOLUTION_COLOR_TABLE_SGI = constant.Constant( 'GL_POST_CONVOLUTION_COLOR_TABLE_SGI', 0x80D1 )
glget.addGLGetConstant( GL_POST_CONVOLUTION_COLOR_TABLE_SGI, (1,) )
GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = constant.Constant( 'GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI', 0x80D2 )
glget.addGLGetConstant( GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI, (1,) )
GL_PROXY_COLOR_TABLE_SGI = constant.Constant( 'GL_PROXY_COLOR_TABLE_SGI', 0x80D3 )
GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = constant.Constant( 'GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI', 0x80D4 )
GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = constant.Constant( 'GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI', 0x80D5 )
GL_COLOR_TABLE_SCALE_SGI = constant.Constant( 'GL_COLOR_TABLE_SCALE_SGI', 0x80D6 )
GL_COLOR_TABLE_BIAS_SGI = constant.Constant( 'GL_COLOR_TABLE_BIAS_SGI', 0x80D7 )
GL_COLOR_TABLE_FORMAT_SGI = constant.Constant( 'GL_COLOR_TABLE_FORMAT_SGI', 0x80D8 )
GL_COLOR_TABLE_WIDTH_SGI = constant.Constant( 'GL_COLOR_TABLE_WIDTH_SGI', 0x80D9 )
GL_COLOR_TABLE_RED_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_RED_SIZE_SGI', 0x80DA )
GL_COLOR_TABLE_GREEN_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_GREEN_SIZE_SGI', 0x80DB )
GL_COLOR_TABLE_BLUE_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_BLUE_SIZE_SGI', 0x80DC )
GL_COLOR_TABLE_ALPHA_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_ALPHA_SIZE_SGI', 0x80DD )
GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_LUMINANCE_SIZE_SGI', 0x80DE )
GL_COLOR_TABLE_INTENSITY_SIZE_SGI = constant.Constant( 'GL_COLOR_TABLE_INTENSITY_SIZE_SGI', 0x80DF )
glColorTableSGI = platform.createExtensionFunction( 
	'glColorTableSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLsizei, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glColorTableSGI( GLenum(target), GLenum(internalformat), GLsizei(width), GLenum(format), GLenum(type), c_void_p(table) ) -> None',
	argNames = ('target', 'internalformat', 'width', 'format', 'type', 'table',),
)

glColorTableParameterfvSGI = platform.createExtensionFunction( 
	'glColorTableParameterfvSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glColorTableParameterfvSGI( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glColorTableParameterivSGI = platform.createExtensionFunction( 
	'glColorTableParameterivSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glColorTableParameterivSGI( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glCopyColorTableSGI = platform.createExtensionFunction( 
	'glCopyColorTableSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei,),
	doc = 'glCopyColorTableSGI( GLenum(target), GLenum(internalformat), GLint(x), GLint(y), GLsizei(width) ) -> None',
	argNames = ('target', 'internalformat', 'x', 'y', 'width',),
)

glGetColorTableSGI = platform.createExtensionFunction( 
	'glGetColorTableSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glGetColorTableSGI( GLenum(target), GLenum(format), GLenum(type), c_void_p(table) ) -> None',
	argNames = ('target', 'format', 'type', 'table',),
)

glGetColorTableParameterfvSGI = platform.createExtensionFunction( 
	'glGetColorTableParameterfvSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetColorTableParameterfvSGI( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetColorTableParameterivSGI = platform.createExtensionFunction( 
	'glGetColorTableParameterivSGI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glGetColorTableParameterivSGI( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)


def glInitColorTableSGI():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
