/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.unix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixPasswdEntry {
    public static final String DEFAULT_FILE_NAME = "/etc/passwd";
    private String name;
    private String dummyPassword;
    private int uid;
    private int gid;
    private String loginClass;
    private String change;
    private String expire;
    private String gecos;
    private String homeDir;
    private String shell;
    static final Pattern patt = Pattern.compile("(\\w+):(.*?):(\\d+):(\\d+):(.*?):([/\\w]+):([/\\w]*)");

    public static List<UnixPasswdEntry> getPwEntries() throws IOException {
        return UnixPasswdEntry.getPwEntries(DEFAULT_FILE_NAME);
    }

    public static List<UnixPasswdEntry> getPwEntries(String fileName) throws IOException {
        ArrayList<UnixPasswdEntry> all = new ArrayList<UnixPasswdEntry>();
        BufferedReader rdr = new BufferedReader(new FileReader(fileName));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                Matcher m = patt.matcher(line);
                if (!m.matches()) {
                    throw new IOException("Line doesn't match RE " + line);
                }
                UnixPasswdEntry ent = new UnixPasswdEntry();
                ent.name = m.group(1);
                ent.dummyPassword = m.group(2);
                ent.uid = Integer.parseInt(m.group(3));
                ent.gid = Integer.parseInt(m.group(4));
                ent.gecos = m.group(5);
                ent.homeDir = m.group(6);
                ent.shell = m.group(7);
                all.add(ent);
            }
        }
        finally {
            if (rdr != null) {
                rdr.close();
            }
        }
        return all;
    }

    public String toString() {
        return String.format("pw_ent(%s, %d, %s, %s)", this.name, this.uid, this.gecos, this.homeDir);
    }

    public String getChange() {
        return this.change;
    }

    public void setChange(String change) {
        this.change = change;
    }

    public String getDummyPassword() {
        return this.dummyPassword;
    }

    public void setDummyPassword(String dummyPassword) {
        this.dummyPassword = dummyPassword;
    }

    public String getExpire() {
        return this.expire;
    }

    public void setExpire(String expire) {
        this.expire = expire;
    }

    public String getGecos() {
        return this.gecos;
    }

    public void setGecos(String gecos) {
        this.gecos = gecos;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public String getLoginClass() {
        return this.loginClass;
    }

    public void setLoginClass(String loginClass) {
        this.loginClass = loginClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShell() {
        return this.shell;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public static Pattern getPattern() {
        return patt;
    }
}

