/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.architect.profile.TableProfileResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProfileManager
implements ProfileManager {
    private static final Logger logger = Logger.getLogger(TableProfileManager.class);
    private TableProfileResult lastTableProfileResult = null;
    private final List<TableProfileResult> tableResults = new ArrayList<TableProfileResult>();
    private final Map<SQLTable, Integer> profileCounts = new HashMap<SQLTable, Integer>();
    private ProfileSettings settings = new ProfileSettings();
    List<ProfileChangeListener> listeners = new ArrayList<ProfileChangeListener>();

    private void putResult(TableProfileResult profileResult) {
        this.tableResults.add(profileResult);
        this.fireProfileAdded(profileResult);
        this.incrementTableProfileCountCache(profileResult);
    }

    private void incrementTableProfileCountCache(TableProfileResult profileResult) {
        Integer profileCount = this.profileCounts.get(profileResult.getProfiledObject());
        profileCount = profileCount == null ? Integer.valueOf(1) : Integer.valueOf(profileCount + 1);
        this.profileCounts.put((SQLTable)profileResult.getProfiledObject(), profileCount);
    }

    private void decrementTableProfileCountCache(TableProfileResult profileResult) {
        Integer profileCount = this.profileCounts.get(profileResult.getProfiledObject());
        logger.debug((Object)("Decrementing from " + profileCount));
        if (profileCount == null) {
            throw new IllegalStateException("Cannot remove a table from our cache, it's not there!");
        }
        if ((profileCount = Integer.valueOf(profileCount - 1)) > 0) {
            this.profileCounts.put((SQLTable)profileResult.getProfiledObject(), profileCount);
        } else {
            this.profileCounts.remove(profileResult.getProfiledObject());
        }
        logger.debug((Object)("Decrementing to " + this.profileCounts.get(profileResult.getProfiledObject())));
    }

    public void loadResult(ColumnProfileResult profileResult) {
        this.lastTableProfileResult.addColumnProfileResult(profileResult);
    }

    public void loadResult(TableProfileResult profileResult) {
        this.putResult(profileResult);
        this.lastTableProfileResult = profileResult;
    }

    public void loadManyResults(List results) {
        this.tableResults.addAll(results);
        this.profileCounts.clear();
        for (TableProfileResult result : this.tableResults) {
            this.incrementTableProfileCountCache(result);
        }
        this.fireProfilesAdded(results);
    }

    @Override
    public List<TableProfileResult> getTableResults() {
        return Collections.unmodifiableList(this.tableResults);
    }

    public boolean isTableProfiled(SQLTable table) {
        return this.profileCounts.containsKey(table);
    }

    public Collection<TableProfileResult> getTableResult(SQLTable t) {
        ArrayList<TableProfileResult> retCollection = new ArrayList<TableProfileResult>();
        for (TableProfileResult result : this.tableResults) {
            if (t != result.getProfiledObject()) continue;
            retCollection.add(result);
        }
        return retCollection;
    }

    public void asynchCreateProfiles(Collection<SQLTable> tables) throws SQLException, ArchitectException {
        final ArrayList<TableProfileResult> results = new ArrayList<TableProfileResult>();
        for (SQLTable t : tables) {
            TableProfileResult tpr = new TableProfileResult(t, this);
            results.add(tpr);
        }
        this.loadManyResults(results);
        new Thread(){

            public void run() {
                try {
                    for (TableProfileResult tpr : results) {
                        logger.debug((Object)"TableProfileManager.asynchCreateProfiles(): populate started");
                        tpr.populate();
                        logger.debug((Object)("populated: " + tpr));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public TableProfileResult createProfile(SQLTable table) throws SQLException, ArchitectException {
        TableProfileResult tableResult = new TableProfileResult(table, this);
        this.putResult(tableResult);
        tableResult.populate();
        return tableResult;
    }

    @Override
    public void clear() {
        for (TableProfileResult tpr : this.tableResults) {
            tpr.setCancelled(true);
        }
        this.tableResults.clear();
        this.profileCounts.clear();
        this.fireProfileChanged();
    }

    @Override
    public boolean removeProfile(TableProfileResult result) {
        logger.debug((Object)("ProfileManager: removing profiling for object: " + result.getProfiledObject()));
        if (this.tableResults.remove(result)) {
            result.setCancelled(true);
            this.decrementTableProfileCountCache(result);
            this.fireProfileRemoved(result);
            return true;
        }
        return false;
    }

    @Override
    public ProfileSettings getProfileSettings() {
        return this.settings;
    }

    @Override
    public void setProfileSettings(ProfileSettings settings) {
        this.settings = settings;
    }

    @Override
    public void addProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireProfileAdded(ProfileResult result) {
        ProfileChangeEvent event = new ProfileChangeEvent((Object)this, result);
        for (ProfileChangeListener listener : this.listeners) {
            listener.profilesAdded(event);
        }
    }

    private void fireProfilesAdded(List<ProfileResult> addedResultsList) {
        ProfileChangeEvent event = new ProfileChangeEvent((Object)this, addedResultsList);
        for (ProfileChangeListener listener : this.listeners) {
            listener.profilesAdded(event);
        }
    }

    private void fireProfilesRemoved(List<ProfileResult> removedResultsList) {
        ProfileChangeEvent event = new ProfileChangeEvent((Object)this, removedResultsList);
        for (ProfileChangeListener listener : this.listeners) {
            listener.profilesRemoved(event);
        }
    }

    private void fireProfileRemoved(ProfileResult removed) {
        ProfileChangeEvent event = new ProfileChangeEvent((Object)this, removed);
        for (ProfileChangeListener listener : this.listeners) {
            listener.profilesRemoved(event);
        }
    }

    private void fireProfileChanged() {
        List<ProfileResult> profileResultList = Collections.emptyList();
        ProfileChangeEvent event = new ProfileChangeEvent((Object)this, profileResultList);
        for (ProfileChangeListener listener : this.listeners) {
            listener.profileListChanged(event);
        }
    }
}

