/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.wizards.RubyNewClassWizardPage;

public class RubyNewClassWizard
extends Wizard
implements INewWizard {
    private static final String RUBY_FILE_EXTENSION = ".rb";
    private RubyNewClassWizardPage page;
    private ISelection selection;

    public RubyNewClassWizard() {
        this.setDefaultPageImageDescriptor(RubyPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new RubyNewClassWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String string = this.page.getContainerName();
        final String string2 = this.page.getClassName();
        final String string3 = this.page.getSuperclassName();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        RubyNewClassWizard.this.doFinish(string, string2, string3, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String string, String string2, String string3, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Creating " + string2, 2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (!iResource.exists() || !(iResource instanceof IContainer)) {
            this.throwCoreException("Container \"" + string + "\" does not exist.");
        }
        IContainer iContainer = (IContainer)iResource;
        String string4 = String.valueOf(this.classNameToFileName(string2)) + RUBY_FILE_EXTENSION;
        final IFile iFile = iContainer.getFile((IPath)new Path(string4));
        try {
            InputStream inputStream = this.openContentStream(string2, string3);
            if (iFile.exists()) {
                iFile.setContents(inputStream, true, true, iProgressMonitor);
            } else {
                iFile.create(inputStream, true, iProgressMonitor);
            }
            inputStream.close();
        }
        catch (IOException iOException) {}
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        iProgressMonitor.worked(1);
    }

    private String classNameToFileName(String string) {
        string = this.stripNamespace(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c)) {
                if (n != 0) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(Character.toLowerCase(c));
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String stripNamespace(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.lastIndexOf("::") != -1) {
            return string.substring(string.lastIndexOf("::") + 2);
        }
        return string;
    }

    private InputStream openContentStream(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class ");
        stringBuffer.append(string);
        if (string2 != null && !string2.equals("Object")) {
            stringBuffer.append(" < ");
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        stringBuffer.append(Indents.createIndentString((int)1, (Map)RubyCore.getOptions()));
        stringBuffer.append("\nend\n");
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    private void throwCoreException(String string) throws CoreException {
        Status status = new Status(4, "org.rubypeople.rdt.ui", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }
}

