/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.template.ruby;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyFormatter;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContext;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyTemplateMessages;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.MultiVariable;

public class RubyContext
extends RubyScriptContext {
    public RubyContext(TemplateContextType templateContextType, IDocument iDocument, int n, int n2, IRubyScript iRubyScript) {
        super(templateContextType, iDocument, n, n2, iRubyScript);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            throw new TemplateException(RubyTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator templateTranslator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String string, String string2, int[] nArray) {
                return new MultiVariable(string, string2, nArray);
            }
        };
        TemplateBuffer templateBuffer = templateTranslator.translate(template);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("templatesUseCodeFormatter");
        IRubyProject iRubyProject = this.getRubyScript() != null ? this.getRubyScript().getRubyProject() : null;
        RubyFormatter rubyFormatter = new RubyFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), bl, iRubyProject);
        rubyFormatter.format(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    private int getIndentation() {
        int n = this.getStart();
        IDocument iDocument = this.getDocument();
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            IRubyScript iRubyScript = this.getRubyScript();
            IRubyProject iRubyProject = iRubyScript == null ? null : iRubyScript.getRubyProject();
            return Strings.computeIndentUnits(string, iRubyProject);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String string = this.getKey();
        return template.matches(string, this.getContextType().getId()) && string.length() != 0 && template.getName().toLowerCase().startsWith(string.toLowerCase());
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getStart();
            int n2 = this.getCompletionOffset();
            return n <= n2 ? iDocument.get(n, n2 - n) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n2 - 1))) {
                --n2;
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public int getStart() {
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != 0 && Character.isUnicodeIdentifierPart(iDocument.getChar(n - 1))) {
                --n;
            }
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n))) {
                ++n;
            }
            if (n == n2) {
                n = this.getCompletionOffset();
            }
            return n;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }
}

