/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;

public class EventManager {
    static final boolean DEBUG = false;
    private EventThread thread = null;
    protected final String threadName;

    public EventManager() {
        this(null);
    }

    public EventManager(String threadName) {
        this.threadName = threadName;
    }

    public synchronized void close() {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    synchronized EventThread getEventThread() {
        if (this.thread == null) {
            this.thread = this.threadName == null ? new EventThread() : new EventThread(this.threadName);
            this.thread.start();
        }
        return this.thread;
    }

    static void dispatchEvent(EventListeners.ListElement[] listeners, EventDispatcher dispatcher, int eventAction, Object eventObject) {
        int size = listeners.length;
        int i = 0;
        while (i < size) {
            EventListeners.ListElement listener = listeners[i];
            if (listener == null) break;
            try {
                dispatcher.dispatchEvent(listener.primary, listener.companion, eventAction, eventObject);
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }

    static class EventThread
    extends Thread {
        private Queued head;
        private Queued tail;
        private volatile boolean running;

        EventThread(String threadName) {
            super(threadName);
            this.init();
        }

        EventThread() {
            this.init();
        }

        private void init() {
            this.running = true;
            this.head = null;
            this.tail = null;
            this.setDaemon(true);
        }

        void close() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (true) {
                    Queued item;
                    if ((item = this.getNextEvent()) == null) {
                        return;
                    }
                    EventManager.dispatchEvent(item.listeners, item.dispatcher, item.action, item.object);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }

        synchronized void postEvent(EventListeners.ListElement[] l, EventDispatcher d, int a, Object o) {
            if (!this.isAlive()) {
                throw new IllegalStateException();
            }
            Queued item = new Queued(l, d, a, o);
            if (this.head == null) {
                this.head = item;
                this.tail = item;
            } else {
                this.tail.next = item;
                this.tail = item;
            }
            this.notify();
        }

        private synchronized Queued getNextEvent() {
            while (this.running && this.head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.running) {
                return null;
            }
            Queued item = this.head;
            this.head = item.next;
            if (this.head == null) {
                this.tail = null;
            }
            return item;
        }

        private static class Queued {
            final EventListeners.ListElement[] listeners;
            final EventDispatcher dispatcher;
            final int action;
            final Object object;
            Queued next;

            Queued(EventListeners.ListElement[] l, EventDispatcher d, int a, Object o) {
                this.listeners = l;
                this.dispatcher = d;
                this.action = a;
                this.object = o;
                this.next = null;
            }
        }
    }
}

