/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntHomeClasspathEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.ant.ui.classpathentry.antHome";
    private String antHomeLocation = null;

    public AntHomeClasspathEntry() {
        this.antHomeLocation = null;
    }

    public AntHomeClasspathEntry(String antHome) {
        this.antHomeLocation = antHome;
    }

    protected void buildMemento(Document document, Element memento) throws CoreException {
        if (this.antHomeLocation == null) {
            memento.setAttribute("default", "true");
        } else {
            memento.setAttribute("antHome", new Path(this.antHomeLocation).toString());
        }
    }

    public void initializeFrom(Element memento) throws CoreException {
        String antHome = memento.getAttribute("antHome");
        if (antHome != null && antHome.length() > 0) {
            Path path = new Path(antHome);
            this.antHomeLocation = path.toOSString();
        } else {
            this.antHomeLocation = null;
        }
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> libs = new ArrayList<IRuntimeClasspathEntry>(40);
        AntCorePreferences preferences = AntCorePlugin.getPlugin().getPreferences();
        if (this.antHomeLocation == null) {
            IAntClasspathEntry[] entries = preferences.getAntHomeClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                IAntClasspathEntry entry = entries[i];
                libs.add(JavaRuntime.newStringVariableClasspathEntry((String)entry.getLabel()));
                ++i;
            }
        } else {
            File lib = this.resolveAntHome();
            IPath libDir = new Path(this.antHomeLocation).append("lib");
            String[] fileNames = lib.list();
            int i = 0;
            while (i < fileNames.length) {
                String name = fileNames[i];
                Path path = new Path(name);
                String fileExtension = path.getFileExtension();
                if ("jar".equalsIgnoreCase(fileExtension)) {
                    libs.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libDir.append((IPath)path)));
                }
                ++i;
            }
        }
        return libs.toArray(new IRuntimeClasspathEntry[libs.size()]);
    }

    public File resolveAntHome() throws CoreException {
        if (this.antHomeLocation == null) {
            return null;
        }
        IPath libDir = new Path(this.antHomeLocation).append("lib");
        File lib = libDir.toFile();
        File parentDir = lib.getParentFile();
        if (parentDir == null || !parentDir.exists()) {
            this.abort(MessageFormat.format((String)AntLaunchConfigurationMessages.AntHomeClasspathEntry_10, (Object[])new String[]{this.antHomeLocation}), null);
        }
        if (!lib.exists() || !lib.isDirectory()) {
            this.abort(MessageFormat.format((String)AntLaunchConfigurationMessages.AntHomeClasspathEntry_11, (Object[])new String[]{this.antHomeLocation}), null);
        }
        return lib;
    }

    public String getName() {
        if (this.antHomeLocation == null) {
            return AntLaunchConfigurationMessages.AntHomeClasspathEntry_8;
        }
        return MessageFormat.format((String)AntLaunchConfigurationMessages.AntHomeClasspathEntry_9, (Object[])new String[]{this.antHomeLocation});
    }

    public int getType() {
        return 5;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof AntHomeClasspathEntry && this.equalsOrNull(this.antHomeLocation, ((AntHomeClasspathEntry)((Object)obj)).antHomeLocation);
    }

    private boolean equalsOrNull(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    protected void setAntHome(String path) {
        this.antHomeLocation = path;
    }

    public String getAntHome() {
        if (this.antHomeLocation == null) {
            return AntCorePlugin.getPlugin().getPreferences().getAntHome();
        }
        return this.antHomeLocation;
    }
}

