/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.MemberDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class FieldDeclarationImpl
extends MemberDeclarationImpl
implements FieldDeclaration {
    public FieldDeclarationImpl(IVariableBinding binding, BaseProcessorEnv env) {
        super((IBinding)binding, env);
        assert (binding.isField()) : "binding doesn't represent a field";
    }

    public void accept(DeclarationVisitor visitor) {
        visitor.visitFieldDeclaration(this);
    }

    public String getConstantExpression() {
        IVariableBinding field = this.getDeclarationBinding();
        Object constant = field.getConstantValue();
        if (constant == null) {
            return null;
        }
        return constant.toString();
    }

    public Object getConstantValue() {
        IVariableBinding field = this.getDeclarationBinding();
        return field.getConstantValue();
    }

    public TypeDeclaration getDeclaringType() {
        IVariableBinding field = this.getDeclarationBinding();
        ITypeBinding outer = field.getDeclaringClass();
        return Factory.createReferenceType(outer, this._env);
    }

    public String getSimpleName() {
        IVariableBinding field = this.getDeclarationBinding();
        String name = field.getName();
        return name == null ? "" : name;
    }

    public TypeMirror getType() {
        IVariableBinding field = this.getDeclarationBinding();
        EclipseMirrorType typeMirror = Factory.createTypeMirror(field.getType(), this._env);
        if (typeMirror == null) {
            return Factory.createErrorClassType(field.getType());
        }
        return typeMirror;
    }

    public IVariableBinding getDeclarationBinding() {
        return (IVariableBinding)this._binding;
    }

    public String toString() {
        return this.getSimpleName();
    }

    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.FIELD;
    }

    public boolean isFromSource() {
        ITypeBinding type = this.getDeclarationBinding().getDeclaringClass();
        return type != null && type.isFromSource();
    }
}

