/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.JessieRSAPrivateKey;
import gnu.javax.net.ssl.provider.JessieRSAPublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;

final class KeyPool {
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    private static final BigInteger E = BigInteger.valueOf(65537L);
    private static final SecureRandom RANDOM = new SecureRandom();

    private KeyPool() {
    }

    static KeyPair generateRSAKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n = 256;
        BigInteger bigInteger4 = TWO.pow(255);
        BigInteger bigInteger5 = TWO.pow(256).subtract(ONE);
        byte[] byArray = new byte[32];
        do {
            KeyPool.nextBytes(byArray);
        } while ((bigInteger3 = new BigInteger(1, byArray).setBit(0)).compareTo(bigInteger4) < 0 || bigInteger3.compareTo(bigInteger5) > 0 || !bigInteger3.isProbablePrime(80) || !bigInteger3.gcd(E).equals(ONE));
        do {
            KeyPool.nextBytes(byArray);
        } while ((bigInteger2 = (bigInteger = new BigInteger(1, byArray).setBit(0)).multiply(bigInteger3)).bitLength() != 512 || !bigInteger.isProbablePrime(80) || !bigInteger.gcd(E).equals(ONE));
        BigInteger bigInteger6 = E.modInverse(bigInteger3.subtract(ONE).multiply(bigInteger.subtract(ONE)));
        return new KeyPair(new JessieRSAPublicKey(bigInteger2, E), new JessieRSAPrivateKey(bigInteger2, bigInteger6));
    }

    private static void nextBytes(byte[] byArray) {
        RANDOM.nextBytes(byArray);
    }
}

