/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.KeyStroke;

public class InputMap
implements Serializable {
    private static final long serialVersionUID = -5429059542008604257L;
    private Map inputMap;
    private InputMap parent;

    public Object get(KeyStroke keyStroke) {
        Object object = null;
        if (this.inputMap != null) {
            object = this.inputMap.get(keyStroke);
        }
        if (object == null && this.parent != null) {
            object = this.parent.get(keyStroke);
        }
        return object;
    }

    public void put(KeyStroke keyStroke, Object object) {
        if (keyStroke == null) {
            return;
        }
        if (this.inputMap == null) {
            this.inputMap = new HashMap();
        }
        if (object == null) {
            this.inputMap.remove(keyStroke);
        } else {
            this.inputMap.put(keyStroke, object);
        }
    }

    public void remove(KeyStroke keyStroke) {
        if (this.inputMap != null) {
            this.inputMap.remove(keyStroke);
        }
    }

    public InputMap getParent() {
        return this.parent;
    }

    public void setParent(InputMap inputMap) {
        this.parent = inputMap;
    }

    public int size() {
        int n = 0;
        if (this.inputMap != null) {
            n = this.inputMap.size();
        }
        return n;
    }

    public void clear() {
        if (this.inputMap != null) {
            this.inputMap.clear();
        }
    }

    public KeyStroke[] keys() {
        if (this.inputMap != null) {
            Object[] objectArray = new KeyStroke[this.size()];
            return (KeyStroke[])this.inputMap.keySet().toArray(objectArray);
        }
        return null;
    }

    public KeyStroke[] allKeys() {
        Object[] objectArray;
        HashSet hashSet = new HashSet();
        if (this.parent != null && (objectArray = this.parent.allKeys()) != null) {
            hashSet.addAll(Arrays.asList(objectArray));
        }
        if (this.inputMap != null) {
            hashSet.addAll(this.inputMap.keySet());
        }
        if (hashSet.size() == 0) {
            return null;
        }
        objectArray = new KeyStroke[hashSet.size()];
        return (KeyStroke[])hashSet.toArray(objectArray);
    }
}

