/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.GuiUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.SvnMapDialog;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;

public class SvnFormatSelector
implements ISVNAdminAreaFactorySelector {
    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        WorkingCopyFormat presetFormat;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return factories;
        }
        if (!writeAccess) {
            return factories;
        }
        WorkingCopyFormat format = SvnFormatSelector.getWorkingCopyFormat(path);
        Collection result = SvnFormatSelector.format2Factories(format, factories);
        if (result == null && (presetFormat = SvnWorkingCopyFormatHolder.getPresetFormat()) != null) {
            result = SvnFormatSelector.format2Factories(presetFormat, factories);
        }
        if (result == null) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY));
        }
        return result;
    }

    @Nullable
    static Collection format2Factories(WorkingCopyFormat format, Collection factories) {
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            return factories;
        }
        if (WorkingCopyFormat.ONE_DOT_FIVE.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor15(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_FOUR.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor14(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_THREE.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor13(factories);
        }
        return null;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor13(Collection factories) {
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            return Collections.singletonList(factory);
        }
        return Collections.emptyList();
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor14(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor15(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_FIVE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    public static String showUpgradeDialog(final File path, final Project project, final boolean display13format, String mode, final @NotNull Ref<Boolean> wasOk) {
        if (wasOk == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/idea/svn/SvnFormatSelector.showUpgradeDialog must not be null");
        }
        assert (!ApplicationManager.getApplication().isUnitTestMode());
        final String[] newMode = new String[]{mode};
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    wasOk.set((Object)SvnFormatSelector.displayUpgradeDialog(project, path, display13format, newMode));
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(SvnMapDialog.WC_CONVERTED)).run();
        return newMode[0];
    }

    public static WorkingCopyFormat getWorkingCopyFormat(File path) {
        int format = 0;
        try {
            format = SVNAdminAreaFactory.checkWC((File)path, (boolean)false);
        }
        catch (SVNException e) {
            // empty catch block
        }
        try {
            if (format == 0 && path.getParentFile() != null) {
                format = SVNAdminAreaFactory.checkWC((File)path.getParentFile(), (boolean)false);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return WorkingCopyFormat.getInstance(format);
    }

    private static boolean displayUpgradeDialog(Project project, File path, boolean dispay13format, String[] newMode) {
        UpgradeFormatDialog dialog = new UpgradeFormatDialog(project, path, false);
        dialog.setData(dispay13format, newMode[0]);
        dialog.show();
        if (dialog.isOK()) {
            newMode[0] = dialog.getUpgradeMode();
        }
        return dialog.isOK();
    }
}

