/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.StatusWalkerPartner;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnRecursiveStatusWalker {
    private final StatusWalkerPartner myPartner;
    private final StatusReceiver myReceiver;
    private final LinkedList<MyItem> myQueue;
    private final MyHandler myHandler;

    public SvnRecursiveStatusWalker(StatusReceiver receiver, StatusWalkerPartner partner) {
        this.myReceiver = receiver;
        this.myPartner = partner;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void go(FilePath rootPath, SVNDepth depth) throws SVNException {
        MyItem root = new MyItem(rootPath, depth, this.myPartner.createStatusClient(), false);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            this.myPartner.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            FilePath path = item.getPath();
            File ioFile = path.getIOFile();
            if (path.isDirectory()) {
                this.myHandler.setCurrentItem(item);
                try {
                    item.getClient().doStatus(ioFile, SVNRevision.WORKING, item.getDepth(), false, true, true, false, (ISVNStatusHandler)this.myHandler, null);
                    continue;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        VirtualFile virtualFile = path.getVirtualFile();
                        if (virtualFile == null) continue;
                        if (this.myPartner.isExcluded(virtualFile)) {
                            return;
                        }
                        this.myReceiver.processUnversioned(virtualFile);
                        this.processRecursively(virtualFile, item.getDepth());
                        continue;
                    }
                    throw e;
                }
            }
            if (item.isIsInnerCopyRoot()) {
                if (path.getVirtualFile() == null) continue;
                this.myReceiver.processUnversioned(path.getVirtualFile());
                continue;
            }
            SVNStatus status = item.getClient().doStatus(ioFile, false, false);
            this.myReceiver.process(path, status, false);
        }
    }

    private void processRecursively(VirtualFile vFile, SVNDepth prevDepth) {
        VirtualFile[] children;
        if (SVNDepth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.myPartner.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        SVNDepth newDepth = SVNDepth.INFINITY.equals((Object)prevDepth) ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        SVNStatusClient childClient = this.myPartner.createStatusClient();
        for (VirtualFile child : children = vFile.getChildren()) {
            FilePath filePath = VcsUtil.getFilePath((String)child.getPath(), (boolean)child.isDirectory());
            MyItem childItem = new MyItem(filePath, newDepth, childClient, true);
            this.myQueue.add(childItem);
        }
    }

    private class MyHandler
    implements ISVNStatusHandler {
        private MyItem myCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(MyItem currentItem) {
            this.myCurrentItem = currentItem;
        }

        public void handleStatus(SVNStatus status) throws SVNException {
            SvnRecursiveStatusWalker.this.myPartner.checkCanceled();
            FilePath path = VcsUtil.getFilePath((File)status.getFile(), (boolean)status.getKind().equals(SVNNodeKind.DIR));
            VirtualFile vFile = path.getVirtualFile();
            if (vFile != null && SvnRecursiveStatusWalker.this.myPartner.isExcluded(vFile)) {
                return;
            }
            if (vFile != null && status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
                SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                if (vFile.isDirectory()) {
                    SvnRecursiveStatusWalker.this.processRecursively(vFile, this.myCurrentItem.getDepth());
                }
            } else {
                SvnRecursiveStatusWalker.this.myReceiver.process(path, status, this.myCurrentItem.isIsInnerCopyRoot());
            }
        }
    }

    private static class MyItem {
        private final FilePath myPath;
        private final SVNDepth myDepth;
        private final SVNStatusClient myClient;
        private final boolean myIsInnerCopyRoot;

        private MyItem(FilePath path, SVNDepth depth, SVNStatusClient client, boolean isInnerCopyRoot) {
            this.myPath = path;
            this.myDepth = depth;
            this.myClient = client;
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public SVNDepth getDepth() {
            return this.myDepth;
        }

        public SVNStatusClient getClient() {
            return this.myClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }
    }
}

