/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.idea.RareLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopiesRefreshManager;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnHttpAuthMethodsDefaultChecker;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffWithLocalAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.dialogs.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnVcs
extends AbstractVcs {
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    private static final int ourLogUsualInterval = 20000;
    private static final int ourLogRareInterval = 30000;
    private static final Set<SVNErrorCode> ourLogRarely = new HashSet<SVNErrorCode>(Arrays.asList(SVNErrorCode.WC_UNSUPPORTED_FORMAT, SVNErrorCode.WC_CORRUPT, SVNErrorCode.WC_CORRUPT_TEXT_BASE, SVNErrorCode.WC_NOT_FILE, SVNErrorCode.WC_NOT_DIRECTORY, SVNErrorCode.WC_PATH_NOT_FOUND));
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance((String)"org.jetbrains.idea.svn.SvnVcs"));
    @NonNls
    public static final String VCS_NAME = "svn";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    private final Map<String, Map<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>>> myPropertyCache = new SoftHashMap();
    private final SvnConfiguration myConfiguration;
    private final SvnEntriesFileListener myEntriesFileListener;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private VcsHistoryProvider mySvnHistoryProvider;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final WorkingCopiesContent myWorkingCopiesContent;
    @NonNls
    public static final String LOG_PARAMETER_NAME = "javasvn.log";
    public static final String pathToEntries = SvnUtil.SVN_ADMIN_DIR_NAME + File.separatorChar + "entries";
    public static final String pathToDirProps = SvnUtil.SVN_ADMIN_DIR_NAME + File.separatorChar + "dir-props";
    private final SvnChangelistListener myChangeListListener;
    private SvnCopiesRefreshManager myCopiesRefreshManager;
    private SvnFileUrlMappingImpl myMapping;
    private final MyFrameStateListener myFrameStateListener;
    public static final Topic<Runnable> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Runnable.class);
    private VcsListener myVcsListener;
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final SvnAuthenticationNotifier myAuthNotifier;
    private static RareLogger.LogFilter[] ourLogFilters;
    private static final String UPGRADE_SUBVERSION_FORMAT = "Subversion";

    private static Boolean booleanProperty(String systemParameterName) {
        return Boolean.valueOf(System.getProperty(systemParameterName));
    }

    public SvnVcs(Project project, MessageBus bus, SvnConfiguration svnConfiguration, ChangeListManager changeListManager, VcsDirtyScopeManager vcsDirtyScopeManager) {
        super(project, VCS_NAME);
        LOG.debug("ct");
        this.myRootsToWorkingCopies = new RootsToWorkingCopies(this.myProject);
        this.myConfiguration = svnConfiguration;
        this.myAuthNotifier = new SvnAuthenticationNotifier(this);
        this.dumpFileStatus(FileStatus.ADDED);
        this.dumpFileStatus(FileStatus.DELETED);
        this.dumpFileStatus(FileStatus.MERGE);
        this.dumpFileStatus(FileStatus.MODIFIED);
        this.dumpFileStatus(FileStatus.NOT_CHANGED);
        this.dumpFileStatus(FileStatus.UNKNOWN);
        this.dumpFileStatus(SvnFileStatus.REPLACED);
        this.dumpFileStatus(SvnFileStatus.EXTERNAL);
        this.dumpFileStatus(SvnFileStatus.OBSTRUCTED);
        this.myEntriesFileListener = new SvnEntriesFileListener(project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
        } else {
            this.upgradeIfNeeded(bus);
            this.myChangeListListener = new SvnChangelistListener(this.myProject, this.createChangelistClient());
            this.myVcsListener = new VcsListener(){

                public void directoryMappingChanged() {
                    SvnVcs.this.invokeRefreshSvnRoots(true);
                }
            };
        }
        this.myFrameStateListener = new MyFrameStateListener(changeListManager, vcsDirtyScopeManager);
        this.myWorkingCopiesContent = new WorkingCopiesContent(this);
    }

    public void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myCopiesRefreshManager = new SvnCopiesRefreshManager(this.myProject, (SvnFileUrlMappingImpl)this.getSvnFileUrlMapping());
        this.invokeRefreshSvnRoots(true);
        this.myWorkingCopiesContent.activate();
    }

    public void invokeRefreshSvnRoots(boolean asynchronous) {
        REFRESH_LOG.debug("refresh: ", new Throwable());
        if (this.myCopiesRefreshManager != null) {
            if (asynchronous) {
                this.myCopiesRefreshManager.getCopiesRefresh().asynchRequest();
            } else if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        SvnVcs.this.myCopiesRefreshManager.getCopiesRefresh().synchRequest();
                    }
                }, SvnBundle.message("refreshing.working.copies.roots.progress.text", new Object[0]), true, this.myProject);
            } else {
                this.myCopiesRefreshManager.getCopiesRefresh().synchRequest();
            }
        }
    }

    public boolean checkImmediateParentsBeforeCommit() {
        return true;
    }

    private void upgradeIfNeeded(MessageBus bus) {
        final MessageBusConnection connection = bus.connect();
        connection.subscribe(ChangeListManagerImpl.LISTS_LOADED, (Object)new LocalChangeListsLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processLoadedLists(List<LocalChangeList> lists) {
                SvnConfiguration.SvnSupportOptions supportOptions = null;
                try {
                    ChangeListManager.getInstanceChecked((Project)SvnVcs.this.myProject).setReadOnly(SvnChangeProvider.ourDefaultListName, true);
                    supportOptions = SvnVcs.this.myConfiguration.getSupportOptions();
                    SvnVcs.this.upgradeToRecentVersion(supportOptions);
                    if (!supportOptions.changeListsSynchronized()) {
                        SvnVcs.this.processChangeLists(lists);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    if (supportOptions != null) {
                        supportOptions.upgrade();
                    }
                }
                connection.disconnect();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeLists(List<LocalChangeList> lists) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject);
        plVcsManager.startBackgroundVcsOperation();
        try {
            SVNChangelistClient client = this.createChangelistClient();
            for (LocalChangeList list : lists) {
                if (list.isDefault()) continue;
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    this.correctListForRevision(plVcsManager, change.getBeforeRevision(), client, list.getName());
                    this.correctListForRevision(plVcsManager, change.getAfterRevision(), client, list.getName());
                }
            }
        }
        catch (Throwable throwable) {
            Application appManager = ApplicationManager.getApplication();
            if (appManager.isDispatchThread()) {
                appManager.executeOnPooledThread(new Runnable(plVcsManager){
                    final /* synthetic */ ProjectLevelVcsManager val$plVcsManager;
                    {
                        this.val$plVcsManager = projectLevelVcsManager;
                    }

                    @Override
                    public void run() {
                        this.val$plVcsManager.stopBackgroundVcsOperation();
                    }
                });
            } else {
                plVcsManager.stopBackgroundVcsOperation();
            }
            throw throwable;
        }
        Application appManager = ApplicationManager.getApplication();
        if (appManager.isDispatchThread()) {
            appManager.executeOnPooledThread(new /* invalid duplicate definition of identical inner class */);
        } else {
            plVcsManager.stopBackgroundVcsOperation();
        }
    }

    private void correctListForRevision(ProjectLevelVcsManager plVcsManager, ContentRevision revision, SVNChangelistClient client, String name) {
        FilePath path;
        AbstractVcs vcs;
        if (revision != null && (vcs = plVcsManager.getVcsFor(path = revision.getFile())) != null && VCS_NAME.equals(vcs.getName())) {
            try {
                client.doAddToChangelist(new File[]{path.getIOFile()}, SVNDepth.EMPTY, name, null);
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
    }

    private void upgradeToRecentVersion(SvnConfiguration.SvnSupportOptions supportOptions) {
        SvnWorkingCopyChecker workingCopyChecker;
        if (!supportOptions.upgradeTo16Asked() && (workingCopyChecker = new SvnWorkingCopyChecker()).upgradeNeeded()) {
            Notifications.Bus.notify((Notification)new Notification(UPGRADE_SUBVERSION_FORMAT, SvnBundle.message("upgrade.format.to16.question.title", new Object[0]), "Old format Subversion working copies <a href=\"\">could be upgraded to version 1.6</a>.", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnVcs$5.hyperlinkUpdate must not be null");
                    }
                    if (event == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnVcs$5.hyperlinkUpdate must not be null");
                    }
                    int upgradeAnswer = Messages.showYesNoDialog((String)SvnBundle.message("upgrade.format.to16.question.text", SvnBundle.message("label.where.svn.format.can.be.changed.text", SvnBundle.message("action.show.svn.map.text.reference", new Object[0]))), (String)SvnBundle.message("upgrade.format.to16.question.title", new Object[0]), (Icon)Messages.getWarningIcon());
                    if (0 == upgradeAnswer) {
                        workingCopyChecker.doUpgrade();
                    }
                    notification.expire();
                }
            }));
        }
    }

    public void activate() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangeListListener);
            vcsManager.addVcsListener(this.myVcsListener);
        }
        SvnApplicationSettings.getInstance().svnActivated();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        LoadedRevisionsCache.getInstance(this.myProject);
        FrameStateManager.getInstance().addListener((FrameStateListener)this.myFrameStateListener);
        this.myAuthNotifier.init();
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this.myProject);
        this.mySvnBranchPointsCalculator.activate();
        if (SystemInfo.isWindows) {
            if (!SVNJNAUtil.isJNAPresent()) {
                Notifications.Bus.notify((Notification)new Notification("SVN_NO_JNA", "Subversion plugin: no JNA", "A problem with JNA initialization for svnkit library. Encryption is not available.", NotificationType.WARNING), (NotificationDisplayType)NotificationDisplayType.BALLOON, (Project)this.myProject);
            } else if (!SVNJNAUtil.isWinCryptEnabled()) {
                Notifications.Bus.notify((Notification)new Notification("SVN_NO_CRYPT32", "Subversion plugin: no encryption", "A problem with encryption module (Crypt32.dll) initialization for svnkit library. Encryption is not available.", NotificationType.WARNING), (NotificationDisplayType)NotificationDisplayType.BALLOON, (Project)this.myProject);
            }
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                SvnVcs.this.postStartup();
            }
        });
        vcsManager.addVcsListener((VcsListener)this.myRootsToWorkingCopies);
    }

    private static void initLogFilters() {
        if (ourLogFilters != null) {
            return;
        }
        ourLogFilters = new RareLogger.LogFilter[]{new RareLogger.LogFilter(){

            public Object getKey(@NotNull org.apache.log4j.Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
                if (level == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnVcs$7.getKey must not be null");
                }
                SVNException svnExc = null;
                if (t instanceof SVNException) {
                    svnExc = (SVNException)t;
                } else if (t instanceof VcsException && t.getCause() instanceof SVNException) {
                    svnExc = (SVNException)t.getCause();
                }
                if (svnExc != null && ourLogRarely.contains(svnExc.getErrorMessage().getErrorCode())) {
                    return svnExc.getErrorMessage().getErrorCode();
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Integer getAllowedLoggingInterval(org.apache.log4j.Level level, String message, Throwable t, String[] details) {
                Integer n;
                SVNException svnExc = null;
                if (t instanceof SVNException) {
                    svnExc = (SVNException)t;
                } else if (t instanceof VcsException && t.getCause() instanceof SVNException) {
                    svnExc = (SVNException)t.getCause();
                }
                if (svnExc != null) {
                    if (!(ourLogRarely.contains(svnExc.getErrorMessage().getErrorCode()) ? (n = Integer.valueOf(30000)) != null : (n = Integer.valueOf(20000)) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs$7.getAllowedLoggingInterval must not return null");
                    return n;
                }
                n = 0;
                if (n != null) return n;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs$7.getAllowedLoggingInterval must not return null");
            }
        }};
    }

    public static Logger wrapLogger(Logger logger) {
        SvnVcs.initLogFilters();
        return RareLogger.wrap((Logger)logger, (boolean)Boolean.getBoolean("svn.logger.fairsynch"), (RareLogger.LogFilter[])ourLogFilters);
    }

    public RootsToWorkingCopies getRootsToWorkingCopies() {
        return this.myRootsToWorkingCopies;
    }

    public SvnAuthenticationNotifier getAuthNotifier() {
        return this.myAuthNotifier;
    }

    public void deactivate() {
        FrameStateManager.getInstance().removeListener((FrameStateListener)this.myFrameStateListener);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.myVcsListener != null) {
            vcsManager.removeVcsListener(this.myVcsListener);
        }
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        SvnApplicationSettings.getInstance().svnDeactivated();
        new DefaultSVNRepositoryPool(null, null).shutdownConnections(true);
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        if (this.myChangeListListener != null && !this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangeListListener);
        }
        vcsManager.removeVcsListener((VcsListener)this.myRootsToWorkingCopies);
        this.myRootsToWorkingCopies.clear();
        this.myAuthNotifier.stop();
        this.myAuthNotifier.clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        this.myWorkingCopiesContent.deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        ChangeProvider changeProvider = this.myChangeProvider;
        if (changeProvider == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs.getChangeProvider must not return null");
        }
        return changeProvider;
    }

    public SVNRepository createRepository(String url) throws SVNException {
        SVNRepository repos = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
        repos.setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        repos.setTunnelProvider((ISVNTunnelProvider)this.myConfiguration.getOptions(this.myProject));
        return repos;
    }

    public SVNRepository createRepository(SVNURL url) throws SVNException {
        SVNRepository repos = SVNRepositoryFactory.create((SVNURL)url);
        repos.setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        repos.setTunnelProvider((ISVNTunnelProvider)this.myConfiguration.getOptions(this.myProject));
        return repos;
    }

    public SVNUpdateClient createUpdateClient() {
        return new SVNUpdateClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNStatusClient createStatusClient() {
        return new SVNStatusClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNWCClient createWCClient() {
        return new SVNWCClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNCopyClient createCopyClient() {
        return new SVNCopyClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNMoveClient createMoveClient() {
        return new SVNMoveClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNLogClient createLogClient() {
        return new SVNLogClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNCommitClient createCommitClient() {
        return new SVNCommitClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNDiffClient createDiffClient() {
        return new SVNDiffClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNChangelistClient createChangelistClient() {
        return new SVNChangelistClient((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this), this.myConfiguration.getOptions(this.myProject));
    }

    public SVNWCAccess createWCAccess() {
        SVNWCAccess access = SVNWCAccess.newInstance(null);
        access.setOptions(this.myConfiguration.getOptions(this.myProject));
        return access;
    }

    public ISVNOptions getSvnOptions() {
        return this.myConfiguration.getOptions(this.myProject);
    }

    public ISVNAuthenticationManager getSvnAuthenticationManager() {
        return this.myConfiguration.getAuthenticationManager(this);
    }

    void dumpFileStatus(FileStatus fs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("FileStatus:" + fs.getText() + " " + fs.getColor() + " " + " " + fs.getClass().getName());
        }
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment getUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    public String getDisplayName() {
        LOG.debug("getDisplayName");
        return UPGRADE_SUBVERSION_FORMAT;
    }

    public Configurable getConfigurable() {
        LOG.debug("createConfigurable");
        return new SvnConfigurable(this.myProject);
    }

    public SvnConfiguration getSvnConfiguration() {
        return this.myConfiguration;
    }

    public static SvnVcs getInstance(Project project) {
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment getCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs.getCheckinEnvironment must not return null");
        }
        return checkinEnvironment;
    }

    @NotNull
    public RollbackEnvironment getRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs.getRollbackEnvironment must not return null");
        }
        return rollbackEnvironment;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return this.myAnnotationProvider;
    }

    public SvnEntriesFileListener getSvnEntriesFileListener() {
        return this.myEntriesFileListener;
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    private Trinity<Long, Long, Long> getTimestampForPropertiesChange(File ioFile, boolean isDir) {
        File dir = isDir ? ioFile : ioFile.getParentFile();
        String relPath = SVNAdminUtil.getPropPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathBase = SVNAdminUtil.getPropBasePath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathRevert = SVNAdminUtil.getPropRevertPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        return new Trinity((Object)new File(dir, relPath).lastModified(), (Object)new File(dir, relPathBase).lastModified(), (Object)new File(dir, relPathRevert).lastModified());
    }

    private boolean trinitiesEqual(Trinity<Long, Long, Long> t1, Trinity<Long, Long, Long> t2) {
        if ((Long)t2.first == 0L && (Long)t2.second == 0L && (Long)t2.third == 0L) {
            return false;
        }
        return t1.equals(t2);
    }

    @Nullable
    public SVNPropertyValue getPropertyWithCaching(VirtualFile file, String propName) throws SVNException {
        SVNPropertyValue propValue;
        Map<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>> cachedMap = this.myPropertyCache.get(this.keyForVf(file));
        Pair<SVNPropertyValue, Trinity<Long, Long, Long>> cachedValue = cachedMap == null ? null : cachedMap.get(propName);
        File ioFile = new File(file.getPath());
        Trinity<Long, Long, Long> tsTrinity = this.getTimestampForPropertiesChange(ioFile, file.isDirectory());
        if (cachedValue != null && this.trinitiesEqual((Trinity<Long, Long, Long>)((Trinity)cachedValue.getSecond()), tsTrinity)) {
            return (SVNPropertyValue)cachedValue.getFirst();
        }
        SVNPropertyData value = this.createWCClient().doGetProperty(ioFile, propName, SVNRevision.WORKING, SVNRevision.WORKING);
        SVNPropertyValue sVNPropertyValue = propValue = value == null ? null : value.getValue();
        if (cachedMap == null) {
            cachedMap = new HashMap<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>>();
            this.myPropertyCache.put(this.keyForVf(file), cachedMap);
        }
        cachedMap.put(propName, (Pair<SVNPropertyValue, Trinity<Long, Long, Long>>)new Pair((Object)propValue, tsTrinity));
        return propValue;
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            SVNStatus status = this.createStatusClient().doStatus(file, false);
            if (status != null) {
                SVNStatusType statusType = status.getContentsStatus();
                if (statusType == SVNStatusType.STATUS_ADDED) {
                    return status.isCopied();
                }
                return status.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED && status.getContentsStatus() != SVNStatusType.STATUS_IGNORED && status.getContentsStatus() != SVNStatusType.STATUS_OBSTRUCTED;
            }
        }
        catch (SVNException e) {
            // empty catch block
        }
        return false;
    }

    public boolean fileIsUnderVcs(FilePath path) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        VirtualFile file = path.getVirtualFile();
        if (file == null) {
            return false;
        }
        return !SvnStatusUtil.isIgnoredInAnySense(clManager, file) && !clManager.isUnversioned(file);
    }

    private static File getEntriesFile(File file) {
        return file.isDirectory() ? new File(file, pathToEntries) : new File(file.getParentFile(), pathToEntries);
    }

    private static File getDirPropsFile(File file) {
        return new File(file, pathToDirProps);
    }

    @Nullable
    public SVNInfo getInfo(VirtualFile file) {
        try {
            SVNWCClient wcClient = new SVNWCClient(this.getSvnAuthenticationManager(), this.getSvnOptions());
            SVNInfo info = wcClient.doInfo(new File(file.getPath()), SVNRevision.WORKING);
            if (info == null || info.getRepositoryRootURL() == null) {
                info = wcClient.doInfo(new File(file.getPath()), SVNRevision.HEAD);
            }
            return info;
        }
        catch (SVNException e) {
            return null;
        }
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this.myProject);
        }
        SvnCommittedChangesProvider svnCommittedChangesProvider = this.myCommittedChangesProvider;
        if (svnCommittedChangesProvider == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs.getCommittedChangesProvider must not return null");
        }
        return svnCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        SVNRevision revision = SVNRevision.parse((String)revisionNumberString);
        if (revision.equals((Object)SVNRevision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        if (this.myMapping == null) {
            this.myMapping = SvnFileUrlMappingImpl.getInstance(this.myProject);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = this.myMapping;
        if (svnFileUrlMappingImpl == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnVcs.getSvnFileUrlMapping must not return null");
        }
        return svnFileUrlMappingImpl;
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info : infoList) {
            File file = info.getIoFile();
            infos.add(new WCInfo(file.getAbsolutePath(), info.getAbsoluteUrlAsUrl(), SvnFormatSelector.getWorkingCopyFormat(file), info.getRepositoryUrl(), SvnUtil.isWorkingCopyRoot(file), info.getType(), SvnUtil.getDepth(this, file), info.isRepoSupportsMergeInfo()));
        }
        return infos;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return this.getSvnFileUrlMapping();
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    public List<AnAction> getAdditionalActionsForLocalChange() {
        return Arrays.asList(new AnAction[]{new ShowPropertiesDiffWithLocalAction()});
    }

    private String keyForVf(VirtualFile vf) {
        return vf.getUrl();
    }

    public boolean allowsNestedRoots() {
        return SvnConfiguration.getInstance((Project)this.myProject).DETECT_NESTED_COPIES;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        if (in.size() <= 1) {
            return in;
        }
        ArrayList infos = new ArrayList(in.size());
        SvnFileUrlMappingImpl mapping = (SvnFileUrlMappingImpl)this.getSvnFileUrlMapping();
        LinkedList<S> notMatched = new LinkedList<S>();
        for (S s : in) {
            VirtualFile vf = (VirtualFile)convertor.convert(s);
            File ioFile = new File(vf.getPath());
            SVNURL url = mapping.getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair(vf, url.toString(), s));
        }
        ArrayList filtered = new ArrayList(infos.size());
        ForNestedRootChecker.filterOutSuperfluousChildren(this, infos, filtered);
        List converted = ObjectsConvertor.convert(filtered, (Convertor)new Convertor<MyPair<S>, S>(){

            public S convert(MyPair<S> o) {
                return o.getSrc();
            }
        });
        if (!notMatched.isEmpty()) {
            converted.addAll(notMatched);
        }
        return converted;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(VirtualFile root) {
        return ThreeState.YES.equals((Object)this.myAuthNotifier.isAuthenticatedFor(root));
    }

    public CommittedChangeList getRevisionChanges(VcsFileRevision revision, VirtualFile file) throws VcsException {
        return ShowAllSubmittedFilesAction.loadRevisions(this.getProject(), (SvnFileRevision)revision, file, false);
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    static {
        SVNJNAUtil.setJNAEnabled((boolean)true);
        SvnHttpAuthMethodsDefaultChecker.check();
        JavaSVNDebugLogger logger = new JavaSVNDebugLogger(Boolean.getBoolean(LOG_PARAMETER_NAME), LOG);
        SVNDebugLog.setDefaultLog((ISVNDebugLog)logger);
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnFormatSelector());
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (SystemInfo.isWindows) {
            SVNAdminArea14.setOptimizedWritingEnabled((boolean)true);
        }
        if (!SVNJNAUtil.isJNAPresent()) {
            LOG.warn("JNA is not found by svnkit library");
        }
        SvnVcs.initLogFilters();
    }

    private static class MyFrameStateListener
    implements FrameStateListener {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameDeactivated() {
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static class MyPair<T>
    implements RootUrlPair {
        private final VirtualFile myFile;
        private final String myUrl;
        private final T mySrc;

        private MyPair(VirtualFile file, String url, T src) {
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }
    }

    private class SvnWorkingCopyChecker {
        private List<WCInfo> myAllWcInfos;

        private SvnWorkingCopyChecker() {
        }

        public boolean upgradeNeeded() {
            this.myAllWcInfos = SvnVcs.this.getAllWcInfos();
            for (WCInfo info : this.myAllWcInfos) {
                if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)info.getFormat())) continue;
                return true;
            }
            return false;
        }

        public void doUpgrade() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnFormatWorker formatWorker = new SvnFormatWorker(SvnVcs.this.myProject, WorkingCopyFormat.ONE_DOT_SIX, SvnWorkingCopyChecker.this.myAllWcInfos);
                    formatWorker.checkForOutsideCopies();
                    if (formatWorker.haveStuffToConvert()) {
                        ProgressManager.getInstance().run((Task)formatWorker);
                    }
                }
            });
        }
    }

    private static class JavaSVNDebugLogger
    extends SVNDebugLogAdapter {
        private final boolean myLoggingEnabled;
        private final Logger myLog;
        @NonNls
        public static final String TRACE_LOG_PARAMETER_NAME = "javasvn.log.trace";

        public JavaSVNDebugLogger(boolean loggingEnabled, Logger log) {
            this.myLoggingEnabled = loggingEnabled;
            this.myLog = log;
        }

        public void log(SVNLogType logType, Throwable th, Level logLevel) {
            if (this.myLoggingEnabled) {
                this.myLog.info(th);
            }
        }

        public void log(SVNLogType logType, String message, Level logLevel) {
            if (this.myLoggingEnabled) {
                this.myLog.info(message);
            }
        }

        public void log(SVNLogType logType, String message, byte[] data) {
            if (this.myLoggingEnabled) {
                if (data != null) {
                    try {
                        this.myLog.info(message + "\n" + new String(data, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.myLog.info(message + "\n" + new String(data));
                    }
                } else {
                    this.myLog.info(message);
                }
            }
        }
    }

    public static class SVNInfoHolder {
        private final SVNInfo myValue;
        private final long myEntriesTimestamp;
        private final long myFileTimestamp;

        public SVNInfoHolder(long entriesStamp, long fileStamp, SVNInfo value) {
            this.myValue = value;
            this.myEntriesTimestamp = entriesStamp;
            this.myFileTimestamp = fileStamp;
        }

        public long getEntriesTimestamp() {
            return this.myEntriesTimestamp;
        }

        public long getFileTimestamp() {
            return this.myFileTimestamp;
        }

        public SVNInfo getInfo() {
            return this.myValue;
        }
    }

    public static class SVNStatusHolder {
        private final SVNStatus myValue;
        private final long myEntriesTimestamp;
        private final long myFileTimestamp;
        private final boolean myIsLocked;

        public SVNStatusHolder(long entriesStamp, long fileStamp, SVNStatus value) {
            this.myValue = value;
            this.myEntriesTimestamp = entriesStamp;
            this.myFileTimestamp = fileStamp;
            this.myIsLocked = value != null && value.isLocked();
        }

        public long getEntriesTimestamp() {
            return this.myEntriesTimestamp;
        }

        public long getFileTimestamp() {
            return this.myFileTimestamp;
        }

        public boolean isLocked() {
            return this.myIsLocked;
        }

        public SVNStatus getStatus() {
            return this.myValue;
        }
    }
}

