/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.CopiesPanel;

public class WorkingCopiesContent {
    private final SvnVcs myVcs;
    private Content myShownContent;

    public WorkingCopiesContent(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public void activate() {
        ChangesViewContentManager cvcm = ChangesViewContentManager.getInstance((Project)this.myVcs.getProject());
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        CopiesPanel copiesPanel = new CopiesPanel(this.myVcs.getProject());
        this.myShownContent = contentFactory.createContent(copiesPanel.getComponent(), SvnBundle.message("dialog.show.svn.map.title", new Object[0]), true);
        this.myShownContent.setCloseable(false);
        cvcm.addContent(this.myShownContent);
        this.myShownContent.setPreferredFocusableComponent(copiesPanel.getPrefferedFocusComponent());
    }

    public void deactivate() {
        if (this.myShownContent != null) {
            ChangesViewContentManager cvcm = ChangesViewContentManager.getInstance((Project)this.myVcs.getProject());
            cvcm.removeContent(this.myShownContent);
            this.myShownContent = null;
        }
    }
}

