/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class AddAction
extends BasicAction {
    static final Logger log = Logger.getInstance((String)"org.jetbrains.idea.svn.action.AddAction");

    @Override
    protected String getActionName(AbstractVcs vcs) {
        log.debug("enter: getActionName");
        return SvnBundle.message("action.name.add.files", vcs.getName());
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        return SvnStatusUtil.fileCanBeAdded(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        log.debug("enter: batchPerform");
        SvnVcs vcs = SvnVcs.getInstance(project);
        SVNWCClient wcClient = vcs.createWCClient();
        wcClient.setEventHandler((ISVNEventHandler)new AddEventListener(project));
        List<SVNException> exceptions = SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(wcClient, Arrays.asList(files), true);
        if (!exceptions.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>(exceptions.size());
            for (SVNException exception : exceptions) {
                messages.add(exception.getMessage());
            }
            throw new VcsException(messages);
        }
    }

    @Override
    protected boolean isBatchAction() {
        log.debug("enter: isBatchAction");
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        try {
            SVNWCClient wcClient = activeVcs.createWCClient();
            wcClient.setEventHandler((ISVNEventHandler)new AddEventListener(project));
            wcClient.doAdd(new File(file.getPath()), false, false, true, true);
        }
        catch (SVNException e) {
            VcsException ve = new VcsException((Throwable)e);
            ve.setVirtualFile(file);
            throw ve;
        }
    }

    private static class AddEventListener
    implements ISVNEventHandler {
        private final Project myProject;

        public AddEventListener(Project project) {
            this.myProject = project;
        }

        public void handleEvent(SVNEvent event, double progress) {
            VirtualFile vfile;
            if (event.getAction() == SVNEventAction.ADD && event.getFile() != null && (vfile = VirtualFileManager.getInstance().findFileByUrl("file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/'))) != null) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(vfile);
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }
    }
}

