/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.tmatesoft.svn.core.SVNURL;

public class DiffOptionsDialog
extends DialogWrapper
implements ActionListener {
    private final SVNURL myURL;
    private final Project myProject;
    private RepositoryBrowserComponent myBrowser;
    private final SVNURL myRootURL;
    private JRadioButton myUnifiedDiffButton;
    private JRadioButton myUIDiffButton;
    private TextFieldWithBrowseButton myFileBrowser;
    private JCheckBox myReverseDiffButton;
    private JLabel mySourceUrlLabel;
    private JPanel myMainPanel;
    private JLabel myErrorLabel;
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "diff.txt";

    public DiffOptionsDialog(Project project, SVNURL rootURL, SVNURL url) {
        super(project, true);
        this.myURL = url;
        this.myRootURL = rootURL;
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(SvnBundle.message("diff.options.title", objectArray));
        this.mySourceUrlLabel.setText(this.myURL.toString());
        this.myBrowser.setRepositoryURL(this.myRootURL, false);
        this.myBrowser.addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DiffOptionsDialog.this.update();
            }
        });
        this.myUIDiffButton.addActionListener(this);
        this.myUnifiedDiffButton.addActionListener(this);
        this.init();
        this.myFileBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DiffOptionsDialog.this.selectFile("Patch File", "Select file to store unified diff");
                if (f != null) {
                    if (f.exists() && f.isDirectory()) {
                        f = new File(f, DiffOptionsDialog.DEFAULT_PATCH_NAME);
                    }
                    DiffOptionsDialog.this.myFileBrowser.setText(f.getAbsolutePath());
                }
            }
        });
        this.myFileBrowser.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DiffOptionsDialog.this.update();
            }
        });
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            String projectDir = baseDir.getPath();
            projectDir = projectDir.replace('/', File.separatorChar);
            this.myFileBrowser.setText(projectDir + File.separatorChar + DEFAULT_PATCH_NAME);
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.diff.options";
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myBrowser);
    }

    public SVNURL getSourceURL() {
        return this.myURL;
    }

    public boolean isReverseDiff() {
        return this.myReverseDiffButton.isSelected();
    }

    public SVNURL getTargetURL() {
        if (this.getOKAction().isEnabled() && this.myBrowser.getSelectedNode() != null) {
            return this.myBrowser.getSelectedNode().getURL();
        }
        return null;
    }

    public File getTargetFile() {
        return new File(this.myFileBrowser.getText());
    }

    public boolean isUnifiedDiff() {
        return this.myUnifiedDiffButton.isSelected();
    }

    protected JComponent createCenterPanel() {
        this.update();
        return this.myMainPanel;
    }

    private void update() {
        RepositoryTreeNode baseNode = this.myBrowser.getSelectedNode();
        if (baseNode == null) {
            this.myErrorLabel.setText(SvnBundle.message("diff.options.no.url.error", new Object[0]));
            this.getOKAction().setEnabled(false);
            return;
        }
        if (this.myURL.equals((Object)this.getTargetURL())) {
            this.myErrorLabel.setText(SvnBundle.message("diff.options.same.url.error", new Object[0]));
            this.getOKAction().setEnabled(false);
            return;
        }
        if (this.myUnifiedDiffButton.isSelected() && (this.myFileBrowser.getText().length() == 0 || this.getTargetFile().getParentFile() == null)) {
            this.myErrorLabel.setText(SvnBundle.message("diff.options.no.patch.file.error", new Object[0]));
            this.getOKAction().setEnabled(false);
            return;
        }
        this.myErrorLabel.setText(" ");
        this.getOKAction().setEnabled(true);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowser;
    }

    @Nullable
    private File selectFile(String title, String description) {
        FileChooserDescriptor fcd = new FileChooserDescriptor(true, true, false, false, false, false);
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(title);
        fcd.setDescription(description);
        fcd.setHideIgnored(false);
        VirtualFile[] files = FileChooser.chooseFiles((Component)this.myBrowser, (FileChooserDescriptor)fcd, null);
        if (files.length != 1 || files[0] == null) {
            return null;
        }
        return new File(files[0].getPath());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myFileBrowser.setEnabled(this.myUnifiedDiffButton.isSelected());
        this.update();
    }

    private void createUIComponents() {
        this.myBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Compare:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.mySourceUrlLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("With:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints3);
        this.myReverseDiffButton = jCheckBox = new JCheckBox();
        jCheckBox.setText("Reverse Diff");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jCheckBox, gridBagConstraints4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jPanel2, gridBagConstraints5);
        Font font2 = jPanel2.getFont();
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Compare Type", 4, 2, new Font("Tahoma", 0, 11), new Color(-16777216)));
        this.myUIDiffButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Graphical Compare");
        jRadioButton2.setSelected(true);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jRadioButton2, gridBagConstraints6);
        this.myUnifiedDiffButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Unified Diff");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jRadioButton, gridBagConstraints7);
        this.myFileBrowser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        textFieldWithBrowseButton.setEnabled(false);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)textFieldWithBrowseButton, gridBagConstraints8);
        RepositoryBrowserComponent repositoryBrowserComponent = this.myBrowser;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 3;
        gridBagConstraints9.gridwidth = 3;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.fill = 1;
        jPanel.add((Component)repositoryBrowserComponent, gridBagConstraints9);
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        ((Component)jLabel).setForeground(Color.red);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 6;
        gridBagConstraints10.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints10);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

