/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnRepositoryBinaryContentRevision;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRepositoryContentRevision
implements ContentRevision {
    private final String myRepositoryRoot;
    private final SvnVcs myVcs;
    private final String myPath;
    @NotNull
    private final FilePath myFilePath;
    private final long myRevision;
    private String myContent;

    SvnRepositoryContentRevision(SvnVcs vcs, String repositoryRoot, String path, @Nullable FilePath localPath, long revision) {
        this.myVcs = vcs;
        this.myPath = path;
        this.myRepositoryRoot = repositoryRoot;
        this.myFilePath = localPath != null ? localPath : VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(this.myPath, false);
        this.myRevision = revision;
    }

    @Nullable
    public String getContent() throws VcsException {
        if (this.myContent == null) {
            ByteArrayOutputStream buffer = this.loadContent();
            this.myContent = CharsetToolkit.bytesToString((byte[])buffer.toByteArray());
        }
        return this.myContent;
    }

    protected ByteArrayOutputStream loadContent() throws VcsException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myPath, buffer, this.myRevision);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, null);
        } else {
            loader.run();
        }
        SVNException exception = loader.getException();
        if (exception != null) {
            throw new VcsException((Throwable)exception);
        }
        return buffer;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnRepositoryContentRevision.getFile must not return null");
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = new SvnRevisionNumber(SVNRevision.create((long)this.myRevision));
        if (svnRevisionNumber == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnRepositoryContentRevision.getRevisionNumber must not return null");
        }
        return svnRevisionNumber;
    }

    public static SvnRepositoryContentRevision create(SvnVcs vcs, String repositoryRoot, String path, @Nullable FilePath localPath, long revision) {
        int fileNamePos = path.lastIndexOf(47);
        if (fileNamePos >= 0) {
            String fileName = path.substring(fileNamePos);
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
            if (fileType.isBinary()) {
                return new SvnRepositoryBinaryContentRevision(vcs, repositoryRoot, path, localPath, revision);
            }
        }
        return new SvnRepositoryContentRevision(vcs, repositoryRoot, path, localPath, revision);
    }

    public String toString() {
        return this.myFilePath.getIOFile() + "#" + this.myRevision;
    }

    public String getFullPath() {
        String fullPath = this.myRepositoryRoot;
        if (!fullPath.endsWith("/") && !this.myPath.startsWith("/")) {
            fullPath = fullPath + "/";
        }
        fullPath = fullPath + this.myPath;
        return fullPath;
    }

    public String getPath() {
        return this.myPath;
    }

    private class ContentLoader
    implements Runnable {
        private final String myPath;
        private final long myRevision;
        private final OutputStream myDst;
        private SVNException myException;

        public ContentLoader(String path, OutputStream dst, long revision) {
            this.myPath = path;
            this.myDst = dst;
            this.myRevision = revision;
        }

        public SVNException getException() {
            return this.myException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myPath));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                SVNRepository repository = SvnRepositoryContentRevision.this.myVcs.createRepository(SvnRepositoryContentRevision.this.getFullPath());
                try {
                    repository.getFile("", this.myRevision, null, this.myDst);
                }
                finally {
                    repository.closeSession();
                }
            }
            catch (SVNException e) {
                this.myException = e;
            }
        }
    }
}

