/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spellchecker.DocCommentTokenizer;
import com.intellij.spellchecker.LiteralExpressionTokenizer;
import com.intellij.spellchecker.MethodNameTokenizerJava;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaSpellcheckingStrategy
extends SpellcheckingStrategy {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        Tokenizer tokenizer;
        if (element instanceof PsiMethod) {
            tokenizer = new MethodNameTokenizerJava();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof PsiDocComment) {
            tokenizer = new DocCommentTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof PsiLiteralExpression) {
            tokenizer = new LiteralExpressionTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof PsiNamedElement) {
            tokenizer = new NamedElementTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        tokenizer = super.getTokenizer(element);
        if (tokenizer != null) return tokenizer;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getTokenizer must not return null");
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdLanguages.JAVA;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/JavaSpellcheckingStrategy.getLanguage must not return null");
        }
        return language;
    }
}

