/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicMethodDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class DynamicMethodFix
implements IntentionAction {
    private final GrReferenceExpression myReferenceExpression;

    public DynamicMethodFix(GrReferenceExpression referenceExpression) {
        this.myReferenceExpression = referenceExpression;
    }

    @NotNull
    public String getText() {
        PsiType[] methodArgumentsTypes = PsiUtil.getArgumentTypes(this.myReferenceExpression, false);
        StringBuilder builder = new StringBuilder(" '").append(this.myReferenceExpression.getName());
        builder.append("(");
        assert (methodArgumentsTypes != null);
        for (int i = 0; i < methodArgumentsTypes.length; ++i) {
            PsiType type = methodArgumentsTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(type.getPresentableText());
        }
        builder.append(")");
        builder.append("' ");
        String string = GroovyBundle.message("add.dynamic.method", new Object[0]) + builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix.isAvailable must not be null");
        }
        return this.myReferenceExpression.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMethodFix.invoke must not be null");
        }
        DynamicMethodDialog dialog = new DynamicMethodDialog(this.myReferenceExpression);
        dialog.show();
    }

    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = QuickfixUtil.createSettings(this.myReferenceExpression);
        DynamicManager.getInstance(project).addMethod(settings);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }
}

