/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyReturnFromClosureCanBeImplicitInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'return' statement can be implicit" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection.getDisplayName must not return null");
        }
        return "'return' statement can be implicit";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement at end of a closure can be made implicit #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(PsiElement location) {
        return new MakeReturnImplicitFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            super.visitReturnStatement(returnStatement);
            GrExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrClosableBlock.class);
            if (closure == null) {
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrMethod.class);
            if (containingMethod != null && PsiTreeUtil.isAncestor((PsiElement)closure, (PsiElement)containingMethod, (boolean)true)) {
                return;
            }
            if (!ControlFlowUtils.closureCompletesWithStatement(closure, returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }
    }

    private static class MakeReturnImplicitFix
    extends GroovyFix {
        private MakeReturnImplicitFix() {
        }

        @NotNull
        public String getName() {
            if ("Make return implicit" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$MakeReturnImplicitFix.getName must not return null");
            }
            return "Make return implicit";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement returnKeywordElement = descriptor.getPsiElement();
            GrReturnStatement returnStatement = (GrReturnStatement)returnKeywordElement.getParent();
            assert (returnStatement != null);
            MakeReturnImplicitFix.replaceStatement((GrStatement)returnStatement, returnStatement.getReturnValue().getText());
        }
    }
}

