/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyStaticMethodNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        if ("Static method naming convention" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticMethodNamingConventionInspection.getDisplayName must not return null");
        }
        return "Static method naming convention";
    }

    @Override
    protected GroovyFix buildFix(PsiElement location) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Static method name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Static method name '#ref' is too long";
        }
        String string = "Static method name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticMethodNamingConventionInspection.buildErrorString must not return null");
        return string2;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            if (!grMethod.hasModifierProperty("static")) {
                return;
            }
            String name = grMethod.getName();
            if (GroovyStaticMethodNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerMethodError(grMethod, name);
        }
    }
}

