/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public class SingleCheckboxOptionsPanel
extends JPanel {
    public SingleCheckboxOptionsPanel(@NotNull String label, @NotNull BaseInspection owner, @NonNls String property) {
        if (label == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SingleCheckboxOptionsPanel.<init> must not be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/SingleCheckboxOptionsPanel.<init> must not be null");
        }
        super(new GridBagLayout());
        boolean selected = SingleCheckboxOptionsPanel.getPropertyValue(owner, property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        ButtonModel model = checkBox.getModel();
        SingleCheckboxChangeListener listener = new SingleCheckboxChangeListener(owner, property, model);
        model.addChangeListener(listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)checkBox, constraints);
    }

    private static boolean getPropertyValue(BaseInspection owner, String property) {
        try {
            Class<?> aClass = ((Object)((Object)owner)).getClass();
            Field field = aClass.getField(property);
            return field.getBoolean((Object)owner);
        }
        catch (IllegalAccessException ignore) {
            return false;
        }
        catch (NoSuchFieldException ignore) {
            return false;
        }
    }

    private static class SingleCheckboxChangeListener
    implements ChangeListener {
        private final BaseInspection owner;
        private final String property;
        private final ButtonModel model;

        SingleCheckboxChangeListener(BaseInspection owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SingleCheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(BaseInspection owner, String property, boolean selected) {
            try {
                Class<?> aClass = ((Object)((Object)owner)).getClass();
                Field field = aClass.getField(property);
                field.setBoolean((Object)owner, selected);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }
}

