/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;

public class DelegatedMembersHolder
implements CustomMembersHolder {
    private final Set<PsiMember> myMembers = new HashSet();

    public void addMember(PsiMember member) {
        this.myMembers.add(member);
    }

    @Override
    public boolean processMembers(PsiScopeProcessor processor) {
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String expectedName = nameHint == null ? null : nameHint.getName(ResolveState.initial());
        for (PsiMember member : this.myMembers) {
            if (expectedName != null && !expectedName.equals(member.getName()) || processor.execute((PsiElement)member, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }
}

