/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.GroovyWordsScanner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyFindUsagesProvider
implements FindUsagesProvider {
    public static final GroovyFindUsagesProvider INSTANCE = new GroovyFindUsagesProvider();

    @Nullable
    public GroovyWordsScanner getWordsScanner() {
        return new GroovyWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.canFindUsagesFor must not be null");
        }
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof GrVariable;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getHelpId must not be null");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getType must not be null");
        }
        if (element instanceof PsiClass) {
            return "class";
        }
        if (element instanceof PsiMethod) {
            return "method";
        }
        if (element instanceof PsiField) {
            return "field";
        }
        if (element instanceof PsiParameter) {
            return "parameter";
        }
        if (element instanceof PsiVariable) return "variable";
        if (element instanceof GrReferenceExpression) {
            return "variable";
        }
        if (!(element instanceof GrLabeledStatement)) return "";
        return "label";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getDescriptiveName must not be null");
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            if (qName == null) {
                return "";
            }
            String string2 = qName;
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getDescriptiveName must not return null");
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String result = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass clazz = method.getContainingClass();
            if (clazz != null) {
                result = result + " of " + this.getDescriptiveName((PsiElement)clazz);
            }
            String string3 = result;
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiVariable) {
            String name = ((PsiVariable)element).getName();
            if (name == null) return "";
            String string4 = name;
            string = string4;
            if (string4 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (!(element instanceof GrLabeledStatement)) return "";
        String string5 = ((GrLabeledStatement)element).getLabelName();
        string = string5;
        if (string5 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getDescriptiveName must not return null");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getNodeText must not be null");
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name == null) return "";
            String string2 = name;
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getNodeText must not return null");
        }
        if (element instanceof PsiMethod) {
            String string3 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (!(element instanceof PsiVariable)) return "";
        String name = ((PsiVariable)element).getName();
        if (name == null) return "";
        String string4 = name;
        string = string4;
        if (string4 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider.getNodeText must not return null");
        return string;
    }
}

