/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;

public class GradleIdeaSettingsNode
implements SettingsNodeVersion1 {
    public List<SettingsNodeVersion1> children = new ArrayList<SettingsNodeVersion1>();
    public String name;
    public String value;
    public GradleIdeaSettingsNode parent;

    public GradleIdeaSettingsNode(String name, GradleIdeaSettingsNode parent) {
        this.name = name;
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public List<SettingsNodeVersion1> getChildNodes() {
        return Collections.unmodifiableList(this.children);
    }

    public List<SettingsNodeVersion1> getChildNodes(String name) {
        ArrayList<SettingsNodeVersion1> matchingChildren = new ArrayList<SettingsNodeVersion1>();
        for (SettingsNodeVersion1 settingsNodeVersion1 : this.children) {
            if (!name.equals(settingsNodeVersion1.getName())) continue;
            matchingChildren.add(settingsNodeVersion1);
        }
        return matchingChildren;
    }

    public SettingsNodeVersion1 getChildNode(String name) {
        for (SettingsNodeVersion1 settingsNodeVersion1 : this.children) {
            if (!name.equals(settingsNodeVersion1.getName())) continue;
            return settingsNodeVersion1;
        }
        return null;
    }

    public SettingsNodeVersion1 addChild(String name) {
        GradleIdeaSettingsNode node = new GradleIdeaSettingsNode(name, this);
        this.children.add(node);
        return node;
    }

    public SettingsNodeVersion1 addChildIfNotPresent(String name) {
        SettingsNodeVersion1 child = this.getChildNode(name);
        if (child == null) {
            child = this.addChild(name);
        }
        return child;
    }

    public SettingsNodeVersion1 getNodeAtPath(String ... pathPortions) {
        String pathPortion;
        if (pathPortions == null || pathPortions.length == 0) {
            return null;
        }
        String firstPathPortion = pathPortions[0];
        SettingsNodeVersion1 currentNode = this.getChildNode(firstPathPortion);
        for (int index = 1; index < pathPortions.length && currentNode != null; currentNode = currentNode.getChildNode(pathPortion), ++index) {
            pathPortion = pathPortions[index];
        }
        return currentNode;
    }

    private SettingsNodeVersion1 getNodeAtPathCreateIfNotFound(String ... pathPortions) {
        if (pathPortions == null || pathPortions.length == 0) {
            return null;
        }
        String firstPathPortion = pathPortions[0];
        SettingsNodeVersion1 currentNode = this.getChildNode(firstPathPortion);
        if (currentNode == null) {
            currentNode = this.addChild(firstPathPortion);
        }
        for (int index = 1; index < pathPortions.length; ++index) {
            String pathPortion = pathPortions[index];
            if ((currentNode = currentNode.getChildNode(pathPortion)) != null) continue;
            currentNode = this.addChild(firstPathPortion);
        }
        return currentNode;
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public void removeFromParent() {
        if (this.parent != null && this.parent.removeChild(this)) {
            this.parent = null;
        }
    }

    private boolean removeChild(GradleIdeaSettingsNode node) {
        return this.children.remove(node);
    }

    public void setValueOfChild(String name, String value) {
        SettingsNodeVersion1 settingsNode = this.addChildIfNotPresent(name);
        settingsNode.setValue(value);
    }

    public String getValueOfChild(String name, String defaultValue) {
        SettingsNodeVersion1 settingsNode = this.getChildNode(name);
        if (settingsNode == null) {
            return defaultValue;
        }
        return settingsNode.getValue();
    }

    public int getValueOfChildAsInt(String name, int defaultValue) {
        SettingsNodeVersion1 settingsNode = this.getChildNode(name);
        if (settingsNode != null) {
            String value = settingsNode.getValue();
            try {
                if (value != null) {
                    return Integer.parseInt(value);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setValueOfChildAsInt(String name, int value) {
        this.setValueOfChild(name, Integer.toString(value));
    }

    public long getValueOfChildAsLong(String name, long defaultValue) {
        SettingsNodeVersion1 settingsNode = this.getChildNode(name);
        if (settingsNode != null) {
            String value = settingsNode.getValue();
            try {
                if (value != null) {
                    return Long.parseLong(value);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setValueOfChildAsLong(String name, long value) {
        this.setValueOfChild(name, Long.toString(value));
    }

    public boolean getValueOfChildAsBoolean(String name, boolean defaultValue) {
        String value;
        SettingsNodeVersion1 settingsNode = this.getChildNode(name);
        if (settingsNode != null && (value = settingsNode.getValue()) != null) {
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    public void setValueOfChildAsBoolean(String name, boolean value) {
        this.setValueOfChild(name, Boolean.toString(value));
    }

    public String toString() {
        return this.getName() + "='" + this.getValue() + "' " + this.children.size() + " children";
    }

    public void setChildren(List<GradleIdeaSettingsNode> newChildren) {
        this.children.clear();
        this.children.addAll(newChildren);
    }
}

