/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.modifiers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class ModifiersFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement parent;
        GrVariable variable;
        PsiElement parent2;
        if (GroovyCompletionUtil.asSimpleVariable(context) || GroovyCompletionUtil.asTypedMethod(context)) {
            return true;
        }
        if (GroovyCompletionUtil.isFirstElementAfterModifiersInVariableDeclaration(context, false)) {
            return true;
        }
        PsiElement contextParent = context.getParent();
        if (contextParent instanceof GrReferenceElement && contextParent.getParent() instanceof GrTypeElement && ((parent2 = contextParent.getParent().getParent()) instanceof GrVariableDeclaration && (parent2.getParent() instanceof GrTypeDefinitionBody || parent2.getParent() instanceof GroovyFile) || parent2 instanceof GrMethod)) {
            return true;
        }
        if (contextParent instanceof GrField && (variable = (GrVariable)contextParent).getTypeElementGroovy() == null) {
            return true;
        }
        if (contextParent instanceof GrExpression && contextParent.getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false)) {
            return true;
        }
        if (context.getTextRange().getStartOffset() == 0 && !(context instanceof OuterLanguageElement)) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null && GroovyCompletionUtil.isNewStatement(context, false) && (parent = leaf.getParent()) instanceof GroovyFile) {
            return true;
        }
        return contextParent instanceof GrExpression && contextParent.getParent() instanceof GrApplicationStatement && contextParent.getParent().getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false);
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "First filter for modifier keywords";
    }
}

