/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.modifiers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;

public class PreviousModifierFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        String[] modifiers = new String[]{"private", "public", "protected", "transient", "final", "abstract", "native", "threadsafe", "volatile", "strictfp", "synchronized"};
        if (element instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)element;
            for (String modifier : modifiers) {
                if (!modifier.equals(psiElement.getText().trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "Second filter for modifier keywords";
    }
}

