/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;

public class GrLiteralFixer
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof GrString) {
            String text = psiElement.getText();
            if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"\"\"")) {
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"\"\"\"")) {
                    editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"\"\"");
                }
            } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"") && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\"")) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"");
            }
        } else if (psiElement instanceof GrLiteral) {
            String text = psiElement.getText();
            if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'''")) {
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"'''")) {
                    editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'''");
                }
            } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'") && !StringUtil.endsWith((CharSequence)text, (CharSequence)"'")) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'");
            }
        }
    }
}

