/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GroovyQuoteHandler
implements QuoteHandler {
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_END) {
            return true;
        }
        if (tokenType == GroovyTokenTypes.mSTRING_LITERAL || tokenType == GroovyTokenTypes.mGSTRING_LITERAL) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 1 && offset == end - 1;
        }
        return false;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_BEGIN) {
            return true;
        }
        if (tokenType == GroovyTokenTypes.mGSTRING_LITERAL || tokenType == GroovyTokenTypes.mSTRING_LITERAL) {
            int start = iterator.getStart();
            return offset == start;
        }
        return false;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        return true;
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == GroovyTokenTypes.mSTRING_LITERAL || tokenType == GroovyTokenTypes.mGSTRING_LITERAL;
    }
}

