/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class OpenOrClosableBlock
implements GroovyElementTypes {
    public static boolean parseOpenBlock(PsiBuilder builder, GroovyParser parser) {
        return OpenOrClosableBlock.parseOpenBlockInDifferentContext(builder, false, parser);
    }

    public static boolean parseBlockStatement(PsiBuilder builder, GroovyParser parser) {
        return OpenOrClosableBlock.parseOpenBlockInDifferentContext(builder, true, parser);
    }

    public static boolean parseOpenBlockInDifferentContext(PsiBuilder builder, boolean isBlockStatement, GroovyParser parser) {
        PsiBuilder.Marker blockStatementMarker = builder.mark();
        PsiBuilder.Marker marker = builder.mark();
        if (!ParserUtils.getToken(builder, mLCURLY)) {
            marker.drop();
            blockStatementMarker.drop();
            return false;
        }
        ParserUtils.getToken(builder, mNLS);
        parser.parseBlockBody(builder);
        while (!builder.eof() && !mRCURLY.equals(builder.getTokenType())) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            builder.advanceLexer();
        }
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)OPEN_BLOCK);
        if (isBlockStatement) {
            blockStatementMarker.done((IElementType)BLOCK_STATEMENT);
        } else {
            blockStatementMarker.drop();
        }
        return true;
    }

    public static GroovyElementType parseClosableBlock(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (!ParserUtils.getToken(builder, mLCURLY)) {
            marker.drop();
            return WRONGWAY;
        }
        ParserUtils.getToken(builder, mNLS);
        OpenOrClosableBlock.closableBlockParamsOpt(builder, parser);
        parser.parseBlockBody(builder);
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)CLOSABLE_BLOCK);
        return CLOSABLE_BLOCK;
    }

    private static void closableBlockParamsOpt(PsiBuilder builder, GroovyParser parser) {
        ParameterList.parse(builder, mCLOSABLE_BLOCK_OP, parser);
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mCLOSABLE_BLOCK_OP);
    }
}

